/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.hive;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.data.hadoop.hive.HiveClient;
import org.springframework.data.hadoop.hive.HiveClientCallback;
import org.springframework.data.hadoop.hive.HiveClientFactory;
import org.springframework.data.hadoop.hive.HiveOperations;
import org.springframework.data.hadoop.hive.HiveScript;
import org.springframework.data.hadoop.hive.HiveUtils;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;

public class HiveTemplate
implements InitializingBean,
HiveOperations,
ResourceLoaderAware {
    private HiveClientFactory hiveClientFactory;
    private ResourceLoader resourceLoader;

    public HiveTemplate() {
    }

    public HiveTemplate(HiveClientFactory hiveClientFactory) {
        this.hiveClientFactory = hiveClientFactory;
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.hiveClientFactory, (String)"non-null hive client factory required");
    }

    @Override
    public <T> T execute(HiveClientCallback<T> action) throws DataAccessException {
        Assert.notNull(action, (String)"a valid callback is required");
        HiveClient hiveClient = this.createHiveClient();
        try {
            T t = action.doInHive(hiveClient);
            return t;
        }
        catch (Exception ex) {
            throw this.convertHiveAccessException(ex);
        }
        finally {
            try {
                hiveClient.shutdown();
            }
            catch (Exception ex) {
                throw new InvalidDataAccessResourceUsageException("Error while closing client connection", (Throwable)ex);
            }
        }
    }

    protected DataAccessException convertHiveAccessException(Exception ex) {
        return HiveUtils.convert(ex);
    }

    @Override
    public List<String> query(String query) throws DataAccessException {
        return this.query(query, null);
    }

    @Override
    public List<String> query(String query, Map<?, ?> arguments) throws DataAccessException {
        Assert.hasText((String)query, (String)"a script is required");
        ByteArrayResource res = null;
        if (ResourceUtils.isUrl((String)query)) {
            if (this.resourceLoader != null) {
                res = this.resourceLoader.getResource(query);
            }
        } else {
            res = new ByteArrayResource(query.getBytes());
        }
        return this.executeScript(new HiveScript((Resource)res, arguments));
    }

    @Override
    public String queryForString(String query) throws DataAccessException {
        return this.queryForString(query, null);
    }

    @Override
    public String queryForString(String query, Map<?, ?> arguments) throws DataAccessException {
        return (String)DataAccessUtils.singleResult(this.query(query, arguments));
    }

    @Override
    public Integer queryForInt(String query) throws DataAccessException {
        return this.queryForInt(query, null);
    }

    @Override
    public Integer queryForInt(String query, Map<?, ?> arguments) throws DataAccessException {
        String result = this.queryForString(query, arguments);
        if (result != null) {
            try {
                return Integer.valueOf(result);
            }
            catch (NumberFormatException ex) {
                throw new TypeMismatchDataAccessException("Invalid int result found [" + result + "]", (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public Long queryForLong(String query) throws DataAccessException {
        return this.queryForLong(query, null);
    }

    @Override
    public Long queryForLong(String query, Map<?, ?> arguments) throws DataAccessException {
        String result = this.queryForString(query, arguments);
        if (result != null) {
            try {
                return Long.valueOf(result);
            }
            catch (NumberFormatException ex) {
                throw new TypeMismatchDataAccessException("Invalid long result found [" + result + "]", (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public List<String> executeScript(HiveScript script) throws DataAccessException {
        return this.executeScript(Collections.singleton(script));
    }

    @Override
    public List<String> executeScript(final Iterable<HiveScript> scripts) throws DataAccessException {
        return this.execute(new HiveClientCallback<List<String>>(){

            @Override
            public List<String> doInHive(HiveClient hiveClient) throws Exception {
                return HiveUtils.run(hiveClient, scripts);
            }
        });
    }

    protected HiveClient createHiveClient() {
        return this.hiveClientFactory.getHiveClient();
    }

    public void setHiveClientFactory(HiveClientFactory hiveClientFactory) {
        this.hiveClientFactory = hiveClientFactory;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

