/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.config.common.annotation;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.hadoop.config.common.annotation.AnnotationBuilder;
import org.springframework.data.hadoop.config.common.annotation.AnnotationConfigurer;
import org.springframework.data.hadoop.config.common.annotation.EnableAnnotationConfiguration;
import org.springframework.util.ClassUtils;

public abstract class AbstractAnnotationConfiguration<B extends AnnotationBuilder<O>, O>
implements ImportAware,
BeanClassLoaderAware {
    private List<AnnotationConfigurer<O, B>> configurers;
    private ClassLoader beanClassLoader;
    private AnnotationAttributes annotationAttributes;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map enableConfigurationAttrMap = importMetadata.getAnnotationAttributes(EnableAnnotationConfiguration.class.getName());
        AnnotationAttributes enableConfigurationAttrs = AnnotationAttributes.fromMap((Map)enableConfigurationAttrMap);
        if (enableConfigurationAttrs == null) {
            Class currentClass;
            for (Class classToInspect = currentClass = ClassUtils.resolveClassName((String)importMetadata.getClassName(), (ClassLoader)this.beanClassLoader); classToInspect != null; classToInspect = classToInspect.getSuperclass()) {
                EnableAnnotationConfiguration enableConfigurationAnnotation = (EnableAnnotationConfiguration)AnnotationUtils.findAnnotation((Class)classToInspect, EnableAnnotationConfiguration.class);
                if (enableConfigurationAnnotation == null) continue;
                enableConfigurationAttrMap = AnnotationUtils.getAnnotationAttributes((Annotation)enableConfigurationAnnotation);
                enableConfigurationAttrs = AnnotationAttributes.fromMap((Map)enableConfigurationAttrMap);
            }
        }
        this.annotationAttributes = enableConfigurationAttrs;
    }

    @Autowired(required=false)
    public void setConfigurers(List<AnnotationConfigurer<O, B>> configurers) throws Exception {
        this.configurers = configurers;
        this.onConfigurers(configurers);
    }

    public AnnotationAttributes getAnnotationAttributes() {
        return this.annotationAttributes;
    }

    public List<AnnotationConfigurer<O, B>> getConfigurers() {
        return this.configurers;
    }

    protected abstract void onConfigurers(List<AnnotationConfigurer<O, B>> var1) throws Exception;
}

