/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.config.annotation.builders;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.data.hadoop.config.annotation.builders.HadoopConfigConfigurer;
import org.springframework.data.hadoop.config.common.annotation.AbstractConfiguredAnnotationBuilder;
import org.springframework.data.hadoop.config.common.annotation.ObjectPostProcessor;
import org.springframework.data.hadoop.config.common.annotation.configurers.DefaultPropertiesConfigurer;
import org.springframework.data.hadoop.config.common.annotation.configurers.DefaultResourceConfigurer;
import org.springframework.data.hadoop.config.common.annotation.configurers.DefaultSecurityConfigurer;
import org.springframework.data.hadoop.config.common.annotation.configurers.PropertiesConfigurer;
import org.springframework.data.hadoop.config.common.annotation.configurers.PropertiesConfigurerAware;
import org.springframework.data.hadoop.config.common.annotation.configurers.ResourceConfigurer;
import org.springframework.data.hadoop.config.common.annotation.configurers.ResourceConfigurerAware;
import org.springframework.data.hadoop.config.common.annotation.configurers.SecurityConfigurer;
import org.springframework.data.hadoop.config.common.annotation.configurers.SecurityConfigurerAware;
import org.springframework.data.hadoop.configuration.ConfigurationFactoryBean;
import org.springframework.data.hadoop.security.HadoopSecurity;
import org.springframework.data.hadoop.security.SecurityAuthMethod;

public final class HadoopConfigBuilder
extends AbstractConfiguredAnnotationBuilder<Configuration, HadoopConfigConfigurer, HadoopConfigBuilder>
implements PropertiesConfigurerAware,
ResourceConfigurerAware,
SecurityConfigurerAware,
HadoopConfigConfigurer {
    private final Set<Resource> resources = new HashSet<Resource>();
    private final Properties properties = new Properties();
    private HadoopSecurity hadoopSecurity;
    private String fileSystemUri;
    private String rmAddress;
    private String jobHistoryAddress;
    private boolean loadDefaults = true;

    public HadoopConfigBuilder() {
    }

    public HadoopConfigBuilder(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
    }

    @Override
    protected Configuration performBuild() throws Exception {
        ConfigurationFactoryBean fb = new ConfigurationFactoryBean();
        if (!this.loadDefaults) {
            fb.setConfiguration(new Configuration(false));
        }
        fb.setResources(this.resources);
        fb.setProperties(this.properties);
        fb.setFileSystemUri(this.fileSystemUri);
        fb.setRmManagerUri(this.rmAddress);
        fb.setJobHistoryUri(this.jobHistoryAddress);
        if (this.hadoopSecurity != null) {
            SecurityAuthMethod securityAuthMethod = this.hadoopSecurity.getSecurityAuthMethod();
            if (securityAuthMethod != null) {
                fb.setSecurityMethod(securityAuthMethod.toString().toLowerCase());
            }
            fb.setUserPrincipal(this.hadoopSecurity.getUserPrincipal());
            fb.setUserKeytab(this.hadoopSecurity.getUserKeytab());
            fb.setNamenodePrincipal(this.hadoopSecurity.getNamenodePrincipal());
            fb.setRmManagerPrincipal(this.hadoopSecurity.getRmManagerPrincipal());
        }
        fb.afterPropertiesSet();
        Configuration c = fb.getObject();
        c = this.postProcess(c);
        return c;
    }

    @Override
    public void configureProperties(Properties properties) {
        this.getProperties().putAll((Map<?, ?>)properties);
    }

    @Override
    public void configureResources(Set<Resource> resources) {
        this.getResources().addAll(resources);
    }

    @Override
    public void configureSecurity(HadoopSecurity hadoopSecurity) {
        this.hadoopSecurity = hadoopSecurity;
    }

    @Override
    public ResourceConfigurer<HadoopConfigConfigurer> withResources() throws Exception {
        return this.apply(new DefaultResourceConfigurer());
    }

    @Override
    public PropertiesConfigurer<HadoopConfigConfigurer> withProperties() throws Exception {
        return this.apply(new DefaultPropertiesConfigurer());
    }

    @Override
    public SecurityConfigurer<HadoopConfigConfigurer> withSecurity() throws Exception {
        return this.apply(new DefaultSecurityConfigurer());
    }

    @Override
    public HadoopConfigConfigurer fileSystemUri(String uri) {
        this.fileSystemUri = uri;
        return this;
    }

    @Override
    public HadoopConfigConfigurer resourceManagerAddress(String address) {
        this.rmAddress = address;
        return this;
    }

    @Override
    public HadoopConfigConfigurer jobHistoryAddress(String jobHistoryAddress) {
        this.jobHistoryAddress = jobHistoryAddress;
        return this;
    }

    @Override
    public HadoopConfigConfigurer loadDefaults(boolean loadDefaults) {
        this.loadDefaults = loadDefaults;
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Set<Resource> getResources() {
        return this.resources;
    }

    public HadoopSecurity getSecurity() {
        return this.hadoopSecurity;
    }
}

