/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.schema.support;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.springframework.context.ApplicationContext;
import org.springframework.data.gemfire.config.schema.support.RegionCollector;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RegionUtils;

public class ClientRegionCollector
extends RegionCollector {
    @Override
    public Set<Region> collectFrom(ApplicationContext applicationContext) {
        return this.onlyClientRegions((Set<Region>)super.collectFrom(applicationContext));
    }

    @Override
    public Set<Region> collectFrom(GemFireCache gemfireCache) {
        return this.onlyClientRegions((Set<Region>)super.collectFrom(gemfireCache));
    }

    private Set<Region> onlyClientRegions(Set<Region> regions) {
        return CollectionUtils.nullSafeSet(regions).stream().filter(RegionUtils::isClient).collect(Collectors.toSet());
    }
}

