/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.xml;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.client.PoolFactoryBean;
import org.springframework.data.gemfire.config.support.ClientRegionPoolBeanFactoryPostProcessor;
import org.springframework.data.gemfire.config.xml.ParsingUtils;
import org.springframework.data.gemfire.support.ConnectionEndpoint;
import org.springframework.data.gemfire.support.ConnectionEndpointList;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class PoolParser
extends AbstractSingleBeanDefinitionParser {
    static final AtomicBoolean INFRASTRUCTURE_COMPONENTS_REGISTERED = new AtomicBoolean(false);
    static final int DEFAULT_LOCATOR_PORT = 10334;
    static final int DEFAULT_SERVER_PORT = 40404;
    static final String DEFAULT_HOST = "localhost";
    static final String HOST_ATTRIBUTE_NAME = "host";
    static final String LOCATOR_ELEMENT_NAME = "locator";
    static final String LOCATORS_ATTRIBUTE_NAME = "locators";
    static final String PORT_ATTRIBUTE_NAME = "port";
    static final String SERVER_ELEMENT_NAME = "server";
    static final String SERVERS_ATTRIBUTE_NAME = "servers";

    PoolParser() {
    }

    private static void registerInfrastructureComponents(ParserContext parserContext) {
        if (INFRASTRUCTURE_COMPONENTS_REGISTERED.compareAndSet(false, true)) {
            BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(ClientRegionPoolBeanFactoryPostProcessor.class).setRole(2).getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        }
    }

    protected Class<?> getBeanClass(Element element) {
        return PoolFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder poolBuilder) {
        boolean noLocatorsOrServers;
        PoolParser.registerInfrastructureComponents(parserContext);
        ParsingUtils.setPropertyValue(element, poolBuilder, "free-connection-timeout");
        ParsingUtils.setPropertyValue(element, poolBuilder, "idle-timeout");
        ParsingUtils.setPropertyValue(element, poolBuilder, "keep-alive");
        ParsingUtils.setPropertyValue(element, poolBuilder, "load-conditioning-interval");
        ParsingUtils.setPropertyValue(element, poolBuilder, "max-connections");
        ParsingUtils.setPropertyValue(element, poolBuilder, "min-connections");
        ParsingUtils.setPropertyValue(element, poolBuilder, "multi-user-authentication");
        ParsingUtils.setPropertyValue(element, poolBuilder, "ping-interval");
        ParsingUtils.setPropertyValue(element, poolBuilder, "pr-single-hop-enabled");
        ParsingUtils.setPropertyValue(element, poolBuilder, "read-timeout");
        ParsingUtils.setPropertyValue(element, poolBuilder, "retry-attempts");
        ParsingUtils.setPropertyValue(element, poolBuilder, "server-group");
        ParsingUtils.setPropertyValue(element, poolBuilder, "socket-buffer-size");
        ParsingUtils.setPropertyValue(element, poolBuilder, "socket-connect-timeout");
        ParsingUtils.setPropertyValue(element, poolBuilder, "statistic-interval");
        ParsingUtils.setPropertyValue(element, poolBuilder, "subscription-ack-interval");
        ParsingUtils.setPropertyValue(element, poolBuilder, "subscription-enabled");
        ParsingUtils.setPropertyValue(element, poolBuilder, "subscription-message-tracking-timeout");
        ParsingUtils.setPropertyValue(element, poolBuilder, "subscription-redundancy");
        ParsingUtils.setPropertyValue(element, poolBuilder, "subscription-timeout-multiplier");
        ParsingUtils.setPropertyValue(element, poolBuilder, "thread-local-connections");
        List childElements = DomUtils.getChildElements((Element)element);
        ManagedList locators = new ManagedList(childElements.size());
        ManagedList servers = new ManagedList(childElements.size());
        CollectionUtils.nullSafeList(childElements).forEach(childElement -> {
            String childElementName = childElement.getLocalName();
            if (LOCATOR_ELEMENT_NAME.equals(childElementName)) {
                locators.add((Object)this.parseLocator((Element)childElement, parserContext));
            }
            if (SERVER_ELEMENT_NAME.equals(childElementName)) {
                servers.add((Object)this.parseServer((Element)childElement, parserContext));
            }
        });
        boolean hasLocators = this.parseLocators(element, parserContext, poolBuilder);
        boolean hasServers = this.parseServers(element, parserContext, poolBuilder);
        boolean bl = noLocatorsOrServers = locators.isEmpty() && servers.isEmpty() && !hasLocators && !hasServers;
        if (noLocatorsOrServers) {
            servers.add((Object)this.buildConnection(DEFAULT_HOST, String.valueOf(40404), true));
        }
        if (!locators.isEmpty()) {
            poolBuilder.addPropertyValue(LOCATORS_ATTRIBUTE_NAME, (Object)locators);
        }
        if (!servers.isEmpty()) {
            poolBuilder.addPropertyValue(SERVERS_ATTRIBUTE_NAME, (Object)servers);
        }
    }

    BeanDefinition buildConnection(String host, String port, boolean server) {
        BeanDefinitionBuilder connectionEndpointBuilder = BeanDefinitionBuilder.genericBeanDefinition(ConnectionEndpoint.class);
        connectionEndpointBuilder.addConstructorArgValue((Object)this.defaultHost(host));
        connectionEndpointBuilder.addConstructorArgValue((Object)this.defaultPort(port, server));
        return connectionEndpointBuilder.getBeanDefinition();
    }

    BeanDefinition buildConnections(String expression, boolean server) {
        BeanDefinitionBuilder connectionEndpointListBuilder = BeanDefinitionBuilder.genericBeanDefinition(ConnectionEndpointList.class);
        connectionEndpointListBuilder.setFactoryMethod("parse");
        connectionEndpointListBuilder.addConstructorArgValue((Object)this.defaultPort(null, server));
        connectionEndpointListBuilder.addConstructorArgValue((Object)expression);
        return connectionEndpointListBuilder.getBeanDefinition();
    }

    String defaultHost(String host) {
        return StringUtils.hasText((String)host) ? host : DEFAULT_HOST;
    }

    int defaultPort(boolean server) {
        return server ? 40404 : 10334;
    }

    String defaultPort(String port, boolean server) {
        return StringUtils.hasText((String)port) ? port : String.valueOf(this.defaultPort(server));
    }

    BeanDefinition parseLocator(Element element, ParserContext parserContext) {
        return this.buildConnection(element.getAttribute(HOST_ATTRIBUTE_NAME), element.getAttribute(PORT_ATTRIBUTE_NAME), false);
    }

    boolean parseLocators(Element element, ParserContext parserContext, BeanDefinitionBuilder poolBuilder) {
        String locatorsAttributeValue = element.getAttribute(LOCATORS_ATTRIBUTE_NAME);
        if (StringUtils.hasText((String)locatorsAttributeValue)) {
            poolBuilder.addPropertyValue("xmlDeclaredLocators", (Object)this.buildConnections(locatorsAttributeValue, false));
            return true;
        }
        return false;
    }

    BeanDefinition parseServer(Element element, ParserContext parserContext) {
        return this.buildConnection(element.getAttribute(HOST_ATTRIBUTE_NAME), element.getAttribute(PORT_ATTRIBUTE_NAME), true);
    }

    boolean parseServers(Element element, ParserContext parserContext, BeanDefinitionBuilder poolBuilder) {
        String serversAttributeValue = element.getAttribute(SERVERS_ATTRIBUTE_NAME);
        if (StringUtils.hasText((String)serversAttributeValue)) {
            poolBuilder.addPropertyValue("xmlDeclaredServers", (Object)this.buildConnections(serversAttributeValue, true));
            return true;
        }
        return false;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        if (!StringUtils.hasText((String)id)) {
            id = "gemfirePool";
            parserContext.getRegistry().registerAlias("gemfirePool", "gemfire-pool");
        }
        return id;
    }
}

