/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.function.Supplier;
import org.apache.shiro.util.Assert;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.EnableSecurity;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.config.annotation.support.Authentication;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

@Configuration
public class AuthenticationBeanConfiguration
extends AbstractAnnotationConfigSupport
implements ImportAware {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private String username;
    private String password;

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableSecurity.class;
    }

    protected void setUsername(@Nullable String username) {
        this.username = username;
    }

    @Nullable
    private String getUsername() {
        return this.username;
    }

    protected void setPassword(@Nullable String password) {
        this.password = password;
    }

    @Nullable
    private String getPassword() {
        return this.password;
    }

    public void setImportMetadata(@NonNull AnnotationMetadata importMetadata) {
        if (this.isAnnotationPresent(importMetadata)) {
            AnnotationAttributes enableSecurityAttributes = this.getAnnotationAttributes(importMetadata);
            this.setUsername(this.resolveProperty(this.securityProperty("username"), String.class, enableSecurityAttributes.getString("securityUsername")));
            this.setPassword(this.resolveProperty(this.securityProperty("password"), String.class, enableSecurityAttributes.getString("securityPassword")));
        }
    }

    @Bean
    @NonNull
    public Authentication<String, String> springDataGeodeAuthentication() {
        return SpringDataGeodeAuthentication.from(this::getUsername, this::getPassword);
    }

    private void registerAuthenticationBean(@NonNull BeanDefinitionRegistry registry, @NonNull BeanNameGenerator beanNameGenerator) {
        if (this.isAuthenticationCredentialsSet(this.getUsername(), this.nullSafeToCharArray(this.getPassword()))) {
            AbstractBeanDefinition authenticationBean = BeanDefinitionBuilder.rootBeanDefinition(SpringDataGeodeAuthentication.class).addConstructorArgValue((Object)this.getUsername()).addConstructorArgValue((Object)this.getPassword()).setRole(2).getBeanDefinition();
            String beanName = beanNameGenerator.generateBeanName((BeanDefinition)authenticationBean, registry);
            registry.registerBeanDefinition(beanName, (BeanDefinition)authenticationBean);
        }
    }

    protected boolean isAuthenticationCredentialsSet(String username, char[] password) {
        return StringUtils.hasText((String)username) && this.nullSafeCharArray(password).length > 0;
    }

    @NonNull
    private char[] nullSafeCharArray(@Nullable char[] array) {
        return array != null ? array : EMPTY_CHAR_ARRAY;
    }

    @NonNull
    private char[] nullSafeToCharArray(@Nullable String value) {
        return value != null ? value.trim().toCharArray() : EMPTY_CHAR_ARRAY;
    }

    protected static class SpringDataGeodeAuthentication
    implements Authentication<String, String> {
        private final Supplier<String> username;
        private final Supplier<String> password;

        @NonNull
        public static SpringDataGeodeAuthentication from(@NonNull Supplier<String> username, @NonNull Supplier<String> password) {
            return new SpringDataGeodeAuthentication(username, password);
        }

        protected SpringDataGeodeAuthentication(@NonNull Supplier<String> username, @NonNull Supplier<String> password) {
            this.username = this.require(username, "Username [%s] is required", username);
            this.password = this.require(password, "Password [%s] is required", password);
        }

        private <T> T require(T target, String message, Object ... arguments) {
            Assert.notNull(target, (String)String.format(message, arguments));
            return target;
        }

        @Override
        public boolean isRequested() {
            return StringUtils.hasText((String)this.getPrincipal()) && StringUtils.hasText((String)this.getCredentials());
        }

        @Override
        @NonNull
        public String getPrincipal() {
            return this.username.get();
        }

        @Override
        @NonNull
        public String getCredentials() {
            return this.password.get();
        }

        public String toString() {
            return this.getPrincipal();
        }
    }
}

