/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.util.Optional;
import java.util.Properties;
import org.apache.shiro.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.data.gemfire.GemFireProperties;
import org.springframework.data.gemfire.config.annotation.ClientCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.EnableBeanFactoryLocator;
import org.springframework.data.gemfire.config.annotation.LocatorConfigurer;
import org.springframework.data.gemfire.config.annotation.PeerCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.support.Authentication;
import org.springframework.data.gemfire.config.annotation.support.AutoConfiguredAuthenticationInitializer;
import org.springframework.data.gemfire.config.support.RestTemplateConfigurer;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

@Configuration
@EnableBeanFactoryLocator
@Conditional(value={AuthenticationAutoConfigurationEnabledCondition.class})
public class AutoConfiguredAuthenticationConfiguration {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    protected static final String AUTO_CONFIGURED_AUTH_INIT_STATIC_FACTORY_METHOD = AutoConfiguredAuthenticationInitializer.class.getName().concat(".newAuthenticationInitializer");
    protected static final String DEFAULT_USERNAME = "test";
    protected static final String DEFAULT_PASSWORD = "test";
    protected static final String HTTP_PROTOCOL = "HTTP";
    protected static final String PROPERTY_SOURCE_NAME = AutoConfiguredAuthenticationConfiguration.class.getName();
    protected static final String SECURITY_CLIENT_AUTH_INIT = GemFireProperties.SECURITY_CLIENT_AUTH_INIT.getName();
    protected static final String SECURITY_PEER_AUTH_INIT = GemFireProperties.SECURITY_PEER_AUTH_INIT.getName();
    protected static final String SECURITY_USERNAME = "security-username";
    protected static final String SECURITY_PASSWORD = "security-password";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @NonNull
    protected Logger getLogger() {
        return this.logger;
    }

    protected void logDebug(String message, Object ... args) {
        Logger logger = this.getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug(message, args);
        }
    }

    @Bean(value={"GemFireSecurityAuthenticator"})
    @Nullable
    public Authenticator authenticator(@Autowired(required=false) @Lazy Authentication<String, String> authentication) {
        return Optional.ofNullable(authentication).filter(Authentication::isRequested).map(this::newAuthenticator).map(this::registerAuthenticator).orElse(null);
    }

    @NonNull
    private Authenticator newAuthenticator(final @NonNull Authentication<String, String> authentication) {
        Assert.notNull(authentication, (String)"Authentication must not be null");
        Assert.state((boolean)authentication.isRequested(), (String)"Authentication was not requested");
        return new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                String username = (String)authentication.getPrincipal();
                String password = (String)authentication.getCredentials();
                return new PasswordAuthentication(username, password.toCharArray());
            }
        };
    }

    @NonNull
    private Authenticator registerAuthenticator(@NonNull Authenticator authenticator) {
        if (authenticator != null) {
            Authenticator.setDefault(authenticator);
        }
        return authenticator;
    }

    @NonNull
    ClientHttpRequestInterceptor loggingAwareClientHttpRequestInterceptor() {
        return (request, body, execution) -> {
            this.logDebug("HTTP Request URI [{}]", request.getURI());
            HttpHeaders httpHeaders = request.getHeaders();
            CollectionUtils.nullSafeSet(httpHeaders.keySet()).forEach(httpHeaderName -> this.logDebug("HTTP Request Header Name [{}] Value [{}]", httpHeaderName, httpHeaders.get(httpHeaderName)));
            ClientHttpResponse response = execution.execute(request, body);
            try {
                this.logDebug("HTTP Response Status Code [{}] Message [{}]", response.getStatusCode().value(), response.getStatusText());
            }
            catch (IOException cause) {
                this.logDebug("Error occurred getting HTTP Response Status Code and Message", cause);
            }
            return response;
        };
    }

    @Bean
    public RestTemplateConfigurer loggingAwareRestTemplateConfigurer() {
        return restTemplate -> restTemplate.getInterceptors().add(this.loggingAwareClientHttpRequestInterceptor());
    }

    @NonNull
    ClientHttpRequestInterceptor securityAwareClientHttpRequestInterceptor() {
        return (request, body, execution) -> {
            char[] password;
            String username;
            URI uri = request.getURI();
            PasswordAuthentication passwordAuthentication = Authenticator.requestPasswordAuthentication(uri.getHost(), null, uri.getPort(), HTTP_PROTOCOL, null, uri.getScheme());
            if (passwordAuthentication != null && this.isAuthenticationCredentialsSet(username = passwordAuthentication.getUserName(), password = passwordAuthentication.getPassword())) {
                HttpHeaders requestHeaders = request.getHeaders();
                requestHeaders.add(SECURITY_USERNAME, username);
                requestHeaders.add(SECURITY_PASSWORD, String.valueOf(password));
            }
            return execution.execute(request, body);
        };
    }

    @Bean
    public RestTemplateConfigurer securityAwareRestTemplateConfigurer() {
        return restTemplate -> restTemplate.getInterceptors().add(this.securityAwareClientHttpRequestInterceptor());
    }

    private boolean isAuthenticationCredentialsSet(String username, char[] password) {
        return StringUtils.hasText((String)username) && this.nullSafeCharArray(password).length > 0;
    }

    @NonNull
    private char[] nullSafeCharArray(@Nullable char[] array) {
        return array != null ? array : EMPTY_CHAR_ARRAY;
    }

    @Bean
    public ClientCacheConfigurer authenticationInitializingClientCacheConfigurer(@Autowired(required=false) @Lazy Authentication<String, String> authentication) {
        return (beanName, clientCacheFactoryBean) -> this.initializeMemberAuthentication(clientCacheFactoryBean.getProperties(), authentication);
    }

    @Bean
    public LocatorConfigurer authenticationInitializingLocatorConfigurer(@Autowired(required=false) @Lazy Authentication<String, String> authentication) {
        return (beanName, locatorFactoryBean) -> this.initializeMemberAuthentication(locatorFactoryBean.getGemFireProperties(), authentication);
    }

    @Bean
    public PeerCacheConfigurer authenticationInitializingPeerCacheConfigurer(@Autowired(required=false) @Lazy Authentication<String, String> authentication) {
        return (beanName, cacheFactoryBean) -> this.initializeMemberAuthentication(cacheFactoryBean.getProperties(), authentication);
    }

    private void initializeMemberAuthentication(Properties gemfireProperties, @Nullable Authentication<String, String> authentication) {
        Optional.ofNullable(gemfireProperties).filter(properties -> this.isAuthenticationRequested(authentication)).ifPresent(properties -> {
            properties.setProperty(SECURITY_CLIENT_AUTH_INIT, AUTO_CONFIGURED_AUTH_INIT_STATIC_FACTORY_METHOD);
            properties.setProperty(SECURITY_PEER_AUTH_INIT, AUTO_CONFIGURED_AUTH_INIT_STATIC_FACTORY_METHOD);
        });
    }

    private boolean isAuthenticationRequested(@Nullable Authentication<?, ?> authentication) {
        return authentication != null && authentication.isRequested();
    }

    public static class AuthenticationAutoConfigurationEnabledCondition
    implements ConfigurationCondition {
        public static final boolean DEFAULT_ENABLED = true;
        public static final String SECURITY_AUTH_AUTO_CONFIGURATION_ENABLED = "spring.data.gemfire.security.auth.auto-configuration-enabled";

        private static boolean isEnabled(@NonNull Environment environment) {
            return (Boolean)environment.getProperty(SECURITY_AUTH_AUTO_CONFIGURATION_ENABLED, Boolean.class, (Object)true);
        }

        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION;
        }

        public boolean matches(@NonNull ConditionContext conditionContext, @NonNull AnnotatedTypeMetadata annotatedTypeMetadata) {
            return AuthenticationAutoConfigurationEnabledCondition.isEnabled(conditionContext.getEnvironment());
        }
    }
}

