/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation.support;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class GemFireComponentClassTypeScanner
implements Iterable<String> {
    private ClassLoader entityClassLoader;
    private ConfigurableApplicationContext applicationContext;
    private Set<TypeFilter> excludes = new HashSet<TypeFilter>();
    private Set<TypeFilter> includes = new HashSet<TypeFilter>();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set<String> basePackages;

    public static GemFireComponentClassTypeScanner from(String ... basePackages) {
        return new GemFireComponentClassTypeScanner(CollectionUtils.asSet(ArrayUtils.nullSafeArray(basePackages, String.class)));
    }

    public static GemFireComponentClassTypeScanner from(Iterable<String> basePackages) {
        return new GemFireComponentClassTypeScanner(StreamSupport.stream(basePackages.spliterator(), false).collect(Collectors.toSet()));
    }

    protected GemFireComponentClassTypeScanner(Set<String> basePackages) {
        Assert.notEmpty(basePackages, (String)"Base packages is required");
        this.basePackages = basePackages;
    }

    protected ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected Set<String> getBasePackages() {
        return Collections.unmodifiableSet(this.basePackages);
    }

    protected ClassLoader getEntityClassLoader() {
        ConfigurableApplicationContext applicationContext = this.getApplicationContext();
        return this.entityClassLoader != null ? this.entityClassLoader : (applicationContext != null ? applicationContext.getBeanFactory().getBeanClassLoader() : Thread.currentThread().getContextClassLoader());
    }

    protected Environment getEnvironment() {
        return (Environment)Optional.ofNullable(this.getApplicationContext()).map(ConfigurableApplicationContext::getEnvironment).orElse((ConfigurableEnvironment)new StandardEnvironment());
    }

    protected Iterable<TypeFilter> getExcludes() {
        return this.excludes;
    }

    protected Iterable<TypeFilter> getIncludes() {
        return this.includes;
    }

    @Override
    public Iterator<String> iterator() {
        return this.getBasePackages().iterator();
    }

    public Set<Class<?>> scan() {
        CopyOnWriteArraySet componentClasses = new CopyOnWriteArraySet();
        ClassLoader entityClassLoader = this.getEntityClassLoader();
        ClassPathScanningCandidateComponentProvider componentProvider = this.newClassPathScanningCandidateComponentProvider();
        StreamSupport.stream(this.spliterator(), true).flatMap(packageName -> componentProvider.findCandidateComponents(packageName).stream()).forEach(beanDefinition -> Optional.ofNullable(beanDefinition.getBeanClassName()).filter(StringUtils::hasText).ifPresent(beanClassName -> {
            try {
                componentClasses.add(ClassUtils.forName((String)beanClassName, (ClassLoader)entityClassLoader));
            }
            catch (ClassNotFoundException ignore) {
                this.logger.warn(String.format("Class for component type [%s] not found", beanDefinition.getBeanClassName()));
            }
        }));
        return componentClasses;
    }

    protected ClassPathScanningCandidateComponentProvider newClassPathScanningCandidateComponentProvider() {
        return this.newClassPathScanningCandidateComponentProvider(false);
    }

    protected ClassPathScanningCandidateComponentProvider newClassPathScanningCandidateComponentProvider(boolean useDefaultFilters) {
        ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(useDefaultFilters, this.getEnvironment());
        this.excludes.forEach(arg_0 -> ((ClassPathScanningCandidateComponentProvider)componentProvider).addExcludeFilter(arg_0));
        this.includes.forEach(arg_0 -> ((ClassPathScanningCandidateComponentProvider)componentProvider).addIncludeFilter(arg_0));
        return componentProvider;
    }

    public GemFireComponentClassTypeScanner with(ClassLoader entityClassLoader) {
        this.entityClassLoader = entityClassLoader;
        return this;
    }

    public GemFireComponentClassTypeScanner with(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        return this;
    }

    public GemFireComponentClassTypeScanner withExcludes(TypeFilter ... excludes) {
        return this.withExcludes(CollectionUtils.asSet(ArrayUtils.nullSafeArray(excludes, TypeFilter.class)));
    }

    public GemFireComponentClassTypeScanner withExcludes(Iterable<TypeFilter> excludes) {
        StreamSupport.stream(CollectionUtils.nullSafeIterable(excludes).spliterator(), false).forEach(this.excludes::add);
        return this;
    }

    public GemFireComponentClassTypeScanner withIncludes(TypeFilter ... includes) {
        return this.withIncludes(CollectionUtils.asSet(ArrayUtils.nullSafeArray(includes, TypeFilter.class)));
    }

    public GemFireComponentClassTypeScanner withIncludes(Iterable<TypeFilter> includes) {
        StreamSupport.stream(CollectionUtils.nullSafeIterable(includes).spliterator(), false).forEach(this.includes::add);
        return this;
    }
}

