/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import org.apache.geode.GemFireCheckedException;
import org.apache.geode.GemFireException;
import org.apache.geode.cache.Region;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.data.gemfire.GemfireCacheUtils;
import org.springframework.util.Assert;

public class GemfireAccessor
implements InitializingBean {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Region region;

    public <K, V> Region<K, V> getRegion() {
        return this.region;
    }

    public void setRegion(Region<?, ?> region) {
        this.region = region;
    }

    public void afterPropertiesSet() {
        Assert.notNull(this.getRegion(), (String)"Region is required");
    }

    public DataAccessException convertGemFireAccessException(GemFireCheckedException ex) {
        return GemfireCacheUtils.convertGemfireAccessException(ex);
    }

    public DataAccessException convertGemFireAccessException(GemFireException ex) {
        return GemfireCacheUtils.convertGemfireAccessException(ex);
    }

    public DataAccessException convertGemFireQueryException(RuntimeException ex) {
        return GemfireCacheUtils.convertQueryExceptions(ex);
    }
}

