/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import java.util.HashSet;
import java.util.Optional;
import java.util.regex.Pattern;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.parsing.ReaderContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AspectJTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class TypeFilterParser {
    private static final String FILTER_EXPRESSION_ATTRIBUTE = "expression";
    private static final String FILTER_TYPE_ATTRIBUTE = "type";
    private final ClassLoader classLoader;
    private final ReaderContext readerContext;

    public TypeFilterParser(XmlReaderContext readerContext) {
        this((ReaderContext)readerContext, Optional.ofNullable(readerContext).map(XmlReaderContext::getResourceLoader).map(ResourceLoader::getClassLoader).orElseGet(() -> Thread.currentThread().getContextClassLoader()));
    }

    TypeFilterParser(ReaderContext readerContext, ClassLoader classLoader) {
        Assert.notNull((Object)readerContext, (String)"ReaderContext must not be null!");
        Assert.notNull((Object)classLoader, (String)"ClassLoader must not be null!");
        this.readerContext = readerContext;
        this.classLoader = classLoader;
    }

    public Iterable<TypeFilter> parseTypeFilters(Element element, Type type) {
        HashSet<TypeFilter> filters = new HashSet<TypeFilter>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element childElement = type.getElement(nodeList.item(i));
            if (childElement == null) continue;
            try {
                filters.add(this.createTypeFilter(childElement, this.classLoader));
                continue;
            }
            catch (RuntimeException cause) {
                this.readerContext.error(cause.getMessage(), this.readerContext.extractSource((Object)element), cause.getCause());
            }
        }
        return filters;
    }

    protected TypeFilter createTypeFilter(Element element, ClassLoader classLoader) {
        String expression = element.getAttribute(FILTER_EXPRESSION_ATTRIBUTE);
        String filterType = element.getAttribute(FILTER_TYPE_ATTRIBUTE);
        try {
            FilterType filter = FilterType.fromString(filterType);
            return filter.getFilter(expression, classLoader);
        }
        catch (ClassNotFoundException cause) {
            throw new FatalBeanException("TypeFilter class not found: " + expression, (Throwable)cause);
        }
    }

    static enum Type {
        INCLUDE("include-filter"),
        EXCLUDE("exclude-filter");

        private final String elementName;

        private Type(String elementName) {
            this.elementName = elementName;
        }

        Element getElement(Node node) {
            String localName;
            if (node.getNodeType() == 1 && this.elementName.equals(localName = node.getLocalName())) {
                return (Element)node;
            }
            return null;
        }
    }

    private static enum FilterType {
        ANNOTATION{

            @Override
            public TypeFilter getFilter(String expression, ClassLoader classLoader) throws ClassNotFoundException {
                return new AnnotationTypeFilter(classLoader.loadClass(expression));
            }
        }
        ,
        ASSIGNABLE{

            @Override
            public TypeFilter getFilter(String expression, ClassLoader classLoader) throws ClassNotFoundException {
                return new AssignableTypeFilter(classLoader.loadClass(expression));
            }
        }
        ,
        ASPECTJ{

            @Override
            public TypeFilter getFilter(String expression, ClassLoader classLoader) {
                return new AspectJTypeFilter(expression, classLoader);
            }
        }
        ,
        REGEX{

            @Override
            public TypeFilter getFilter(String expression, ClassLoader classLoader) {
                return new RegexPatternTypeFilter(Pattern.compile(expression));
            }
        }
        ,
        CUSTOM{

            @Override
            public TypeFilter getFilter(String expression, ClassLoader classLoader) throws ClassNotFoundException {
                Class<?> filterClass = classLoader.loadClass(expression);
                if (!TypeFilter.class.isAssignableFrom(filterClass)) {
                    throw RuntimeExceptionFactory.newIllegalArgumentException("Class is not assignable to [%s]: %s", TypeFilter.class.getName(), expression);
                }
                return (TypeFilter)BeanUtils.instantiateClass(filterClass);
            }
        };


        abstract TypeFilter getFilter(String var1, ClassLoader var2) throws ClassNotFoundException;

        static FilterType fromString(String type) {
            for (FilterType filter : FilterType.values()) {
                if (!filter.name().equalsIgnoreCase(type)) continue;
                return filter;
            }
            throw new IllegalArgumentException("Unsupported filter type: " + type);
        }
    }
}

