/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client.support;

import org.apache.geode.cache.client.Pool;
import org.apache.shiro.util.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.data.gemfire.client.PoolResolver;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class BeanFactoryPoolResolver
implements BeanFactoryAware,
PoolResolver {
    private BeanFactory beanFactory;

    public BeanFactoryPoolResolver(@NonNull BeanFactory beanFactory) {
        this.setBeanFactory(beanFactory);
    }

    public final void setBeanFactory(@NonNull BeanFactory beanFactory) throws BeansException {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    @Override
    @Nullable
    public Pool resolve(@Nullable String poolName) {
        BeanFactory beanFactory = this.getBeanFactory();
        return StringUtils.hasText((String)poolName) && beanFactory.containsBean(poolName) ? (Pool)beanFactory.getBean(poolName, Pool.class) : null;
    }
}

