/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.geode.cache.Region;
import org.springframework.data.domain.Sort;
import org.springframework.data.gemfire.repository.query.support.OqlKeyword;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class QueryString {
    protected static final Pattern HINT_PATTERN = Pattern.compile("<HINT '\\w+'(, '\\w+')*>");
    protected static final Pattern IMPORT_PATTERN = Pattern.compile("IMPORT .+;");
    protected static final Pattern LIMIT_PATTERN = Pattern.compile("LIMIT \\d+");
    protected static final Pattern TRACE_PATTERN = Pattern.compile("<TRACE>");
    private static final String HINTS_OQL_TEMPLATE = "<HINT %1$s> %2$s";
    private static final String IMPORT_OQL_TEMPLATE = "IMPORT %1$s; %2$s";
    private static final String LIMIT_OQL_TEMPLATE = "%1$s LIMIT %2$d";
    private static final String SELECT_OQL_TEMPLATE = "SELECT %1$s FROM /%2$s";
    private static final String TRACE_OQL_TEMPLATE = "<TRACE> %1$s";
    private static final String IN_PATTERN = "(?<=IN (SET|LIST) )\\$\\d";
    private static final String IN_PARAMETER_PATTERN = "(?<=IN (SET|LIST) \\$)\\d";
    private static final String REGION_PATTERN = "\\/(\\/?\\w)+";
    private static final String COUNT_QUERY = "count(*)";
    private static final String STAR_QUERY = "*";
    private final String query;

    public static QueryString of(String query) {
        return new QueryString(query);
    }

    public static QueryString from(Class<?> domainType) {
        return new QueryString(domainType);
    }

    public static QueryString count(Class<?> domainType) {
        return new QueryString(domainType, true);
    }

    static String asQuery(Class<?> domainType, boolean isCountQuery) {
        return String.format(SELECT_OQL_TEMPLATE, isCountQuery ? COUNT_QUERY : STAR_QUERY, QueryString.validateDomainType(domainType).getSimpleName());
    }

    static <T> Class<T> validateDomainType(Class<T> domainType) {
        Assert.notNull(domainType, (String)"Domain type is required");
        return domainType;
    }

    static String validateQuery(String query) {
        Assert.hasText((String)query, (String)String.format("Query [%s] is required", query));
        return query;
    }

    public QueryString(String query) {
        this.query = QueryString.validateQuery(query);
    }

    public QueryString(Class<?> domainType) {
        this(domainType, false);
    }

    public QueryString(Class<?> domainType, boolean asCountQuery) {
        this(QueryString.asQuery(domainType, asCountQuery));
    }

    public QueryString asDistinct() {
        return QueryString.of(this.asDistinct(this.query));
    }

    String asDistinct(String query) {
        return query.contains(OqlKeyword.DISTINCT.getKeyword()) ? query : query.replaceFirst(OqlKeyword.SELECT.getKeyword(), String.format("%1$s %2$s", OqlKeyword.SELECT.getKeyword(), OqlKeyword.DISTINCT.getKeyword()));
    }

    public QueryString bindIn(Collection<?> values) {
        if (!CollectionUtils.nullSafeIsEmpty(values)) {
            return QueryString.of(this.query.replaceFirst(IN_PATTERN, String.format("(%s)", StringUtils.collectionToDelimitedString(values, (String)", ", (String)"'", (String)"'"))));
        }
        return this;
    }

    public QueryString fromRegion(Class<?> domainClass, Region<?, ?> region) {
        return QueryString.of(this.query.replaceAll(REGION_PATTERN, region.getFullPath()));
    }

    public Iterable<Integer> getInParameterIndexes() {
        Pattern pattern = Pattern.compile(IN_PARAMETER_PATTERN);
        Matcher matcher = pattern.matcher(this.query);
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        while (matcher.find()) {
            indexes.add(Integer.parseInt(matcher.group()));
        }
        return indexes;
    }

    public QueryString orderBy(Sort sort) {
        if (this.hasSort(sort)) {
            StringBuilder orderByClause = new StringBuilder("ORDER BY ");
            int count = 0;
            for (Sort.Order order : sort) {
                orderByClause.append(count++ > 0 ? ", " : "");
                orderByClause.append(String.format("%1$s %2$s", order.getProperty(), order.getDirection()));
            }
            return new QueryString(String.format("%1$s %2$s", this.asDistinct(this.query), orderByClause.toString()));
        }
        return this;
    }

    private boolean hasSort(Sort sort) {
        return sort != null && sort.iterator().hasNext();
    }

    public QueryString withHints(String ... hints) {
        if (!ObjectUtils.isEmpty((Object[])hints)) {
            StringBuilder builder = new StringBuilder();
            for (String hint : hints) {
                builder.append(builder.length() > 0 ? ", " : "");
                builder.append(String.format("'%s'", hint));
            }
            return QueryString.of(String.format(HINTS_OQL_TEMPLATE, builder.toString(), this.query));
        }
        return this;
    }

    public QueryString withImport(String importExpression) {
        return StringUtils.hasText((String)importExpression) ? QueryString.of(String.format(IMPORT_OQL_TEMPLATE, importExpression, this.query)) : this;
    }

    public QueryString withLimit(Integer limit) {
        return limit != null ? QueryString.of(String.format(LIMIT_OQL_TEMPLATE, this.query, limit)) : this;
    }

    public QueryString withTrace() {
        return QueryString.of(String.format(TRACE_OQL_TEMPLATE, this.query));
    }

    public String toString() {
        return this.query;
    }
}

