/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.springframework.data.gemfire.config.annotation.EnableManager;
import org.springframework.data.gemfire.config.annotation.support.EmbeddedServiceConfigurationSupport;
import org.springframework.data.gemfire.util.PropertiesBuilder;

public class ManagerConfiguration
extends EmbeddedServiceConfigurationSupport {
    protected static final int DEFAULT_JMX_MANAGER_PORT = 1099;

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableManager.class;
    }

    @Override
    protected Properties toGemFireProperties(Map<String, Object> annotationAttributes) {
        return Optional.of(this.resolveProperty(this.managerProperty("enabled"), Boolean.TRUE)).filter(Boolean.TRUE::equals).map(enabled -> {
            PropertiesBuilder gemfireProperties = PropertiesBuilder.create();
            gemfireProperties.setProperty("jmx-manager", this.resolveProperty(this.managerProperty("enabled"), Boolean.TRUE));
            gemfireProperties.setProperty("jmx-manager-access-file", this.resolveProperty(this.managerProperty("access-file"), (String)annotationAttributes.get("accessFile")));
            gemfireProperties.setProperty("jmx-manager-bind-address", this.resolveProperty(this.managerProperty("bind-address"), (String)annotationAttributes.get("bindAddress")));
            gemfireProperties.setProperty("jmx-manager-hostname-for-clients", this.resolveProperty(this.managerProperty("hostname-for-clients"), (String)annotationAttributes.get("hostnameForClients")));
            gemfireProperties.setProperty("jmx-manager-password-file", this.resolveProperty(this.managerProperty("password-file"), (String)annotationAttributes.get("passwordFile")));
            gemfireProperties.setProperty("jmx-manager-port", this.resolvePort(this.resolveProperty(this.managerProperty("port"), (Integer)annotationAttributes.get("port")), 1099));
            gemfireProperties.setProperty("jmx-manager-start", this.resolveProperty(this.managerProperty("start"), (Boolean)annotationAttributes.get("start")));
            gemfireProperties.setProperty("jmx-manager-update-rate", this.resolveProperty(this.managerProperty("update-rate"), (Integer)annotationAttributes.get("updateRate")));
            return gemfireProperties.build();
        }).orElseGet(Properties::new);
    }
}

