/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;
import org.springframework.core.annotation.OrderUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class SpringUtils {
    public static boolean isMatchingBean(@NonNull BeanFactory beanFactory, String beanName, Class<?> beanType) {
        return beanFactory.containsBean(beanName) && beanFactory.isTypeMatch(beanName, beanType);
    }

    @NonNull
    public static BeanDefinition addDependsOn(@NonNull BeanDefinition beanDefinition, String ... beanNames) {
        ArrayList<String> dependsOnList = new ArrayList<String>();
        Collections.addAll(dependsOnList, ArrayUtils.nullSafeArray(beanDefinition.getDependsOn(), String.class));
        dependsOnList.addAll(Arrays.asList(ArrayUtils.nullSafeArray(beanNames, String.class)));
        beanDefinition.setDependsOn(dependsOnList.toArray(new String[0]));
        return beanDefinition;
    }

    @NonNull
    public static <T> List<T> getBeansOfTypeOrdered(@NonNull ConfigurableListableBeanFactory beanFactory, @NonNull Class<T> beanType) {
        return SpringUtils.getBeansOfTypeOrdered(beanFactory, beanType, true, true);
    }

    @NonNull
    public static <T> List<T> getBeansOfTypeOrdered(@NonNull ConfigurableListableBeanFactory beanFactory, @NonNull Class<T> beanType, boolean includeNonSingletons, boolean allowEagerInit) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        Assert.notNull(beanType, (String)"Bean type must not be null");
        Map beansOfType = CollectionUtils.nullSafeMap(beanFactory.getBeansOfType(beanType, includeNonSingletons, allowEagerInit));
        HashSet beanNamesOfType = new HashSet(beansOfType.keySet());
        List orderedBeansOfType = beansOfType.entrySet().stream().map(SpringUtils::toOrderedBeanWrapper).filter(Objects::nonNull).collect(Collectors.toList());
        Set orderedBeanNamesOfType = orderedBeansOfType.stream().map(OrderedBeanWrapper::getBeanName).collect(Collectors.toSet());
        HashSet<String> unorderedBeanNamesOfType = new HashSet<String>(beanNamesOfType);
        unorderedBeanNamesOfType.removeAll(orderedBeanNamesOfType);
        orderedBeansOfType.addAll(SpringUtils.orderUnorderedBeans(beanFactory, beansOfType, unorderedBeanNamesOfType));
        orderedBeansOfType.sort(AnnotationAwareOrderComparator.INSTANCE);
        return orderedBeansOfType.stream().map(OrderedBeanWrapper::getBean).collect(Collectors.toList());
    }

    @NonNull
    private static <T> List<OrderedBeanWrapper<T>> orderUnorderedBeans(@NonNull ConfigurableListableBeanFactory beanFactory, @NonNull Map<String, T> beansOfType, @NonNull Set<String> unorderedBeanNames) {
        ArrayList<OrderedBeanWrapper<T>> orderedBeanWrappers = new ArrayList<OrderedBeanWrapper<T>>(unorderedBeanNames.size());
        for (String beanName : unorderedBeanNames) {
            Integer order = Optional.ofNullable(beanName).filter(StringUtils::hasText).map(arg_0 -> ((ConfigurableListableBeanFactory)beanFactory).getBeanDefinition(arg_0)).filter(AnnotatedBeanDefinition.class::isInstance).map(AnnotatedBeanDefinition.class::cast).map(AnnotatedBeanDefinition::getFactoryMethodMetadata).filter(methodMetadata -> methodMetadata.isAnnotated(Order.class.getName())).map(methodMetadata -> methodMetadata.getAnnotationAttributes(Order.class.getName())).map(annotationAttributes -> annotationAttributes.getOrDefault("value", Integer.MAX_VALUE)).map(Integer.class::cast).orElse(Integer.MAX_VALUE);
            orderedBeanWrappers.add(DefaultOrderedBeanWrapper.from(beanName, beansOfType.get(beanName), order));
        }
        return orderedBeanWrappers;
    }

    @Nullable
    private static <T> OrderedBeanWrapper<T> toOrderedBeanWrapper(@NonNull Map.Entry<String, T> beanEntry) {
        T bean = beanEntry.getValue();
        Integer order = SpringUtils.getOrder(bean);
        if (order == null) {
            order = bean != null ? OrderUtils.getOrder(bean.getClass()) : null;
        }
        return order != null ? DefaultOrderedBeanWrapper.from(beanEntry.getKey(), bean, order) : null;
    }

    @Nullable
    public static Integer getOrder(@Nullable Object target) {
        return target instanceof Ordered ? Integer.valueOf(((Ordered)target).getOrder()) : null;
    }

    public static <T> Stream<T> getOrderedStreamOfBeansByType(@NonNull BeanFactory beanFactory, @NonNull Class<T> beanType) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        Assert.notNull(beanType, (String)"Bean type must not be null");
        return beanFactory.getBeanProvider(beanType).orderedStream();
    }

    public static Optional<Object> getPropertyValue(BeanDefinition beanDefinition, String propertyName) {
        return Optional.ofNullable(beanDefinition).map(BeanDefinition::getPropertyValues).map(propertyValues -> propertyValues.getPropertyValue(propertyName)).map(PropertyValue::getValue);
    }

    public static BeanDefinition setPropertyReference(BeanDefinition beanDefinition, String propertyName, String beanName) {
        beanDefinition.getPropertyValues().addPropertyValue(propertyName, (Object)new RuntimeBeanReference(beanName));
        return beanDefinition;
    }

    public static BeanDefinition setPropertyValue(BeanDefinition beanDefinition, String propertyName, Object propertyValue) {
        beanDefinition.getPropertyValues().addPropertyValue(propertyName, propertyValue);
        return beanDefinition;
    }

    public static String defaultIfEmpty(String value, String defaultValue) {
        return SpringUtils.defaultIfEmpty(value, () -> defaultValue);
    }

    public static String defaultIfEmpty(String value, Supplier<String> supplier) {
        return StringUtils.hasText((String)value) ? value : supplier.get();
    }

    public static <T> T defaultIfNull(T value, T defaultValue) {
        return (T)SpringUtils.defaultIfNull(value, () -> defaultValue);
    }

    public static <T> T defaultIfNull(T value, Supplier<T> supplier) {
        return value != null ? value : supplier.get();
    }

    public static String dereferenceBean(String beanName) {
        return String.format("%1$s%2$s", "&", beanName);
    }

    public static boolean equalsIgnoreNull(Object obj1, Object obj2) {
        return Objects.equals(obj1, obj2);
    }

    public static boolean nullOrEquals(Object obj1, Object obj2) {
        return obj1 == null || obj1.equals(obj2);
    }

    public static boolean nullSafeEquals(Object obj1, Object obj2) {
        return obj1 != null && obj1.equals(obj2);
    }

    public static String nullSafeName(Class<?> type) {
        return type != null ? type.getName() : null;
    }

    public static String nullSafeSimpleName(Class<?> type) {
        return type != null ? type.getSimpleName() : null;
    }

    public static Class<?> nullSafeType(Object target) {
        return SpringUtils.nullSafeType(target, null);
    }

    public static Class<?> nullSafeType(Object target, Class<?> defaultType) {
        return target != null ? target.getClass() : defaultType;
    }

    public static boolean safeDoOperation(VoidReturningThrowableOperation operation) {
        return SpringUtils.safeDoOperation(operation, () -> {});
    }

    public static boolean safeDoOperation(VoidReturningThrowableOperation operation, Runnable backupOperation) {
        try {
            operation.run();
            return true;
        }
        catch (Throwable cause) {
            backupOperation.run();
            return false;
        }
    }

    public static <T> T safeGetValue(ValueReturningThrowableOperation<T> operation) {
        return SpringUtils.safeGetValue(operation, null);
    }

    public static <T> T safeGetValue(ValueReturningThrowableOperation<T> operation, T defaultValue) {
        return (T)SpringUtils.safeGetValue(operation, () -> defaultValue);
    }

    public static <T> T safeGetValue(ValueReturningThrowableOperation<T> operation, Supplier<T> defaultValueSupplier) {
        return (T)SpringUtils.safeGetValue(operation, (Throwable exception) -> defaultValueSupplier.get());
    }

    public static <T> T safeGetValue(ValueReturningThrowableOperation<T> operation, Function<Throwable, T> exceptionHandler) {
        try {
            return operation.get();
        }
        catch (Throwable cause) {
            return exceptionHandler.apply(cause);
        }
    }

    public static void safeRunOperation(VoidReturningThrowableOperation operation) {
        SpringUtils.safeRunOperation(operation, cause -> new InvalidDataAccessApiUsageException("Failed to run operation", cause));
    }

    public static void safeRunOperation(VoidReturningThrowableOperation operation, Function<Throwable, RuntimeException> exceptionConverter) {
        try {
            operation.run();
        }
        catch (Throwable cause) {
            throw exceptionConverter.apply(cause);
        }
    }

    @FunctionalInterface
    public static interface VoidReturningThrowableOperation {
        public void run() throws Throwable;
    }

    @Deprecated
    public static interface VoidReturningExceptionThrowingOperation
    extends VoidReturningThrowableOperation {
    }

    @FunctionalInterface
    public static interface ValueReturningThrowableOperation<T> {
        public T get() throws Throwable;
    }

    public static interface OrderedBeanWrapper<T>
    extends Ordered {
        public T getBean();

        public String getBeanName();
    }

    private static class DefaultOrderedBeanWrapper<T>
    implements OrderedBeanWrapper<T> {
        private final int order;
        private final T bean;
        private final String beanName;

        private static <T> OrderedBeanWrapper<T> from(String beanName, T bean) {
            return DefaultOrderedBeanWrapper.from(beanName, bean, Integer.MAX_VALUE);
        }

        private static <T> OrderedBeanWrapper<T> from(String beanName, T bean, int order) {
            return new DefaultOrderedBeanWrapper<T>(beanName, bean, order);
        }

        private DefaultOrderedBeanWrapper(String beanName, T bean, int order) {
            Assert.notNull(bean, (String)"Bean must not be null");
            Assert.hasText((String)beanName, (String)"Bean name is required");
            this.bean = bean;
            this.beanName = beanName;
            this.order = order;
        }

        @Override
        public T getBean() {
            return this.bean;
        }

        @Override
        public String getBeanName() {
            return this.beanName;
        }

        public int getOrder() {
            return this.order;
        }
    }
}

