/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import java.util.Collection;
import java.util.Collections;
import org.apache.geode.cache.query.SelectResults;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.data.gemfire.repository.query.GemfireQueryMethod;
import org.springframework.data.gemfire.repository.query.GemfireRepositoryQuery;
import org.springframework.data.gemfire.repository.query.QueryPostProcessor;
import org.springframework.data.gemfire.repository.query.QueryString;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class StringBasedGemfireRepositoryQuery
extends GemfireRepositoryQuery {
    private static final String INVALID_QUERY = "Paging and modifying queries are not supported";
    private boolean userDefinedQuery = false;
    private final GemfireTemplate template;
    private final QueryString query;

    StringBasedGemfireRepositoryQuery() {
        this.query = null;
        this.template = null;
        this.register(ProvidedQueryPostProcessors.LIMIT.processBefore(ProvidedQueryPostProcessors.IMPORT).processBefore(ProvidedQueryPostProcessors.HINT).processBefore(ProvidedQueryPostProcessors.TRACE));
    }

    public StringBasedGemfireRepositoryQuery(GemfireQueryMethod queryMethod, GemfireTemplate template) {
        this(queryMethod.getAnnotatedQuery(), queryMethod, template);
    }

    public StringBasedGemfireRepositoryQuery(String query, GemfireQueryMethod queryMethod, GemfireTemplate template) {
        super(queryMethod);
        Assert.notNull((Object)template, (String)"GemfireTemplate must not be null");
        Assert.state((!queryMethod.isModifyingQuery() && !queryMethod.isPageQuery() ? 1 : 0) != 0, (String)INVALID_QUERY);
        this.userDefinedQuery |= !StringUtils.hasText((String)query);
        this.query = QueryString.of(StringUtils.hasText((String)query) ? query : queryMethod.getAnnotatedQuery());
        this.template = template;
        this.register(ProvidedQueryPostProcessors.LIMIT.processBefore(ProvidedQueryPostProcessors.IMPORT).processBefore(ProvidedQueryPostProcessors.HINT).processBefore(ProvidedQueryPostProcessors.TRACE));
    }

    public StringBasedGemfireRepositoryQuery asUserDefinedQuery() {
        this.userDefinedQuery = true;
        return this;
    }

    public boolean isUserDefinedQuery() {
        return this.userDefinedQuery;
    }

    protected QueryString getQuery() {
        return this.query;
    }

    protected GemfireTemplate getTemplate() {
        return this.template;
    }

    public Object execute(Object[] arguments) {
        QueryMethod queryMethod = this.getQueryMethod();
        QueryString query = this.preProcess(queryMethod, this.getQuery(), arguments);
        String queryString = query.toString();
        String processedQueryString = this.getQueryPostProcessor().postProcess(queryMethod, queryString, arguments);
        SelectResults selectResults = this.getTemplate().find(processedQueryString, arguments);
        return this.postProcess(queryMethod, selectResults);
    }

    QueryString preProcess(QueryMethod queryMethod, QueryString query, Object[] arguments) {
        query = this.isUserDefinedQuery() ? query : query.fromRegion(queryMethod.getEntityInformation().getJavaType(), this.getTemplate().getRegion());
        Parameters queryMethodParameters = queryMethod.getParameters();
        ParametersParameterAccessor parameterAccessor = new ParametersParameterAccessor(queryMethodParameters, arguments);
        for (Integer index : query.getInParameterIndexes()) {
            query = query.bindIn(this.toCollection(parameterAccessor.getBindableValue(index - 1)));
        }
        return query;
    }

    Object postProcess(QueryMethod queryMethod, SelectResults<?> selectResults) {
        Collection<?> collection = this.toCollection(selectResults);
        if (queryMethod.isCollectionQuery()) {
            return collection;
        }
        if (queryMethod.isQueryForEntity()) {
            if (collection.isEmpty()) {
                return null;
            }
            if (collection.size() == 1) {
                return collection.iterator().next();
            }
            throw new IncorrectResultSizeDataAccessException(1, collection.size());
        }
        if (this.isSingleNonEntityResult(queryMethod, collection)) {
            return collection.iterator().next();
        }
        throw RuntimeExceptionFactory.newIllegalStateException("Unsupported query: %s", this.query.toString());
    }

    boolean isSingleNonEntityResult(QueryMethod method, Collection<?> result) {
        Class<Void> methodReturnType = method.getReturnedObjectType();
        methodReturnType = methodReturnType != null ? methodReturnType : Void.class;
        return org.springframework.data.gemfire.util.CollectionUtils.nullSafeSize(result) == 1 && !Void.TYPE.equals(methodReturnType) && !method.isCollectionQuery();
    }

    Collection<?> toCollection(Object source) {
        if (source instanceof SelectResults) {
            return ((SelectResults)source).asList();
        }
        if (source instanceof Collection) {
            return (Collection)source;
        }
        if (source == null) {
            return Collections.emptyList();
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singletonList(source);
    }

    static enum ProvidedQueryPostProcessors implements QueryPostProcessor<Repository, String>
    {
        HINT{

            @Override
            public String postProcess(QueryMethod queryMethod, String query, Object ... arguments) {
                GemfireQueryMethod gemfireQueryMethod;
                if (queryMethod instanceof GemfireQueryMethod && (gemfireQueryMethod = (GemfireQueryMethod)queryMethod).hasHint() && !QueryString.HINT_PATTERN.matcher(query).find()) {
                    query = QueryString.of(query).withHints(gemfireQueryMethod.getHints()).toString();
                }
                return query;
            }
        }
        ,
        IMPORT{

            @Override
            public String postProcess(QueryMethod queryMethod, String query, Object ... arguments) {
                GemfireQueryMethod gemfireQueryMethod;
                if (queryMethod instanceof GemfireQueryMethod && (gemfireQueryMethod = (GemfireQueryMethod)queryMethod).hasImport() && !QueryString.IMPORT_PATTERN.matcher(query).find()) {
                    query = QueryString.of(query).withImport(gemfireQueryMethod.getImport()).toString();
                }
                return query;
            }
        }
        ,
        LIMIT{

            @Override
            public String postProcess(QueryMethod queryMethod, String query, Object ... arguments) {
                GemfireQueryMethod gemfireQueryMethod;
                if (queryMethod instanceof GemfireQueryMethod && (gemfireQueryMethod = (GemfireQueryMethod)queryMethod).hasLimit() && !QueryString.LIMIT_PATTERN.matcher(query).find()) {
                    query = QueryString.of(query).withLimit(gemfireQueryMethod.getLimit()).toString();
                }
                return query;
            }
        }
        ,
        TRACE{

            @Override
            public String postProcess(QueryMethod queryMethod, String query, Object ... arguments) {
                GemfireQueryMethod gemfireQueryMethod;
                if (queryMethod instanceof GemfireQueryMethod && (gemfireQueryMethod = (GemfireQueryMethod)queryMethod).hasTrace() && !QueryString.TRACE_PATTERN.matcher(query).find()) {
                    query = QueryString.of(query).withTrace().toString();
                }
                return query;
            }
        };

    }
}

