/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.search.lucene.support;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.geode.cache.lucene.LuceneResultStruct;
import org.apache.geode.cache.lucene.PageableLuceneQueryResults;
import org.springframework.data.domain.Page;
import org.springframework.data.gemfire.domain.ListablePage;
import org.springframework.data.gemfire.domain.support.AbstractPageSupport;
import org.springframework.data.gemfire.search.lucene.ProjectingLuceneAccessor;
import org.springframework.util.Assert;

public class LucenePage<T, K, V>
extends AbstractPageSupport<T> {
    private LucenePage<T, K, V> next;
    private LucenePage<T, K, V> previous;
    private final int pageSize;
    private final Class<T> projectionType;
    private final List<T> content;
    private final PageableLuceneQueryResults<K, V> queryResults;
    private final ProjectingLuceneAccessor template;

    public static <T, K, V> LucenePage<T, K, V> newLucenePage(ProjectingLuceneAccessor template, PageableLuceneQueryResults<K, V> queryResults, int pageSize, Class<T> projectionType) {
        return new LucenePage<T, K, V>(template, queryResults, pageSize, projectionType);
    }

    public static <T, K, V> LucenePage<T, K, V> newLucenePage(ProjectingLuceneAccessor template, PageableLuceneQueryResults<K, V> queryResults, int pageSize, Class<T> projectionType, LucenePage<T, K, V> previousPage) {
        return new LucenePage<T, K, V>(template, queryResults, pageSize, projectionType, previousPage);
    }

    public LucenePage(ProjectingLuceneAccessor template, PageableLuceneQueryResults<K, V> queryResults, int pageSize, Class<T> projectionType) {
        this(template, queryResults, pageSize, projectionType, null);
    }

    public LucenePage(ProjectingLuceneAccessor template, PageableLuceneQueryResults<K, V> queryResults, int pageSize, Class<T> projectionType, LucenePage<T, K, V> previous) {
        Assert.notNull((Object)template, (String)"ProjectingLuceneAccessor must not be null");
        Assert.notNull(queryResults, (String)"PageableLuceneQueryResults must not be null");
        Assert.isTrue((boolean)queryResults.hasNext(), (String)"PageableLuceneQueryResults must have content");
        this.template = template;
        this.queryResults = queryResults;
        this.pageSize = pageSize;
        this.projectionType = projectionType;
        this.previous = previous;
        this.content = this.materialize(template, queryResults.next(), projectionType);
    }

    protected List<T> materialize(ProjectingLuceneAccessor template, List<LuceneResultStruct<K, V>> pageOfQueryResults, Class<T> projectionType) {
        return template.project(pageOfQueryResults, projectionType);
    }

    protected int getPageSize() {
        return this.pageSize;
    }

    protected Class<T> getProjectionType() {
        return this.projectionType;
    }

    protected PageableLuceneQueryResults<K, V> getQueryResults() {
        return this.queryResults;
    }

    protected ProjectingLuceneAccessor getTemplate() {
        return this.template;
    }

    @Override
    public boolean hasNext() {
        return this.getQueryResults().hasNext();
    }

    @Override
    public boolean hasPrevious() {
        return this.getPrevious() != null;
    }

    @Override
    public List<T> getContent() {
        return Collections.unmodifiableList(this.content);
    }

    public LucenePage<T, K, V> getNext() {
        return Optional.ofNullable(this.next).orElseGet(() -> {
            Assert.state((boolean)this.hasNext(), (String)"No more pages");
            this.next = LucenePage.newLucenePage(this.getTemplate(), this.getQueryResults(), this.getPageSize(), this.getProjectionType(), this);
            return this.next;
        });
    }

    @Override
    public int getNumber() {
        AtomicInteger number = new AtomicInteger(1);
        Optional.ofNullable(this.getPrevious()).ifPresent(previous -> {
            while (previous != null) {
                previous = previous.getPrevious();
                number.incrementAndGet();
            }
        });
        return number.get();
    }

    public LucenePage<T, K, V> getPrevious() {
        return this.previous;
    }

    @Override
    public int getSize() {
        return this.getPageSize();
    }

    @Override
    public long getTotalElements() {
        return this.getQueryResults().size();
    }

    @Override
    public int getTotalPages() {
        long totalElements = this.getTotalElements();
        int pageSize = this.getPageSize();
        int totalPages = Double.valueOf(Math.floor(totalElements / (long)pageSize)).intValue();
        return totalPages += totalElements % (long)pageSize != 0L ? 1 : 0;
    }

    @Override
    public <S> Page<S> map(Function<? super T, ? extends S> converter) {
        return ListablePage.newListablePage(this.getContent().stream().map(converter::apply).collect(Collectors.toList()));
    }
}

