/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.schema;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.gemfire.config.schema.SchemaObjectDefinition;
import org.springframework.data.gemfire.config.schema.SchemaObjectType;

public interface SchemaObjectDefiner {
    default public Set<SchemaObjectType> getSchemaObjectTypes() {
        return Collections.emptySet();
    }

    default public boolean canDefine(Object schemaObject) {
        return Optional.ofNullable(schemaObject).map(Object::getClass).filter(this::canDefine).isPresent();
    }

    default public boolean canDefine(Class<?> schemaObjectType) {
        return this.canDefine(SchemaObjectType.from(schemaObjectType));
    }

    default public boolean canDefine(SchemaObjectType schemaObjectType) {
        return this.getSchemaObjectTypes().contains((Object)schemaObjectType);
    }

    public Optional<? extends SchemaObjectDefinition> define(Object var1);
}

