/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.springframework.data.gemfire.config.annotation.EnableHttpService;
import org.springframework.data.gemfire.config.annotation.support.EmbeddedServiceConfigurationSupport;
import org.springframework.data.gemfire.util.PropertiesBuilder;

public class HttpServiceConfiguration
extends EmbeddedServiceConfigurationSupport {
    public static final boolean DEFAULT_HTTP_SERVICE_SSL_REQUIRE_AUTHENTICATION = false;
    public static final boolean DEFAULT_HTTP_SERVICE_START_DEVELOPER_REST_API = false;
    public static final int DEFAULT_HTTP_SERVICE_PORT = 7070;

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableHttpService.class;
    }

    @Override
    protected Properties toGemFireProperties(Map<String, Object> annotationAttributes) {
        return Optional.of(this.resolveProperty(this.httpServiceProperty("enabled"), Boolean.TRUE)).filter(Boolean.TRUE::equals).map(enabled -> {
            PropertiesBuilder gemfireProperties = PropertiesBuilder.create();
            gemfireProperties.setProperty("http-service-bind-address", this.resolveProperty(this.httpServiceProperty("bind-address"), (String)annotationAttributes.get("bindAddress")));
            gemfireProperties.setPropertyIfNotDefault("http-service-port", this.resolveProperty(this.httpServiceProperty("port"), (Integer)annotationAttributes.get("port")), 7070);
            gemfireProperties.setPropertyIfNotDefault("http-service-ssl-require-authentication", this.resolveProperty(this.httpServiceProperty("ssl-require-authentication"), (Boolean)annotationAttributes.get("sslRequireAuthentication")), false);
            gemfireProperties.setPropertyIfNotDefault("start-dev-rest-api", this.resolveProperty(this.httpServiceProperty("dev-rest-api.start"), (Boolean)annotationAttributes.get("startDeveloperRestApi")), false);
            return gemfireProperties.build();
        }).orElseGet(Properties::new);
    }
}

