/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Map;
import java.util.Optional;
import org.apache.geode.cache.GemFireCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.EnableGemFireAsLastResource;
import org.springframework.data.gemfire.config.annotation.support.GemFireAsLastResourceConnectionAcquiringAspect;
import org.springframework.data.gemfire.config.annotation.support.GemFireAsLastResourceConnectionClosingAspect;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
public class GemFireAsLastResourceConfiguration
implements ImportAware {
    private Integer enableTransactionManagementOrder;

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableTransactionManagementOrder = this.resolveEnableTransactionManagementOrder(importMetadata);
    }

    protected int resolveEnableTransactionManagementOrder(AnnotationMetadata importMetadata) {
        AnnotationAttributes enableTransactionManagementAttributes = this.resolveEnableTransactionManagementAttributes(importMetadata);
        Integer order = (Integer)enableTransactionManagementAttributes.getNumber("order");
        return Optional.ofNullable(order).filter(it -> it != Integer.MAX_VALUE && it != Integer.MIN_VALUE).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("The @%1$s(order) attribute value [%2$s] must be explicitly set to a value other than Integer.MAX_VALUE or Integer.MIN_VALUE", EnableTransactionManagement.class.getSimpleName(), String.valueOf(order)));
    }

    protected AnnotationAttributes resolveEnableTransactionManagementAttributes(AnnotationMetadata importMetadata) {
        Map enableTransactionManagementAttributes = importMetadata.getAnnotationAttributes(EnableTransactionManagement.class.getName());
        return Optional.ofNullable(enableTransactionManagementAttributes).map(AnnotationAttributes::fromMap).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("The @%1$s annotation may only be used on a Spring application @%2$s class that is also annotated with @%3$s having an explicit [order] set", EnableGemFireAsLastResource.class.getSimpleName(), Configuration.class.getSimpleName(), EnableTransactionManagement.class.getSimpleName()));
    }

    protected Integer getEnableTransactionManagementOrder() {
        return Optional.ofNullable(this.enableTransactionManagementOrder).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("The @%1$s(order) attribute was not properly set [%2$s]; Also, please make your Spring application @%3$s annotated class is annotated with both @%4$s and @%1$s", EnableTransactionManagement.class.getSimpleName(), String.valueOf(this.enableTransactionManagementOrder), Configuration.class.getSimpleName(), EnableGemFireAsLastResource.class.getSimpleName()));
    }

    @Bean
    public Object gemfireCachePostProcessor(@Autowired(required=false) GemFireCache gemfireCache) {
        Optional.ofNullable(gemfireCache).ifPresent(cache -> cache.setCopyOnRead(true));
        return null;
    }

    @Bean
    public GemFireAsLastResourceConnectionAcquiringAspect gemfireJcaConnectionAcquiringAspect() {
        GemFireAsLastResourceConnectionAcquiringAspect connectionAcquiringAspect = new GemFireAsLastResourceConnectionAcquiringAspect();
        int order = this.getEnableTransactionManagementOrder() + 1;
        connectionAcquiringAspect.setOrder(order);
        return connectionAcquiringAspect;
    }

    @Bean
    public GemFireAsLastResourceConnectionClosingAspect gemfireJcaConnectionClosingAspect() {
        GemFireAsLastResourceConnectionClosingAspect connectionClosingAspect = new GemFireAsLastResourceConnectionClosingAspect();
        int order = this.getEnableTransactionManagementOrder() - 1;
        connectionClosingAspect.setOrder(order);
        return connectionClosingAspect;
    }
}

