/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.domain.support;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;

public abstract class AbstractSliceSupport<T>
implements Slice<T> {
    public boolean hasContent() {
        return this.getNumberOfElements() > 0;
    }

    public boolean hasNext() {
        throw RuntimeExceptionFactory.newUnsupportedOperationException("Not Implemented", new Object[0]);
    }

    public boolean hasPrevious() {
        throw RuntimeExceptionFactory.newUnsupportedOperationException("Not Implemented", new Object[0]);
    }

    public boolean isFirst() {
        return !this.hasPrevious();
    }

    public boolean isLast() {
        return !this.hasNext();
    }

    public List<T> getContent() {
        throw RuntimeExceptionFactory.newUnsupportedOperationException("Not Implemented", new Object[0]);
    }

    public int getNumber() {
        AtomicInteger number = new AtomicInteger(1);
        Optional.ofNullable(this.previousPageable()).ifPresent(previousPageable -> {
            Pageable currentPageable;
            do {
                number.incrementAndGet();
            } while ((currentPageable = previousPageable) != (previousPageable = previousPageable.previousOrFirst()));
        });
        return number.get();
    }

    public int getNumberOfElements() {
        return this.getContent().size();
    }

    public int getSize() {
        return this.getNumberOfElements();
    }

    public Sort getSort() {
        throw RuntimeExceptionFactory.newUnsupportedOperationException("Not Implemented", new Object[0]);
    }

    public Iterator<T> iterator() {
        return Collections.unmodifiableList(Optional.ofNullable(this.getContent()).orElseGet(Collections::emptyList)).iterator();
    }

    public <S> Slice<S> map(Function<? super T, ? extends S> converter) {
        throw RuntimeExceptionFactory.newUnsupportedOperationException("Not Implemented", new Object[0]);
    }

    public Pageable nextPageable() {
        throw RuntimeExceptionFactory.newUnsupportedOperationException("Not Implemented", new Object[0]);
    }

    public Pageable previousPageable() {
        throw RuntimeExceptionFactory.newUnsupportedOperationException("Not Implemented", new Object[0]);
    }
}

