/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.client.ClientCache;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.OrderComparator;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.admin.GemfireAdminOperations;
import org.springframework.data.gemfire.config.admin.remote.FunctionGemfireAdminTemplate;
import org.springframework.data.gemfire.config.admin.remote.RestHttpGemfireAdminTemplate;
import org.springframework.data.gemfire.config.annotation.EnableClusterConfiguration;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.config.schema.SchemaObjectCollector;
import org.springframework.data.gemfire.config.schema.SchemaObjectDefiner;
import org.springframework.data.gemfire.config.schema.definitions.RegionDefinition;
import org.springframework.data.gemfire.config.schema.support.ClientRegionCollector;
import org.springframework.data.gemfire.config.schema.support.ComposableSchemaObjectCollector;
import org.springframework.data.gemfire.config.schema.support.ComposableSchemaObjectDefiner;
import org.springframework.data.gemfire.config.schema.support.IndexCollector;
import org.springframework.data.gemfire.config.schema.support.IndexDefiner;
import org.springframework.data.gemfire.config.schema.support.RegionDefiner;
import org.springframework.data.gemfire.config.support.AbstractSmartLifecycle;
import org.springframework.data.gemfire.util.CacheUtils;
import org.springframework.util.Assert;

@Configuration
public class ClusterConfigurationConfiguration
extends AbstractAnnotationConfigSupport
implements ImportAware {
    protected static final boolean DEFAULT_MANAGEMENT_USE_HTTP = false;
    protected static final int DEFAULT_MANAGEMENT_HTTP_PORT = 7070;
    protected static final String DEFAULT_MANAGEMENT_HTTP_HOST = "localhost";
    private static final RegionShortcut DEFAULT_SERVER_REGION_SHORTCUT = RegionDefinition.DEFAULT_REGION_SHORTCUT;
    private Boolean useHttp = false;
    private Integer managementHttpPort = 7070;
    private RegionShortcut serverRegionShortcut;
    private String managementHttpHost = "localhost";

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableClusterConfiguration.class;
    }

    protected void setManagementHttpHost(String hostname) {
        this.managementHttpHost = hostname;
    }

    protected Optional<String> getManagementHttpHost() {
        return Optional.ofNullable(this.managementHttpHost);
    }

    protected String resolveManagementHttpHost() {
        return this.getManagementHttpHost().orElse(DEFAULT_MANAGEMENT_HTTP_HOST);
    }

    protected void setManagementHttpPort(Integer managementHttpPort) {
        this.managementHttpPort = managementHttpPort;
    }

    protected Optional<Integer> getManagementHttpPort() {
        return Optional.ofNullable(this.managementHttpPort);
    }

    protected int resolveManagementHttpPort() {
        return this.getManagementHttpPort().orElse(7070);
    }

    protected void setManagementUseHttp(Boolean useHttp) {
        this.useHttp = useHttp;
    }

    protected Optional<Boolean> getManagementUseHttp() {
        return Optional.ofNullable(this.useHttp);
    }

    protected boolean resolveManagementUseHttp() {
        return this.getManagementUseHttp().orElse(false);
    }

    protected void setServerRegionShortcut(RegionShortcut regionShortcut) {
        this.serverRegionShortcut = regionShortcut;
    }

    protected Optional<RegionShortcut> getServerRegionShortcut() {
        return Optional.ofNullable(this.serverRegionShortcut);
    }

    protected RegionShortcut resolveServerRegionShortcut() {
        return this.getServerRegionShortcut().orElse(DEFAULT_SERVER_REGION_SHORTCUT);
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        if (this.isAnnotationPresent(importMetadata)) {
            AnnotationAttributes enableClusterConfigurationAttributes = this.getAnnotationAttributes(importMetadata);
            this.setManagementHttpHost(this.resolveProperty(this.managementProperty("http.host"), enableClusterConfigurationAttributes.getString("host")));
            this.setManagementHttpPort(this.resolveProperty(this.managementProperty("http.port"), (Integer)enableClusterConfigurationAttributes.getNumber("port")));
            this.setManagementUseHttp(this.resolveProperty(this.managementProperty("use-http"), enableClusterConfigurationAttributes.getBoolean("useHttp")));
            this.setServerRegionShortcut((RegionShortcut)this.resolveProperty(this.clusterProperty("region.type"), RegionShortcut.class, enableClusterConfigurationAttributes.getEnum("serverRegionShortcut")));
        }
    }

    @Bean
    public ClusterSchemaObjectInitializer gemfireClusterSchemaObjectInitializer(GemFireCache gemfireCache) {
        return Optional.ofNullable(gemfireCache).filter(CacheUtils::isClient).map(clientCache -> {
            SchemaObjectContext schemaObjectContext = SchemaObjectContext.from(gemfireCache).with(this.newGemfireAdminOperations((ClientCache)clientCache)).with(this.newSchemaObjectCollector()).with(this.newSchemaObjectDefiner());
            return new ClusterSchemaObjectInitializer(schemaObjectContext);
        }).orElse(null);
    }

    private GemfireAdminOperations newGemfireAdminOperations(ClientCache clientCache) {
        if (this.resolveManagementUseHttp()) {
            String host = this.resolveManagementHttpHost();
            int port = this.resolveManagementHttpPort();
            return new RestHttpGemfireAdminTemplate(clientCache, host, port);
        }
        return new FunctionGemfireAdminTemplate(clientCache);
    }

    private SchemaObjectCollector<?> newSchemaObjectCollector() {
        return ComposableSchemaObjectCollector.compose(new ClientRegionCollector(), new IndexCollector());
    }

    private SchemaObjectDefiner newSchemaObjectDefiner() {
        return ComposableSchemaObjectDefiner.compose(new RegionDefiner(this.resolveServerRegionShortcut()), new IndexDefiner());
    }

    public static class SchemaObjectContext {
        private final GemFireCache gemfireCache;
        private GemfireAdminOperations gemfireAdminOperations;
        private SchemaObjectCollector<?> schemaObjectCollector;
        private SchemaObjectDefiner schemaObjectDefiner;

        protected static SchemaObjectContext from(GemFireCache gemfireCache) {
            return new SchemaObjectContext(gemfireCache);
        }

        private SchemaObjectContext(GemFireCache gemfireCache) {
            Assert.notNull((Object)gemfireCache, (String)"GemFireCache is required");
            this.gemfireCache = gemfireCache;
        }

        public GemfireAdminOperations getGemfireAdminOperations() {
            Assert.state((this.gemfireAdminOperations != null ? 1 : 0) != 0, (String)"GemfireAdminOperations was not initialized");
            return this.gemfireAdminOperations;
        }

        public boolean isClientCache() {
            return CacheUtils.isClient(this.getGemfireCache());
        }

        public boolean isPeerCache() {
            return CacheUtils.isPeer(this.getGemfireCache());
        }

        public <T extends GemFireCache> T getGemfireCache() {
            return (T)this.gemfireCache;
        }

        public SchemaObjectCollector<?> getSchemaObjectCollector() {
            Assert.state((this.schemaObjectCollector != null ? 1 : 0) != 0, (String)"SchemaObjectCollector was not initialized");
            return this.schemaObjectCollector;
        }

        public SchemaObjectDefiner getSchemaObjectDefiner() {
            Assert.state((this.schemaObjectDefiner != null ? 1 : 0) != 0, (String)"SchemaObjectDefiner was not initialized");
            return this.schemaObjectDefiner;
        }

        protected SchemaObjectContext with(GemfireAdminOperations gemfireAdminOperations) {
            Assert.notNull((Object)gemfireAdminOperations, (String)"GemfireAdminOperations are required");
            this.gemfireAdminOperations = gemfireAdminOperations;
            return this;
        }

        protected SchemaObjectContext with(SchemaObjectCollector schemaObjectCollector) {
            Assert.notNull((Object)schemaObjectCollector, (String)"SchemaObjectCollector is required");
            this.schemaObjectCollector = schemaObjectCollector;
            return this;
        }

        protected SchemaObjectContext with(SchemaObjectDefiner schemaObjectDefiner) {
            Assert.notNull((Object)schemaObjectDefiner, (String)"SchemaObjectDefiner is required");
            this.schemaObjectDefiner = schemaObjectDefiner;
            return this;
        }
    }

    public static class ClusterSchemaObjectInitializer
    extends AbstractSmartLifecycle {
        private final SchemaObjectContext schemaObjectContext;

        protected ClusterSchemaObjectInitializer(SchemaObjectContext schemaObjectContext) {
            Assert.notNull((Object)schemaObjectContext, (String)"SchemaObjectContext is required");
            this.schemaObjectContext = schemaObjectContext;
        }

        @Override
        public boolean isAutoStartup() {
            return true;
        }

        @Override
        public int getPhase() {
            return Integer.MIN_VALUE;
        }

        protected SchemaObjectContext getSchemaObjectContext() {
            return this.schemaObjectContext;
        }

        @Override
        public void start() {
            SchemaObjectContext schemaObjectContext = this.getSchemaObjectContext();
            if (schemaObjectContext.isClientCache()) {
                Iterable<?> schemaObjects = schemaObjectContext.getSchemaObjectCollector().collectFrom(this.requireApplicationContext());
                StreamSupport.stream(schemaObjects.spliterator(), false).map(schemaObjectContext.getSchemaObjectDefiner()::define).sorted((Comparator<Optional>)OrderComparator.INSTANCE).forEach(schemaObjectDefinition -> schemaObjectDefinition.ifPresent(it -> it.create(schemaObjectContext.getGemfireAdminOperations())));
                this.setRunning(true);
            }
        }

        @Override
        public void stop() {
            this.setRunning(false);
        }

        @Override
        public void stop(Runnable callback) {
            this.setRunning(false);
            callback.run();
        }
    }
}

