/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.springframework.data.gemfire.config.annotation.EnableSsl;
import org.springframework.data.gemfire.config.annotation.support.EmbeddedServiceConfigurationSupport;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.PropertiesBuilder;
import org.springframework.util.ObjectUtils;

public class SslConfiguration
extends EmbeddedServiceConfigurationSupport {
    protected Class getAnnotationType() {
        return EnableSsl.class;
    }

    @Override
    protected Properties toGemFireProperties(Map<String, Object> annotationAttributes) {
        PropertiesBuilder gemfireProperties = PropertiesBuilder.create();
        EnableSsl.Component[] components = (EnableSsl.Component[])annotationAttributes.get("components");
        if (ObjectUtils.isEmpty((Object[])components)) {
            this.logWarning("SSL will not be configured; No SSL enabled Components %s were specified", Arrays.toString((Object[])EnableSsl.Component.values()));
        }
        Arrays.stream(ArrayUtils.nullSafeArray(components, EnableSsl.Component.class)).forEach(component -> gemfireProperties.setProperty(String.format("%s-ssl-ciphers", component), this.resolveProperty(this.componentSslProperty(component.toString(), "ciphers"), this.resolveProperty(this.sslProperty("ciphers"), (String)annotationAttributes.get("ciphers")))).setProperty(String.format("%s-ssl-enabled", component), this.resolveProperty(this.componentSslProperty(component.toString(), "enabled"), this.resolveProperty(this.sslProperty("enabled"), true))).setProperty(String.format("%s-ssl-keystore", component), this.resolveProperty(this.componentSslProperty(component.toString(), "keystore"), this.resolveProperty(this.sslProperty("keystore"), (String)annotationAttributes.get("keystore")))).setProperty(String.format("%s-ssl-keystore-password", component), this.resolveProperty(this.componentSslProperty(component.toString(), "keystore-password"), this.resolveProperty(this.sslProperty("keystore-password"), (String)annotationAttributes.get("keystorePassword")))).setProperty(String.format("%s-ssl-keystore-type", component), this.resolveProperty(this.componentSslProperty(component.toString(), "keystore-type"), this.resolveProperty(this.sslProperty("keystore-type"), (String)annotationAttributes.get("keystoreType")))).setProperty(String.format("%s-ssl-protocols", component), this.resolveProperty(this.componentSslProperty(component.toString(), "protocols"), this.resolveProperty(this.sslProperty("protocols"), (String)annotationAttributes.get("protocols")))).setProperty(String.format("%s-ssl-require-authentication", component), this.resolveProperty(this.componentSslProperty(component.toString(), "require-authentication"), this.resolveProperty(this.sslProperty("require-authentication"), Boolean.TRUE.equals(annotationAttributes.get("requireAuthentication"))))).setProperty(String.format("%s-ssl-truststore", component), this.resolveProperty(this.componentSslProperty(component.toString(), "truststore"), this.resolveProperty(this.sslProperty("truststore"), (String)annotationAttributes.get("truststore")))).setProperty(String.format("%s-ssl-truststore-password", component), this.resolveProperty(this.componentSslProperty(component.toString(), "truststore-password"), this.resolveProperty(this.sslProperty("truststore-password"), (String)annotationAttributes.get("truststorePassword")))));
        return gemfireProperties.build();
    }
}

