/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.geode.compression.Compressor;
import org.apache.geode.compression.SnappyCompressor;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.RegionLookupFactoryBean;
import org.springframework.data.gemfire.config.annotation.EnableCompression;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.util.StringUtils;

@Configuration
public class CompressionConfiguration
extends AbstractAnnotationConfigSupport
implements ImportAware {
    protected static final String SNAPPY_COMPRESSOR_BEAN_NAME = "SnappyCompressor";
    private String compressorBeanName = "SnappyCompressor";
    private Set<String> regionNames = new HashSet<String>();

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableCompression.class;
    }

    public void setCompressorBeanName(String compressorBeanName) {
        this.compressorBeanName = compressorBeanName;
    }

    protected String resolveCompressorBeanName() {
        return Optional.ofNullable(this.compressorBeanName).filter(StringUtils::hasText).orElse(SNAPPY_COMPRESSOR_BEAN_NAME);
    }

    public void setRegionNames(String[] regionNames) {
        this.setRegionNames(CollectionUtils.asSet(ArrayUtils.nullSafeArray(regionNames, String.class)));
    }

    public void setRegionNames(Iterable<String> regionNames) {
        this.regionNames = CollectionUtils.addAll(this.regionNames, CollectionUtils.nullSafeIterable(regionNames));
    }

    protected Set<String> resolveRegionNames() {
        return Collections.unmodifiableSet(this.regionNames);
    }

    public void setImportMetadata(AnnotationMetadata importingClassMetadata) {
        if (this.isAnnotationPresent(importingClassMetadata)) {
            AnnotationAttributes enableCompressionAttributes = this.getAnnotationAttributes(importingClassMetadata);
            this.setCompressorBeanName(this.resolveProperty(this.cacheCompressionProperty("compressor-bean-name"), enableCompressionAttributes.getString("compressorBeanName")));
            this.setRegionNames(this.resolveProperty(this.cacheCompressionProperty("region-names"), String[].class, enableCompressionAttributes.getStringArray("regionNames")));
        }
    }

    @Bean(value={"SnappyCompressor"})
    Compressor snappyCompressor() {
        return new SnappyCompressor();
    }

    @Bean
    BeanFactoryPostProcessor regionCompressionBeanFactoryPostProcessor() {
        String resolvedCompressorBeanName = this.resolveCompressorBeanName();
        return beanFactory -> Arrays.stream(ArrayUtils.nullSafeArray(beanFactory.getBeanDefinitionNames(), String.class)).forEach(beanName -> Optional.of(beanFactory.getBeanDefinition(beanName)).filter(beanDefinition -> this.isTargetedRegionBean((String)beanName, (BeanDefinition)beanDefinition, beanFactory)).ifPresent(beanDefinition -> SpringUtils.setPropertyReference(beanDefinition, "compressor", resolvedCompressorBeanName)));
    }

    private boolean isTargetedRegionBean(String beanName, BeanDefinition beanDefinition, ConfigurableListableBeanFactory beanFactory) {
        return this.isNamedRegion(beanName, beanDefinition, beanFactory) && this.isRegionBean(beanDefinition, beanFactory);
    }

    private boolean isRegionBean(BeanDefinition beanDefinition, ConfigurableListableBeanFactory beanFactory) {
        return Optional.ofNullable(beanDefinition).flatMap(it -> this.resolveBeanClass((BeanDefinition)it, beanFactory.getBeanClassLoader())).filter(beanClass -> RegionLookupFactoryBean.class.isAssignableFrom((Class<?>)beanClass)).isPresent();
    }

    private boolean isNamedRegion(String beanName, BeanDefinition beanDefinition, ConfigurableListableBeanFactory beanFactory) {
        Set<String> resolvedRegionNames = this.resolveRegionNames();
        return CollectionUtils.isEmpty(resolvedRegionNames) || CollectionUtils.containsAny(resolvedRegionNames, this.resolveBeanNames(beanName, beanDefinition, beanFactory));
    }

    private Collection<String> resolveBeanNames(String beanName, BeanDefinition beanDefinition, ConfigurableListableBeanFactory beanFactory) {
        Object regionNameValue;
        HashSet<String> beanNames = new HashSet<String>();
        beanNames.add(beanName);
        Collections.addAll(beanNames, beanFactory.getAliases(beanName));
        PropertyValue regionName = beanDefinition.getPropertyValues().getPropertyValue("regionName");
        if (regionName != null && (regionNameValue = regionName.getValue()) != null) {
            beanNames.add(regionNameValue.toString());
        }
        return beanNames;
    }
}

