/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.StreamSupport;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientCacheFactory;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.distributed.DistributedSystem;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.client.PoolFactoryBean;
import org.springframework.data.gemfire.client.support.DefaultableDelegatingPoolAdapter;
import org.springframework.data.gemfire.client.support.DelegatingPoolAdapter;
import org.springframework.data.gemfire.config.annotation.ClientCacheConfigurer;
import org.springframework.data.gemfire.support.ConnectionEndpoint;
import org.springframework.data.gemfire.support.ConnectionEndpointList;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.util.StringUtils;

public class ClientCacheFactoryBean
extends CacheFactoryBean
implements ApplicationListener<ContextRefreshedEvent> {
    private Boolean keepAlive = false;
    private Boolean multiUserAuthentication;
    private Boolean prSingleHopEnabled;
    private Boolean readyForEvents;
    private Boolean subscriptionEnabled;
    private Boolean threadLocalConnections;
    private ConnectionEndpointList locators = new ConnectionEndpointList();
    private ConnectionEndpointList servers = new ConnectionEndpointList();
    private Integer durableClientTimeout;
    private Integer freeConnectionTimeout;
    private Integer loadConditioningInterval;
    private Integer maxConnections;
    private Integer minConnections;
    private Integer readTimeout;
    private Integer retryAttempts;
    private Integer socketBufferSize;
    private Integer statisticsInterval;
    private Integer subscriptionAckInterval;
    private Integer subscriptionMessageTrackingTimeout;
    private Integer subscriptionRedundancy;
    private List<ClientCacheConfigurer> clientCacheConfigurers = Collections.emptyList();
    private Long idleTimeout;
    private Long pingInterval;
    private Pool pool;
    private String durableClientId;
    private String poolName;
    private String serverGroup;
    private final ClientCacheConfigurer compositeClientCacheConfigurer = (beanName, bean) -> CollectionUtils.nullSafeCollection(this.clientCacheConfigurers).forEach(clientCacheConfigurer -> clientCacheConfigurer.configure(beanName, bean));

    @Override
    protected void postProcessBeforeCacheInitialization(Properties gemfireProperties) {
        this.applyClientCacheConfigurers();
    }

    private void applyClientCacheConfigurers() {
        this.applyClientCacheConfigurers(this.getCompositeClientCacheConfigurer());
    }

    protected void applyClientCacheConfigurers(ClientCacheConfigurer ... clientCacheConfigurers) {
        this.applyClientCacheConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(clientCacheConfigurers, ClientCacheConfigurer.class)));
    }

    protected void applyClientCacheConfigurers(Iterable<ClientCacheConfigurer> clientCacheConfigurers) {
        StreamSupport.stream(CollectionUtils.nullSafeIterable(clientCacheConfigurers).spliterator(), false).forEach(clientCacheConfigurer -> clientCacheConfigurer.configure(this.getBeanName(), this));
    }

    @Override
    protected <T extends GemFireCache> T fetchCache() {
        return (T)((GemFireCache)Optional.ofNullable(this.getCache()).orElseGet(ClientCacheFactory::getAnyInstance));
    }

    @Override
    protected Properties resolveProperties() {
        Properties gemfireProperties = super.resolveProperties();
        Object distributedSystem = this.getDistributedSystem();
        if (GemfireUtils.isConnected(distributedSystem)) {
            Properties distributedSystemProperties = (Properties)distributedSystem.getProperties().clone();
            distributedSystemProperties.putAll((Map<?, ?>)gemfireProperties);
            gemfireProperties = distributedSystemProperties;
        }
        GemfireUtils.configureDurableClient(gemfireProperties, this.getDurableClientId(), this.getDurableClientTimeout());
        return gemfireProperties;
    }

    <T extends DistributedSystem> T getDistributedSystem() {
        return GemfireUtils.getDistributedSystem();
    }

    @Override
    protected Object createFactory(Properties gemfireProperties) {
        return new ClientCacheFactory(gemfireProperties);
    }

    @Override
    protected Object configureFactory(Object factory) {
        return this.initializePool(this.initializePdx((ClientCacheFactory)factory));
    }

    ClientCacheFactory initializePdx(ClientCacheFactory clientCacheFactory) {
        Optional.ofNullable(this.getPdxSerializer()).ifPresent(arg_0 -> ((ClientCacheFactory)clientCacheFactory).setPdxSerializer(arg_0));
        Optional.ofNullable(this.getPdxDiskStoreName()).filter(StringUtils::hasText).ifPresent(arg_0 -> ((ClientCacheFactory)clientCacheFactory).setPdxDiskStore(arg_0));
        Optional.ofNullable(this.getPdxIgnoreUnreadFields()).ifPresent(arg_0 -> ((ClientCacheFactory)clientCacheFactory).setPdxIgnoreUnreadFields(arg_0));
        Optional.ofNullable(this.getPdxPersistent()).ifPresent(arg_0 -> ((ClientCacheFactory)clientCacheFactory).setPdxPersistent(arg_0));
        Optional.ofNullable(this.getPdxReadSerialized()).ifPresent(arg_0 -> ((ClientCacheFactory)clientCacheFactory).setPdxReadSerialized(arg_0));
        return clientCacheFactory;
    }

    ClientCacheFactory initializePool(ClientCacheFactory clientCacheFactory) {
        boolean hasLocators;
        DefaultableDelegatingPoolAdapter pool = DefaultableDelegatingPoolAdapter.from(DelegatingPoolAdapter.from(this.resolvePool())).preferDefault();
        clientCacheFactory.setPoolFreeConnectionTimeout(pool.getFreeConnectionTimeout(this.getFreeConnectionTimeout()));
        clientCacheFactory.setPoolIdleTimeout(pool.getIdleTimeout(this.getIdleTimeout()));
        clientCacheFactory.setPoolLoadConditioningInterval(pool.getLoadConditioningInterval(this.getLoadConditioningInterval()));
        clientCacheFactory.setPoolMaxConnections(pool.getMaxConnections(this.getMaxConnections()));
        clientCacheFactory.setPoolMinConnections(pool.getMinConnections(this.getMinConnections()));
        clientCacheFactory.setPoolMultiuserAuthentication(pool.getMultiuserAuthentication(this.getMultiUserAuthentication()));
        clientCacheFactory.setPoolPRSingleHopEnabled(pool.getPRSingleHopEnabled(this.getPrSingleHopEnabled()));
        clientCacheFactory.setPoolPingInterval(pool.getPingInterval(this.getPingInterval()));
        clientCacheFactory.setPoolReadTimeout(pool.getReadTimeout(this.getReadTimeout()));
        clientCacheFactory.setPoolRetryAttempts(pool.getRetryAttempts(this.getRetryAttempts()));
        clientCacheFactory.setPoolServerGroup(pool.getServerGroup(this.getServerGroup()));
        clientCacheFactory.setPoolSocketBufferSize(pool.getSocketBufferSize(this.getSocketBufferSize()));
        clientCacheFactory.setPoolStatisticInterval(pool.getStatisticInterval(this.getStatisticsInterval()));
        clientCacheFactory.setPoolSubscriptionAckInterval(pool.getSubscriptionAckInterval(this.getSubscriptionAckInterval()));
        clientCacheFactory.setPoolSubscriptionEnabled(pool.getSubscriptionEnabled(this.getSubscriptionEnabled()));
        clientCacheFactory.setPoolSubscriptionMessageTrackingTimeout(pool.getSubscriptionMessageTrackingTimeout(this.getSubscriptionMessageTrackingTimeout()));
        clientCacheFactory.setPoolSubscriptionRedundancy(pool.getSubscriptionRedundancy(this.getSubscriptionRedundancy()));
        clientCacheFactory.setPoolThreadLocalConnections(pool.getThreadLocalConnections(this.getThreadLocalConnections()));
        AtomicBoolean noServers = new AtomicBoolean(this.getServers().isEmpty());
        boolean hasServers = !noServers.get();
        boolean noLocators = this.getLocators().isEmpty();
        boolean bl = hasLocators = !noLocators;
        if (hasServers || noLocators) {
            List<InetSocketAddress> servers = pool.getServers(this.getServers().toInetSocketAddresses());
            StreamSupport.stream(servers.spliterator(), false).forEach(server -> {
                clientCacheFactory.addPoolServer(server.getHostName(), server.getPort());
                noServers.set(false);
            });
        }
        if (hasLocators || noServers.get()) {
            List<InetSocketAddress> locators = pool.getLocators(this.getLocators().toInetSocketAddresses());
            StreamSupport.stream(locators.spliterator(), false).forEach(locator -> clientCacheFactory.addPoolLocator(locator.getHostName(), locator.getPort()));
        }
        return clientCacheFactory;
    }

    Pool resolvePool() {
        BeanFactory beanFactory;
        String poolName;
        Pool localPool = this.getPool();
        if (localPool == null && (localPool = this.findPool(poolName = Optional.ofNullable(this.getPoolName()).filter(StringUtils::hasText).orElse("gemfirePool"))) == null && (beanFactory = this.getBeanFactory()) instanceof ListableBeanFactory) {
            try {
                Map poolFactoryBeanMap = ((ListableBeanFactory)beanFactory).getBeansOfType(PoolFactoryBean.class, false, false);
                String dereferencedPoolName = SpringUtils.dereferenceBean(poolName);
                if (poolFactoryBeanMap.containsKey(dereferencedPoolName)) {
                    return ((PoolFactoryBean)poolFactoryBeanMap.get(dereferencedPoolName)).getPool();
                }
            }
            catch (BeansException e) {
                this.logInfo("Unable to resolve bean of type [%1$s] with name [%2$s]", PoolFactoryBean.class.getName(), poolName);
            }
        }
        return localPool;
    }

    Pool findPool(String name) {
        return PoolManager.find((String)name);
    }

    @Override
    protected <T extends GemFireCache> T createCache(Object factory) {
        return (T)((ClientCacheFactory)factory).create();
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.isReadyForEvents()) {
            try {
                ((ClientCache)this.fetchCache()).readyForEvents();
            }
            catch (IllegalStateException | CacheClosedException throwable) {
                // empty catch block
            }
        }
    }

    @Override
    protected void close(GemFireCache cache) {
        ((ClientCache)cache).close(this.isKeepAlive());
    }

    @Override
    public Class<? extends GemFireCache> getObjectType() {
        return Optional.ofNullable(this.getCache()).map(Object::getClass).orElse(ClientCache.class);
    }

    public void addLocators(ConnectionEndpoint ... locators) {
        this.locators.add(locators);
    }

    public void addLocators(Iterable<ConnectionEndpoint> locators) {
        this.locators.add(locators);
    }

    public void addServers(ConnectionEndpoint ... servers) {
        this.servers.add(servers);
    }

    public void addServers(Iterable<ConnectionEndpoint> servers) {
        this.servers.add(servers);
    }

    public void setClientCacheConfigurers(ClientCacheConfigurer ... clientCacheConfigurers) {
        this.setClientCacheConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(clientCacheConfigurers, ClientCacheConfigurer.class)));
    }

    public void setClientCacheConfigurers(List<ClientCacheConfigurer> peerCacheConfigurers) {
        this.clientCacheConfigurers = Optional.ofNullable(peerCacheConfigurers).orElseGet(Collections::emptyList);
    }

    public ClientCacheConfigurer getCompositeClientCacheConfigurer() {
        return this.compositeClientCacheConfigurer;
    }

    public void setDurableClientId(String durableClientId) {
        this.durableClientId = durableClientId;
    }

    public String getDurableClientId() {
        return this.durableClientId;
    }

    public void setDurableClientTimeout(Integer durableClientTimeout) {
        this.durableClientTimeout = durableClientTimeout;
    }

    public Integer getDurableClientTimeout() {
        return this.durableClientTimeout;
    }

    @Override
    public final void setEnableAutoReconnect(Boolean enableAutoReconnect) {
        throw new UnsupportedOperationException("Auto-reconnect does not apply to clients");
    }

    @Override
    public final Boolean getEnableAutoReconnect() {
        return Boolean.FALSE;
    }

    public void setFreeConnectionTimeout(Integer freeConnectionTimeout) {
        this.freeConnectionTimeout = freeConnectionTimeout;
    }

    public Integer getFreeConnectionTimeout() {
        return this.freeConnectionTimeout;
    }

    public void setIdleTimeout(Long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public Long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public boolean isKeepAlive() {
        return Boolean.TRUE.equals(this.getKeepAlive());
    }

    public void setLoadConditioningInterval(Integer loadConditioningInterval) {
        this.loadConditioningInterval = loadConditioningInterval;
    }

    public Integer getLoadConditioningInterval() {
        return this.loadConditioningInterval;
    }

    public void setLocators(ConnectionEndpoint[] locators) {
        this.setLocators(ConnectionEndpointList.from(locators));
    }

    public void setLocators(Iterable<ConnectionEndpoint> locators) {
        this.getLocators().clear();
        this.addLocators(locators);
    }

    protected ConnectionEndpointList getLocators() {
        return this.locators;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public void setMinConnections(Integer minConnections) {
        this.minConnections = minConnections;
    }

    public Integer getMinConnections() {
        return this.minConnections;
    }

    public void setMultiUserAuthentication(Boolean multiUserAuthentication) {
        this.multiUserAuthentication = multiUserAuthentication;
    }

    public Boolean getMultiUserAuthentication() {
        return this.multiUserAuthentication;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public Pool getPool() {
        return this.pool;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public void setPingInterval(Long pingInterval) {
        this.pingInterval = pingInterval;
    }

    public Long getPingInterval() {
        return this.pingInterval;
    }

    public void setPrSingleHopEnabled(Boolean prSingleHopEnabled) {
        this.prSingleHopEnabled = prSingleHopEnabled;
    }

    public Boolean getPrSingleHopEnabled() {
        return this.prSingleHopEnabled;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadyForEvents(Boolean readyForEvents) {
        this.readyForEvents = readyForEvents;
    }

    public Boolean getReadyForEvents() {
        return this.readyForEvents;
    }

    public boolean isReadyForEvents() {
        Boolean readyForEvents = this.getReadyForEvents();
        if (readyForEvents != null) {
            return Boolean.TRUE.equals(readyForEvents);
        }
        try {
            return GemfireUtils.isDurable((ClientCache)this.fetchCache());
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    public void setRetryAttempts(Integer retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    public Integer getRetryAttempts() {
        return this.retryAttempts;
    }

    public void setServerGroup(String serverGroup) {
        this.serverGroup = serverGroup;
    }

    public String getServerGroup() {
        return this.serverGroup;
    }

    public void setServers(ConnectionEndpoint[] servers) {
        this.setServers(ConnectionEndpointList.from(servers));
    }

    public void setServers(Iterable<ConnectionEndpoint> servers) {
        this.getServers().clear();
        this.addServers(servers);
    }

    protected ConnectionEndpointList getServers() {
        return this.servers;
    }

    public void setSocketBufferSize(Integer socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public Integer getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void setStatisticsInterval(Integer statisticsInterval) {
        this.statisticsInterval = statisticsInterval;
    }

    public Integer getStatisticsInterval() {
        return this.statisticsInterval;
    }

    public void setSubscriptionAckInterval(Integer subscriptionAckInterval) {
        this.subscriptionAckInterval = subscriptionAckInterval;
    }

    public Integer getSubscriptionAckInterval() {
        return this.subscriptionAckInterval;
    }

    public void setSubscriptionEnabled(Boolean subscriptionEnabled) {
        this.subscriptionEnabled = subscriptionEnabled;
    }

    public Boolean getSubscriptionEnabled() {
        return this.subscriptionEnabled;
    }

    public void setSubscriptionMessageTrackingTimeout(Integer subscriptionMessageTrackingTimeout) {
        this.subscriptionMessageTrackingTimeout = subscriptionMessageTrackingTimeout;
    }

    public Integer getSubscriptionMessageTrackingTimeout() {
        return this.subscriptionMessageTrackingTimeout;
    }

    public void setSubscriptionRedundancy(Integer subscriptionRedundancy) {
        this.subscriptionRedundancy = subscriptionRedundancy;
    }

    public Integer getSubscriptionRedundancy() {
        return this.subscriptionRedundancy;
    }

    public void setThreadLocalConnections(Boolean threadLocalConnections) {
        this.threadLocalConnections = threadLocalConnections;
    }

    public Boolean getThreadLocalConnections() {
        return this.threadLocalConnections;
    }

    @Override
    public final void setUseClusterConfiguration(Boolean useClusterConfiguration) {
        throw new UnsupportedOperationException("Cluster-based Configuration is not applicable for clients");
    }

    @Override
    public final Boolean getUseClusterConfiguration() {
        return Boolean.FALSE;
    }
}

