/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.execution;

import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.FunctionService;
import org.springframework.data.gemfire.function.execution.AbstractFunctionExecution;
import org.springframework.util.CollectionUtils;

class RegionFunctionExecution
extends AbstractFunctionExecution {
    private final Region<?, ?> region;
    private volatile Set<?> keys;

    public RegionFunctionExecution(Region<?, ?> region) {
        this.region = region;
    }

    public RegionFunctionExecution setKeys(Set<?> keys) {
        this.keys = keys;
        return this;
    }

    @Override
    protected Set<?> getKeys() {
        return this.keys;
    }

    @Override
    protected Execution getExecution() {
        Execution execution = FunctionService.onRegion(this.region);
        if (!CollectionUtils.isEmpty(this.keys)) {
            execution = execution.withFilter(this.keys);
        }
        return execution;
    }
}

