/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.server;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.InterestRegistrationListener;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.server.ClientSubscriptionConfig;
import org.apache.geode.cache.server.ServerLoadProbe;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.data.gemfire.server.SubscriptionEvictionPolicy;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CacheServerFactoryBean
implements FactoryBean<CacheServer>,
InitializingBean,
DisposableBean,
SmartLifecycle {
    private boolean autoStartup = true;
    private boolean notifyBySubscription = true;
    private int maxConnections = 800;
    private int maxMessageCount = 230000;
    private int maxThreads = 0;
    private int maxTimeBetweenPings = 60000;
    private int messageTimeToLive = 180;
    private int port = 40404;
    private int socketBufferSize = 32768;
    private int subscriptionCapacity = 1;
    private long loadPollInterval = 5000L;
    private Cache cache;
    private CacheServer cacheServer;
    private ServerLoadProbe serverLoadProbe = CacheServer.DEFAULT_LOAD_PROBE;
    private Set<InterestRegistrationListener> listeners = Collections.emptySet();
    private String bindAddress = "";
    private String hostNameForClients = "";
    private String subscriptionDiskStore;
    private String[] serverGroups = new String[0];
    private SubscriptionEvictionPolicy subscriptionEvictionPolicy = SubscriptionEvictionPolicy.DEFAULT;

    public void afterPropertiesSet() throws IOException {
        Assert.notNull((Object)this.cache, (String)"A GemFire Cache is required.");
        this.cacheServer = this.cache.addCacheServer();
        this.cacheServer.setBindAddress(this.bindAddress);
        this.cacheServer.setGroups(this.serverGroups);
        this.cacheServer.setHostnameForClients(this.hostNameForClients);
        this.cacheServer.setLoadPollInterval(this.loadPollInterval);
        this.cacheServer.setLoadProbe(this.serverLoadProbe);
        this.cacheServer.setMaxConnections(this.maxConnections);
        this.cacheServer.setMaximumMessageCount(this.maxMessageCount);
        this.cacheServer.setMaximumTimeBetweenPings(this.maxTimeBetweenPings);
        this.cacheServer.setMaxThreads(this.maxThreads);
        this.cacheServer.setMessageTimeToLive(this.messageTimeToLive);
        this.cacheServer.setNotifyBySubscription(this.notifyBySubscription);
        this.cacheServer.setPort(this.port);
        this.cacheServer.setSocketBufferSize(this.socketBufferSize);
        for (InterestRegistrationListener listener : this.listeners) {
            this.cacheServer.registerInterestRegistrationListener(listener);
        }
        ClientSubscriptionConfig config = this.cacheServer.getClientSubscriptionConfig();
        config.setCapacity(this.subscriptionCapacity);
        this.getSubscriptionEvictionPolicy().setEvictionPolicy(config);
        if (StringUtils.hasText((String)this.subscriptionDiskStore)) {
            config.setDiskStoreName(this.subscriptionDiskStore);
        }
    }

    public CacheServer getObject() {
        return this.cacheServer;
    }

    public Class<?> getObjectType() {
        return this.cacheServer != null ? this.cacheServer.getClass() : CacheServer.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isRunning() {
        return this.cacheServer != null && this.cacheServer.isRunning();
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public void destroy() {
        this.stop();
        this.cacheServer = null;
    }

    public void start() {
        try {
            this.cacheServer.start();
        }
        catch (IOException e) {
            throw new BeanInitializationException("Cannot start cache server", (Throwable)e);
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void stop() {
        if (this.cacheServer != null) {
            this.cacheServer.stop();
        }
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    void setCacheServer(CacheServer cacheServer) {
        this.cacheServer = cacheServer;
    }

    public void setHostNameForClients(String hostNameForClients) {
        this.hostNameForClients = hostNameForClients;
    }

    public void setListeners(Set<InterestRegistrationListener> listeners) {
        this.listeners = listeners;
    }

    public void setLoadPollInterval(long loadPollInterval) {
        this.loadPollInterval = loadPollInterval;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setMaxMessageCount(int maxMessageCount) {
        this.maxMessageCount = maxMessageCount;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public void setMaxTimeBetweenPings(int maxTimeBetweenPings) {
        this.maxTimeBetweenPings = maxTimeBetweenPings;
    }

    public void setMessageTimeToLive(int messageTimeToLive) {
        this.messageTimeToLive = messageTimeToLive;
    }

    public void setNotifyBySubscription(boolean notifyBySubscription) {
        this.notifyBySubscription = notifyBySubscription;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setServerGroups(String[] serverGroups) {
        this.serverGroups = serverGroups;
    }

    public void setServerLoadProbe(ServerLoadProbe serverLoadProbe) {
        this.serverLoadProbe = serverLoadProbe;
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public void setSubscriptionCapacity(int subscriptionCapacity) {
        this.subscriptionCapacity = subscriptionCapacity;
    }

    public void setSubscriptionDiskStore(String diskStoreName) {
        this.subscriptionDiskStore = diskStoreName;
    }

    SubscriptionEvictionPolicy getSubscriptionEvictionPolicy() {
        return this.subscriptionEvictionPolicy != null ? this.subscriptionEvictionPolicy : SubscriptionEvictionPolicy.DEFAULT;
    }

    public void setSubscriptionEvictionPolicy(SubscriptionEvictionPolicy evictionPolicy) {
        this.subscriptionEvictionPolicy = evictionPolicy;
    }
}

