/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.ExpirationActionType;

public class ExpirationAttributesFactoryBean
implements FactoryBean<ExpirationAttributes>,
InitializingBean {
    protected static final int DEFAULT_TIMEOUT = 0;
    protected static final ExpirationAction DEFAULT_EXPIRATION_ACTION = ExpirationActionType.DEFAULT.getExpirationAction();
    private ExpirationAction action;
    private ExpirationAttributes expirationAttributes;
    private Integer timeout;

    public ExpirationAttributes getObject() throws Exception {
        return this.expirationAttributes;
    }

    public Class<?> getObjectType() {
        return this.expirationAttributes != null ? this.expirationAttributes.getClass() : ExpirationAttributes.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setAction(ExpirationAction action) {
        this.action = action;
    }

    public ExpirationAction getAction() {
        return this.action != null ? this.action : DEFAULT_EXPIRATION_ACTION;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout != null ? this.timeout : 0;
    }

    public void afterPropertiesSet() throws Exception {
        this.expirationAttributes = new ExpirationAttributes(this.getTimeout(), this.getAction());
    }
}

