/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Map;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.config.annotation.AbstractCacheConfiguration;
import org.springframework.data.gemfire.config.annotation.PeerCacheApplication;

@Configuration
public class PeerCacheConfiguration
extends AbstractCacheConfiguration {
    protected static final boolean DEFAULT_ENABLE_AUTO_RECONNECT = false;
    protected static final boolean DEFAULT_USE_CLUSTER_CONFIGURATION = false;
    protected static final String DEFAULT_NAME = "SpringBasedPeerCacheApplication";
    private boolean enableAutoReconnect = false;
    private boolean useClusterConfiguration = false;
    private Integer lockLease;
    private Integer lockTimeout;
    private Integer messageSyncInterval;
    private Integer searchTimeout;

    @Bean
    public CacheFactoryBean gemfireCache() {
        Object gemfireCache = this.constructCacheFactoryBean();
        ((CacheFactoryBean)gemfireCache).setEnableAutoReconnect(this.enableAutoReconnect());
        ((CacheFactoryBean)gemfireCache).setLockLease(this.lockLease());
        ((CacheFactoryBean)gemfireCache).setLockTimeout(this.lockTimeout());
        ((CacheFactoryBean)gemfireCache).setMessageSyncInterval(this.messageSyncInterval());
        ((CacheFactoryBean)gemfireCache).setSearchTimeout(this.searchTimeout());
        ((CacheFactoryBean)gemfireCache).setUseBeanFactoryLocator(this.useBeanFactoryLocator());
        ((CacheFactoryBean)gemfireCache).setUseClusterConfiguration(this.useClusterConfiguration());
        return gemfireCache;
    }

    @Override
    protected <T extends CacheFactoryBean> T newCacheFactoryBean() {
        return (T)new CacheFactoryBean();
    }

    @Override
    protected void configureCache(AnnotationMetadata importMetadata) {
        super.configureCache(importMetadata);
        if (this.isCacheServerOrPeerCacheApplication(importMetadata)) {
            Map peerCacheApplicationAttributes = importMetadata.getAnnotationAttributes(this.getAnnotationTypeName());
            this.setEnableAutoReconnect(Boolean.TRUE.equals(peerCacheApplicationAttributes.get("enableAutoReconnect")));
            this.setLockLease((Integer)peerCacheApplicationAttributes.get("lockLease"));
            this.setLockTimeout((Integer)peerCacheApplicationAttributes.get("lockTimeout"));
            this.setMessageSyncInterval((Integer)peerCacheApplicationAttributes.get("messageSyncInterval"));
            this.setSearchTimeout((Integer)peerCacheApplicationAttributes.get("searchTimeout"));
            this.setUseClusterConfiguration(Boolean.TRUE.equals(peerCacheApplicationAttributes.get("useClusterConfiguration")));
            String locators = (String)peerCacheApplicationAttributes.get("locators");
            if (PeerCacheConfiguration.hasValue(locators)) {
                this.setLocators(locators);
            }
        }
    }

    @Override
    protected Class getAnnotationType() {
        return PeerCacheApplication.class;
    }

    void setEnableAutoReconnect(boolean enableAutoReconnect) {
        this.enableAutoReconnect = enableAutoReconnect;
    }

    protected boolean enableAutoReconnect() {
        return this.enableAutoReconnect;
    }

    void setLockLease(Integer lockLease) {
        this.lockLease = lockLease;
    }

    protected Integer lockLease() {
        return this.lockLease;
    }

    void setLockTimeout(Integer lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    protected Integer lockTimeout() {
        return this.lockTimeout;
    }

    void setMessageSyncInterval(Integer messageSyncInterval) {
        this.messageSyncInterval = messageSyncInterval;
    }

    protected Integer messageSyncInterval() {
        return this.messageSyncInterval;
    }

    void setSearchTimeout(Integer searchTimeout) {
        this.searchTimeout = searchTimeout;
    }

    protected Integer searchTimeout() {
        return this.searchTimeout;
    }

    void setUseClusterConfiguration(boolean useClusterConfiguration) {
        this.useClusterConfiguration = useClusterConfiguration;
    }

    protected boolean useClusterConfiguration() {
        return this.useClusterConfiguration;
    }

    @Override
    public String toString() {
        return DEFAULT_NAME;
    }
}

