/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import java.net.InetSocketAddress;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.gemfire.support.ConnectionEndpoint;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.SpringUtils;

public class ConnectionEndpointList
extends AbstractList<ConnectionEndpoint> {
    private final List<ConnectionEndpoint> connectionEndpoints = new ArrayList<ConnectionEndpoint>();

    public static ConnectionEndpointList from(ConnectionEndpoint ... connectionEndpoints) {
        return new ConnectionEndpointList(connectionEndpoints);
    }

    public static ConnectionEndpointList from(InetSocketAddress ... socketAddresses) {
        return ConnectionEndpointList.from(Arrays.asList(socketAddresses));
    }

    public static ConnectionEndpointList from(Iterable<InetSocketAddress> socketAddresses) {
        ArrayList<ConnectionEndpoint> connectionEndpoints = new ArrayList<ConnectionEndpoint>();
        for (InetSocketAddress socketAddress : CollectionUtils.nullSafeIterable(socketAddresses)) {
            connectionEndpoints.add(ConnectionEndpoint.from(socketAddress));
        }
        return new ConnectionEndpointList(connectionEndpoints);
    }

    public static ConnectionEndpointList parse(int defaultPort, String ... hostsPorts) {
        ArrayList<ConnectionEndpoint> connectionEndpoints = new ArrayList<ConnectionEndpoint>(hostsPorts.length);
        for (String hostPort : ArrayUtils.nullSafeArray(hostsPorts)) {
            connectionEndpoints.add(ConnectionEndpoint.parse(hostPort, defaultPort));
        }
        return new ConnectionEndpointList(connectionEndpoints);
    }

    public ConnectionEndpointList() {
        this(Collections.emptyList());
    }

    public ConnectionEndpointList(ConnectionEndpoint ... connectionEndpoints) {
        this(Arrays.asList(connectionEndpoints));
    }

    public ConnectionEndpointList(Iterable<ConnectionEndpoint> connectionEndpoints) {
        this.add(connectionEndpoints);
    }

    @Override
    public boolean add(ConnectionEndpoint connectionEndpoint) {
        return this.add(SpringUtils.toArray(connectionEndpoint)) == this;
    }

    public final ConnectionEndpointList add(ConnectionEndpoint ... connectionEndpoints) {
        Collections.addAll(this.connectionEndpoints, connectionEndpoints);
        return this;
    }

    public final ConnectionEndpointList add(Iterable<ConnectionEndpoint> connectionEndpoints) {
        for (ConnectionEndpoint connectionEndpoint : CollectionUtils.nullSafeIterable(connectionEndpoints)) {
            this.connectionEndpoints.add(connectionEndpoint);
        }
        return this;
    }

    @Override
    public void clear() {
        this.connectionEndpoints.clear();
    }

    public ConnectionEndpointList findBy(String host) {
        ArrayList<ConnectionEndpoint> connectionEndpoints = new ArrayList<ConnectionEndpoint>(this.size());
        for (ConnectionEndpoint connectionEndpoint : this) {
            if (!connectionEndpoint.getHost().equals(host)) continue;
            connectionEndpoints.add(connectionEndpoint);
        }
        return new ConnectionEndpointList(connectionEndpoints);
    }

    public ConnectionEndpointList findBy(int port) {
        ArrayList<ConnectionEndpoint> connectionEndpoints = new ArrayList<ConnectionEndpoint>(this.size());
        for (ConnectionEndpoint connectionEndpoint : this) {
            if (connectionEndpoint.getPort() != port) continue;
            connectionEndpoints.add(connectionEndpoint);
        }
        return new ConnectionEndpointList(connectionEndpoints);
    }

    public ConnectionEndpoint findOne(String host) {
        ConnectionEndpointList connectionEndpoints = this.findBy(host);
        return connectionEndpoints.isEmpty() ? null : connectionEndpoints.connectionEndpoints.get(0);
    }

    public ConnectionEndpoint findOne(int port) {
        ConnectionEndpointList connectionEndpoints = this.findBy(port);
        return connectionEndpoints.isEmpty() ? null : connectionEndpoints.connectionEndpoints.get(0);
    }

    @Override
    public ConnectionEndpoint get(int index) {
        return this.connectionEndpoints.get(index);
    }

    @Override
    public ConnectionEndpoint set(int index, ConnectionEndpoint element) {
        return this.connectionEndpoints.set(index, element);
    }

    @Override
    public boolean isEmpty() {
        return this.connectionEndpoints.isEmpty();
    }

    @Override
    public Iterator<ConnectionEndpoint> iterator() {
        return Collections.unmodifiableList(this.connectionEndpoints).iterator();
    }

    @Override
    public int size() {
        return this.connectionEndpoints.size();
    }

    public ConnectionEndpoint[] toArray() {
        return this.connectionEndpoints.toArray(new ConnectionEndpoint[this.connectionEndpoints.size()]);
    }

    public List<InetSocketAddress> toInetSocketAddresses() {
        ArrayList<InetSocketAddress> inetSocketAddresses = new ArrayList<InetSocketAddress>(this.size());
        for (ConnectionEndpoint connectionEndpoint : this) {
            inetSocketAddresses.add(connectionEndpoint.toInetSocketAddress());
        }
        return inetSocketAddresses;
    }

    @Override
    public String toString() {
        return this.connectionEndpoints.toString();
    }
}

