/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.spring.LifecycleBeanPostProcessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.OrderComparator;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.data.gemfire.config.annotation.EnableSecurity;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

@Configuration
@Conditional(value={ApacheShiroPresentCondition.class})
public class ApacheShiroSecurityConfiguration
extends AbstractAnnotationConfigSupport {
    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableSecurity.class;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        super.setBeanFactory(Optional.ofNullable(beanFactory).filter(ListableBeanFactory.class::isInstance).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("BeanFactory [%s] must be an instance of ListableBeanFactory", ObjectUtils.nullSafeClassName((Object)beanFactory))));
    }

    protected ListableBeanFactory getListableBeanFactory() {
        return (ListableBeanFactory)this.getBeanFactory();
    }

    @Bean
    public BeanFactoryPostProcessor shiroGemFireBeanFactoryPostProcessor() {
        return configurableListableBeanFactory -> SpringUtils.addDependsOn(configurableListableBeanFactory.getBeanDefinition("gemfireCache"), "shiroSecurityManager");
    }

    @Bean
    public BeanPostProcessor shiroLifecycleBeanPostProcessor() {
        return new LifecycleBeanPostProcessor();
    }

    @Bean
    public SecurityManager shiroSecurityManager() {
        return Optional.ofNullable(this.resolveRealms()).filter(realms -> !realms.isEmpty()).map(realms -> new DefaultSecurityManager((Collection)realms)).map(this::registerSecurityManager).orElse(null);
    }

    protected List<Realm> resolveRealms() {
        try {
            Map realmBeans = this.getListableBeanFactory().getBeansOfType(Realm.class, false, false);
            ArrayList<Realm> realms = new ArrayList<Realm>(CollectionUtils.nullSafeMap(realmBeans).values());
            realms.sort((Comparator<Realm>)OrderComparator.INSTANCE);
            return realms;
        }
        catch (Exception ignore) {
            return Collections.emptyList();
        }
    }

    protected SecurityManager registerSecurityManager(SecurityManager securityManager) {
        Assert.notNull((Object)securityManager, (String)"The Apache Shiro SecurityManager to register must not be null");
        SecurityUtils.setSecurityManager((SecurityManager)securityManager);
        return securityManager;
    }

    public static class ApacheShiroPresentCondition
    implements Condition {
        protected static final String APACHE_SHIRO_LIFECYCLE_BEAN_POST_PROCESSOR_CLASS_NAME = "org.apache.shiro.spring.LifecycleBeanPostProcessor";

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return ClassUtils.isPresent((String)APACHE_SHIRO_LIFECYCLE_BEAN_POST_PROCESSOR_CLASS_NAME, (ClassLoader)context.getClassLoader());
        }
    }
}

