/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import java.util.Properties;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.wiring.BeanConfigurerSupport;
import org.springframework.beans.factory.wiring.BeanWiringInfo;
import org.springframework.data.gemfire.support.DeclarableSupport;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class WiringDeclarableSupport
extends DeclarableSupport {
    protected static final String TEMPLATE_BEAN_NAME_PROPERTY = "bean-name";

    public void init(Properties parameters) {
        this.configureThis(parameters.getProperty(TEMPLATE_BEAN_NAME_PROPERTY));
    }

    protected boolean configureThis(String templateBeanName) {
        return this.configureThis(this.locateBeanFactory(), templateBeanName);
    }

    protected boolean configureThis(BeanFactory beanFactory, String templateBeanName) {
        BeanConfigurerSupport beanConfigurer = this.newBeanConfigurer(beanFactory, templateBeanName);
        beanConfigurer.configureBean((Object)this);
        beanConfigurer.destroy();
        return true;
    }

    protected BeanConfigurerSupport newBeanConfigurer(BeanFactory beanFactory) {
        return this.newBeanConfigurer(beanFactory, null);
    }

    protected BeanConfigurerSupport newBeanConfigurer(BeanFactory beanFactory, String templateBeanName) {
        BeanConfigurerSupport beanConfigurer = new BeanConfigurerSupport();
        beanConfigurer.setBeanFactory(beanFactory);
        if (StringUtils.hasText((String)templateBeanName)) {
            Assert.isTrue((boolean)beanFactory.containsBean(templateBeanName), (String)String.format("Cannot find bean with name [%s]", templateBeanName));
            beanConfigurer.setBeanWiringInfoResolver(beanInstance -> new BeanWiringInfo(templateBeanName));
        }
        beanConfigurer.afterPropertiesSet();
        return beanConfigurer;
    }
}

