/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.search.lucene;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.lucene.LuceneIndex;
import org.apache.geode.cache.lucene.LuceneResultStruct;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.data.gemfire.search.lucene.LuceneTemplate;
import org.springframework.data.gemfire.search.lucene.ProjectingLuceneOperations;
import org.springframework.data.gemfire.search.lucene.support.PdxInstanceMethodInterceptorFactory;
import org.springframework.data.projection.MethodInterceptorFactory;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;

public abstract class ProjectingLuceneAccessor
extends LuceneTemplate
implements BeanClassLoaderAware,
BeanFactoryAware,
ProjectingLuceneOperations {
    private BeanFactory beanFactory;
    private ClassLoader beanClassLoader;
    private ProjectionFactory projectionFactory;

    public ProjectingLuceneAccessor() {
    }

    public ProjectingLuceneAccessor(LuceneIndex luceneIndex) {
        super(luceneIndex);
    }

    public ProjectingLuceneAccessor(String indexName, Region<?, ?> region) {
        super(indexName, region);
    }

    public ProjectingLuceneAccessor(String indexName, String regionPath) {
        super(indexName, regionPath);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.projectionFactory = this.resolveProjectionFactory();
    }

    protected ProjectionFactory resolveProjectionFactory() {
        return Optional.ofNullable(this.getProjectionFactory()).orElseGet(() -> {
            SpelAwareProxyProjectionFactory projectionFactory = new SpelAwareProxyProjectionFactory();
            projectionFactory.setBeanClassLoader(this.getBeanClassLoader());
            projectionFactory.setBeanFactory(this.getBeanFactory());
            projectionFactory.registerMethodInvokerFactory((MethodInterceptorFactory)PdxInstanceMethodInterceptorFactory.INSTANCE);
            return this.setThenGetProjectionFactory((ProjectionFactory)projectionFactory);
        });
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    protected ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected ProjectionFactory setThenGetProjectionFactory(ProjectionFactory projectionFactory) {
        this.setProjectionFactory(projectionFactory);
        return this.getProjectionFactory();
    }

    public void setProjectionFactory(ProjectionFactory projectionFactory) {
        this.projectionFactory = projectionFactory;
    }

    protected ProjectionFactory getProjectionFactory() {
        return this.projectionFactory;
    }

    public <T, K, V> List<T> project(List<LuceneResultStruct<K, V>> source, Class<T> projectionType) {
        return source.stream().map(luceneResultStruct -> this.project((LuceneResultStruct)luceneResultStruct, projectionType)).collect(Collectors.toList());
    }

    public <T, K, V> T project(LuceneResultStruct<K, V> source, Class<T> projectionType) {
        return this.project(source.getValue(), projectionType);
    }

    public <T> T project(Object source, Class<T> projectionType) {
        return (T)this.getProjectionFactory().createProjection(projectionType, source);
    }
}

