/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AspectJTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.gemfire.FixedPartitionAttributesFactoryBean;
import org.springframework.data.gemfire.PartitionAttributesFactoryBean;
import org.springframework.data.gemfire.RegionAttributesFactoryBean;
import org.springframework.data.gemfire.ScopeType;
import org.springframework.data.gemfire.config.annotation.EnableEntityDefinedRegions;
import org.springframework.data.gemfire.config.annotation.LazyResolvingComposableRegionConfigurer;
import org.springframework.data.gemfire.config.annotation.RegionConfigurer;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.config.annotation.support.CacheTypeAwareRegionFactoryBean;
import org.springframework.data.gemfire.config.annotation.support.GemFireComponentClassTypeScanner;
import org.springframework.data.gemfire.mapping.GemfireMappingContext;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.annotation.ClientRegion;
import org.springframework.data.gemfire.mapping.annotation.LocalRegion;
import org.springframework.data.gemfire.mapping.annotation.PartitionRegion;
import org.springframework.data.gemfire.mapping.annotation.Region;
import org.springframework.data.gemfire.mapping.annotation.ReplicateRegion;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class EntityDefinedRegionsConfiguration
extends AbstractAnnotationConfigSupport
implements ImportBeanDefinitionRegistrar {
    protected static final ClientRegionShortcut DEFAULT_CLIENT_REGION_SHORTCUT = ClientRegionShortcut.PROXY;
    protected static final RegionShortcut DEFAULT_SERVER_REGION_SHORTCUT = RegionShortcut.PARTITION;
    @Autowired(required=false)
    private GemfireMappingContext mappingContext;
    @Autowired(required=false)
    private List<RegionConfigurer> regionConfigurers = Collections.emptyList();

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableEntityDefinedRegions.class;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (this.isAnnotationPresent(importingClassMetadata)) {
            AnnotationAttributes enableEntityDefinedRegionsAttributes = this.getAnnotationAttributes(importingClassMetadata);
            this.newGemFireComponentClassTypeScanner(importingClassMetadata, enableEntityDefinedRegionsAttributes).scan().forEach(persistentEntityType -> {
                RegionBeanDefinitionMetadata regionMetadata = RegionBeanDefinitionMetadata.with(this.getPersistentEntity((Class<?>)persistentEntityType)).using(enableEntityDefinedRegionsAttributes);
                this.registerRegionBeanDefinition(regionMetadata, registry);
                this.postProcess(importingClassMetadata, registry, regionMetadata.getPersistentEntity().orElse(null));
            });
        }
    }

    protected GemFireComponentClassTypeScanner newGemFireComponentClassTypeScanner(AnnotationMetadata importingClassMetadata, AnnotationAttributes enableEntityDefinedRegionsAttributes) {
        Set<String> resolvedBasePackages = this.resolveBasePackages(importingClassMetadata, enableEntityDefinedRegionsAttributes);
        return GemFireComponentClassTypeScanner.from(resolvedBasePackages).with(this.resolveBeanClassLoader()).withExcludes(this.resolveExcludes(enableEntityDefinedRegionsAttributes)).withIncludes(this.resolveIncludes(enableEntityDefinedRegionsAttributes)).withIncludes(this.resolveRegionAnnotatedPersistentEntityTypeFilters());
    }

    protected Set<String> resolveBasePackages(AnnotationMetadata importingClassMetaData, AnnotationAttributes enableEntityDefinedRegionAttributes) {
        HashSet<String> resolvedBasePackages = new HashSet<String>();
        Collections.addAll(resolvedBasePackages, (Object[])this.resolveProperty(this.entitiesProperty("base-packages"), String[].class, ArrayUtils.nullSafeArray(ArrayUtils.defaultIfEmpty(enableEntityDefinedRegionAttributes.getStringArray("basePackages"), enableEntityDefinedRegionAttributes.getStringArray("value")), String.class)));
        Arrays.stream(ArrayUtils.nullSafeArray(enableEntityDefinedRegionAttributes.getClassArray("basePackageClasses"), Class.class)).forEach(type -> resolvedBasePackages.add(type.getPackage().getName()));
        if (resolvedBasePackages.isEmpty()) {
            resolvedBasePackages.add(ClassUtils.getPackageName((String)importingClassMetaData.getClassName()));
        }
        return resolvedBasePackages;
    }

    protected Iterable<TypeFilter> resolveExcludes(AnnotationAttributes enableEntityDefinedRegionsAttributes) {
        return this.parseFilters(enableEntityDefinedRegionsAttributes.getAnnotationArray("excludeFilters"));
    }

    protected Iterable<TypeFilter> resolveIncludes(AnnotationAttributes enableEntityDefinedRegionsAttributes) {
        return this.parseFilters(enableEntityDefinedRegionsAttributes.getAnnotationArray("includeFilters"));
    }

    protected Iterable<TypeFilter> resolveRegionAnnotatedPersistentEntityTypeFilters() {
        return Region.REGION_ANNOTATION_TYPES.stream().map(AnnotationTypeFilter::new).collect(Collectors.toSet());
    }

    private Iterable<TypeFilter> parseFilters(AnnotationAttributes[] componentScanFilterAttributes) {
        return Arrays.stream(ArrayUtils.nullSafeArray(componentScanFilterAttributes, AnnotationAttributes.class)).flatMap(filterAttributes -> this.typeFiltersFor((AnnotationAttributes)filterAttributes).stream()).collect(Collectors.toSet());
    }

    private Set<TypeFilter> typeFiltersFor(AnnotationAttributes filterAttributes) {
        HashSet<TypeFilter> typeFilters = new HashSet<TypeFilter>();
        FilterType filterType = (FilterType)filterAttributes.getEnum("type");
        Arrays.stream(ArrayUtils.nullSafeArray(filterAttributes.getClassArray("value"), Class.class)).forEach(filterClass -> {
            switch (filterType) {
                case ANNOTATION: {
                    Assert.isAssignable(Annotation.class, (Class)filterClass, (String)String.format("@ComponentScan.Filter class [%s] must be an Annotation", filterClass));
                    typeFilters.add((TypeFilter)new AnnotationTypeFilter(filterClass));
                    break;
                }
                case ASSIGNABLE_TYPE: {
                    typeFilters.add((TypeFilter)new AssignableTypeFilter(filterClass));
                    break;
                }
                case CUSTOM: {
                    Assert.isAssignable(TypeFilter.class, (Class)filterClass, (String)String.format("@ComponentScan.Filter class [%s] must be a TypeFilter", filterClass));
                    typeFilters.add((TypeFilter)BeanUtils.instantiateClass((Class)filterClass, TypeFilter.class));
                    break;
                }
                default: {
                    throw RuntimeExceptionFactory.newIllegalArgumentException("Illegal filter type [%s] when 'value' or 'classes' are specified", filterType);
                }
            }
            block9: for (String pattern : this.nullSafeGetPatterns(filterAttributes)) {
                switch (filterType) {
                    case ASPECTJ: {
                        typeFilters.add((TypeFilter)new AspectJTypeFilter(pattern, this.resolveBeanClassLoader()));
                        continue block9;
                    }
                    case REGEX: {
                        typeFilters.add((TypeFilter)new RegexPatternTypeFilter(Pattern.compile(pattern)));
                        continue block9;
                    }
                    default: {
                        throw RuntimeExceptionFactory.newIllegalArgumentException("Illegal filter type [%s] when 'patterns' are specified", filterType);
                    }
                }
            }
        });
        return typeFilters;
    }

    private String[] nullSafeGetPatterns(AnnotationAttributes filterAttributes) {
        return SpringUtils.safeGetValue(() -> ArrayUtils.nullSafeArray(filterAttributes.getStringArray("pattern"), String.class), () -> new String[0]);
    }

    protected GemfirePersistentEntity<?> getPersistentEntity(Class<?> persistentEntityType) {
        return (GemfirePersistentEntity)this.resolveMappingContext().getPersistentEntity(persistentEntityType);
    }

    protected GemfireMappingContext resolveMappingContext() {
        return Optional.ofNullable(this.mappingContext).orElseGet(() -> {
            try {
                this.mappingContext = (GemfireMappingContext)((Object)((Object)this.getBeanFactory().getBean(GemfireMappingContext.class)));
            }
            catch (Throwable ignore) {
                this.mappingContext = new GemfireMappingContext();
            }
            return this.mappingContext;
        });
    }

    protected void registerRegionBeanDefinition(RegionBeanDefinitionMetadata regionMetadata, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder regionFactoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(CacheTypeAwareRegionFactoryBean.class).addPropertyReference("cache", "gemfireCache").addPropertyValue("close", (Object)false).addPropertyValue("regionConfigurers", this.resolveRegionConfigurers());
        this.setRegionAttributes(regionFactoryBeanBuilder, regionMetadata);
        registry.registerBeanDefinition(regionMetadata.getRegionName(), (BeanDefinition)regionFactoryBeanBuilder.getBeanDefinition());
    }

    protected List<RegionConfigurer> resolveRegionConfigurers() {
        return Optional.ofNullable(this.regionConfigurers).filter(regionConfigurers -> !regionConfigurers.isEmpty()).orElseGet(() -> Collections.singletonList(LazyResolvingComposableRegionConfigurer.create(this.getBeanFactory())));
    }

    protected BeanDefinitionBuilder setRegionAttributes(BeanDefinitionBuilder regionFactoryBeanBuilder, RegionBeanDefinitionMetadata regionMetadata) {
        Optional.ofNullable(regionMetadata.getRegionAnnotation()).ifPresent(regionAnnotation -> {
            AnnotationAttributes regionAnnotationAttributes = this.getAnnotationAttributes((Annotation)regionAnnotation);
            regionFactoryBeanBuilder.addPropertyValue("clientRegionShortcut", (Object)this.resolveClientRegionShortcut(regionMetadata, (Annotation)regionAnnotation, regionAnnotationAttributes));
            regionFactoryBeanBuilder.addPropertyValue("serverRegionShortcut", (Object)this.resolveServerRegionShortcut(regionMetadata, (Annotation)regionAnnotation, regionAnnotationAttributes));
            if (regionAnnotationAttributes.containsKey((Object)"diskStoreName")) {
                String diskStoreName = regionAnnotationAttributes.getString("diskStoreName");
                this.setPropertyValueIfNotDefault(regionFactoryBeanBuilder, "diskStoreName", diskStoreName, "");
                if (StringUtils.hasText((String)diskStoreName)) {
                    regionFactoryBeanBuilder.addDependsOn(diskStoreName);
                }
            }
            if (regionAnnotationAttributes.containsKey((Object)"ignoreIfExists")) {
                regionFactoryBeanBuilder.addPropertyValue("lookupEnabled", (Object)regionAnnotationAttributes.getBoolean("ignoreIfExists"));
            }
            if (regionMetadata.isStrict()) {
                regionFactoryBeanBuilder.addPropertyValue("keyConstraint", regionMetadata.getRegionKeyConstraint());
                regionFactoryBeanBuilder.addPropertyValue("valueConstraint", regionMetadata.getRegionValueConstraint());
            }
            BeanDefinitionBuilder regionAttributesFactoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(RegionAttributesFactoryBean.class);
            regionFactoryBeanBuilder.addPropertyValue("attributes", (Object)regionAttributesFactoryBeanBuilder.getBeanDefinition());
            if (regionAnnotationAttributes.containsKey((Object)"diskSynchronous")) {
                this.setPropertyValueIfNotDefault(regionAttributesFactoryBeanBuilder, "diskSynchronous", regionAnnotationAttributes.getBoolean("diskSynchronous"), true);
            }
            if (regionAnnotationAttributes.containsKey((Object)"ignoreJta")) {
                this.setPropertyValueIfNotDefault(regionAttributesFactoryBeanBuilder, "ignoreJTA", regionAnnotationAttributes.getBoolean("ignoreJta"), false);
            }
            this.setClientRegionAttributes(regionMetadata, regionAnnotationAttributes, regionFactoryBeanBuilder);
            this.setPartitionRegionAttributes(regionMetadata, regionAnnotationAttributes, regionFactoryBeanBuilder, regionAttributesFactoryBeanBuilder);
            this.setReplicateRegionAttributes(regionMetadata, regionAnnotationAttributes, regionFactoryBeanBuilder);
        });
        return regionFactoryBeanBuilder;
    }

    protected ClientRegionShortcut resolveClientRegionShortcut(RegionBeanDefinitionMetadata regionMetadata, Annotation regionAnnotation, AnnotationAttributes regionAnnotationAttributes) {
        return ClientRegion.class.equals(regionAnnotation.annotationType()) ? (ClientRegionShortcut)regionAnnotationAttributes.getEnum("shortcut") : regionMetadata.resolveClientRegionShortcut(DEFAULT_CLIENT_REGION_SHORTCUT);
    }

    protected RegionShortcut resolveServerRegionShortcut(RegionBeanDefinitionMetadata regionMetadata, Annotation regionAnnotation, AnnotationAttributes regionAnnotationAttributes) {
        boolean persistent;
        Class<? extends Annotation> regionAnnotationType = regionAnnotation.annotationType();
        boolean bl = persistent = regionAnnotationAttributes.containsKey((Object)"persistent") && regionAnnotationAttributes.getBoolean("persistent");
        return LocalRegion.class.equals(regionAnnotationType) ? (persistent ? RegionShortcut.LOCAL_PERSISTENT : RegionShortcut.LOCAL) : (PartitionRegion.class.equals(regionAnnotationType) ? (persistent ? RegionShortcut.PARTITION_PERSISTENT : RegionShortcut.PARTITION) : (ReplicateRegion.class.equals(regionAnnotationType) ? (persistent ? RegionShortcut.REPLICATE_PERSISTENT : RegionShortcut.REPLICATE) : regionMetadata.resolveServerRegionShortcut(DEFAULT_SERVER_REGION_SHORTCUT)));
    }

    protected BeanDefinitionBuilder setClientRegionAttributes(RegionBeanDefinitionMetadata regionMetadata, AnnotationAttributes regionAnnotationAttributes, BeanDefinitionBuilder regionFactoryBeanBuilder) {
        String resolvedPoolName = regionAnnotationAttributes.containsKey((Object)"poolName") ? regionAnnotationAttributes.getString("poolName") : regionMetadata.getPoolName().orElse("DEFAULT");
        this.setPropertyValueIfNotDefault(regionFactoryBeanBuilder, "poolName", resolvedPoolName, "DEFAULT");
        return regionFactoryBeanBuilder;
    }

    protected BeanDefinitionBuilder setPartitionRegionAttributes(RegionBeanDefinitionMetadata regionMetadata, AnnotationAttributes regionAnnotationAttributes, BeanDefinitionBuilder regionFactoryBeanBuilder, BeanDefinitionBuilder regionAttributesFactoryBeanBuilder) {
        if (regionAnnotationAttributes.containsKey((Object)"redundantCopies")) {
            BeanDefinitionBuilder partitionAttributesFactoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(PartitionAttributesFactoryBean.class);
            String collocatedWith = regionAnnotationAttributes.getString("collocatedWith");
            this.setPropertyValueIfNotDefault(partitionAttributesFactoryBeanBuilder, "colocatedWith", collocatedWith, "");
            if (StringUtils.hasText((String)collocatedWith)) {
                regionFactoryBeanBuilder.addDependsOn(collocatedWith);
            }
            this.setPropertyReferenceIfSet(partitionAttributesFactoryBeanBuilder, "partitionResolver", regionAnnotationAttributes.getString("partitionResolverName"));
            this.setPropertyValueIfNotDefault(partitionAttributesFactoryBeanBuilder, "redundantCopies", regionAnnotationAttributes.getNumber("redundantCopies"), 0);
            this.setFixedPartitionRegionAttributes(regionAnnotationAttributes, partitionAttributesFactoryBeanBuilder);
            regionAttributesFactoryBeanBuilder.addPropertyValue("partitionAttributes", (Object)partitionAttributesFactoryBeanBuilder.getBeanDefinition());
        }
        return regionAttributesFactoryBeanBuilder;
    }

    protected BeanDefinitionBuilder setFixedPartitionRegionAttributes(AnnotationAttributes regionAnnotationAttributes, BeanDefinitionBuilder partitionAttributesFactoryBeanBuilder) {
        Object[] fixedPartitions = ArrayUtils.nullSafeArray(regionAnnotationAttributes.getAnnotationArray("fixedPartitions", PartitionRegion.FixedPartition.class), PartitionRegion.FixedPartition.class);
        if (!ObjectUtils.isEmpty((Object[])fixedPartitions)) {
            ManagedList fixedPartitionAttributesFactoryBeans = new ManagedList(fixedPartitions.length);
            for (Object fixedPartition : fixedPartitions) {
                BeanDefinitionBuilder fixedPartitionAttributesFactoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(FixedPartitionAttributesFactoryBean.class);
                fixedPartitionAttributesFactoryBeanBuilder.addPropertyValue("partitionName", (Object)fixedPartition.name());
                this.setPropertyValueIfNotDefault(fixedPartitionAttributesFactoryBeanBuilder, "primary", fixedPartition.primary(), false);
                this.setPropertyValueIfNotDefault(fixedPartitionAttributesFactoryBeanBuilder, "numBuckets", fixedPartition.numBuckets(), 1);
                fixedPartitionAttributesFactoryBeans.add((Object)fixedPartitionAttributesFactoryBeanBuilder.getBeanDefinition());
            }
            partitionAttributesFactoryBeanBuilder.addPropertyValue("fixedPartitionAttributes", (Object)fixedPartitionAttributesFactoryBeans);
        }
        return partitionAttributesFactoryBeanBuilder;
    }

    protected BeanDefinitionBuilder setReplicateRegionAttributes(RegionBeanDefinitionMetadata regionMetadata, AnnotationAttributes regionAnnotationAttributes, BeanDefinitionBuilder regionFactoryBeanBuilder) {
        if (regionAnnotationAttributes.containsKey((Object)"scope")) {
            this.setPropertyValueIfNotDefault(regionFactoryBeanBuilder, "scope", ((ScopeType)regionAnnotationAttributes.getEnum("scope")).getScope(), Scope.DISTRIBUTED_NO_ACK);
        }
        return regionFactoryBeanBuilder;
    }

    private <T> BeanDefinitionBuilder setPropertyReferenceIfSet(BeanDefinitionBuilder beanDefinitionBuilder, String propertyName, String beanName) {
        return StringUtils.hasText((String)beanName) ? beanDefinitionBuilder.addPropertyReference(propertyName, beanName) : beanDefinitionBuilder;
    }

    private <T> BeanDefinitionBuilder setPropertyValueIfNotDefault(BeanDefinitionBuilder beanDefinitionBuilder, String propertyName, T value, T defaultValue) {
        return value != null && !value.equals(defaultValue) ? beanDefinitionBuilder.addPropertyValue(propertyName, value) : beanDefinitionBuilder;
    }

    protected GemfirePersistentEntity<?> postProcess(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry, GemfirePersistentEntity<?> persistentEntity) {
        return persistentEntity;
    }

    protected static class RegionBeanDefinitionMetadata {
        private boolean strict;
        private ClientRegionShortcut clientRegionShortcut;
        private GemfirePersistentEntity<?> persistentEntity;
        private RegionShortcut serverRegionShortcut;
        private String poolName;

        protected static RegionBeanDefinitionMetadata with(GemfirePersistentEntity<?> persistentEntity) {
            return new RegionBeanDefinitionMetadata(persistentEntity);
        }

        protected RegionBeanDefinitionMetadata(GemfirePersistentEntity<?> persistentEntity) {
            Assert.notNull(persistentEntity, (String)"GemfirePersistentEntity is required");
            this.persistentEntity = persistentEntity;
        }

        protected boolean isStrict() {
            return this.strict;
        }

        protected Optional<ClientRegionShortcut> getClientRegionShortcut() {
            return Optional.ofNullable(this.clientRegionShortcut);
        }

        protected ClientRegionShortcut resolveClientRegionShortcut(ClientRegionShortcut defaultClientRegionShortcut) {
            return this.getClientRegionShortcut().orElse(defaultClientRegionShortcut);
        }

        protected Optional<GemfirePersistentEntity<?>> getPersistentEntity() {
            return Optional.ofNullable(this.persistentEntity);
        }

        protected GemfirePersistentEntity<?> resolvePersistentEntity() {
            return this.getPersistentEntity().orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("GemfirePersistentEntity could not be resolved", new Object[0]));
        }

        protected Optional<String> getPoolName() {
            return Optional.ofNullable(this.poolName).filter(StringUtils::hasText);
        }

        protected <T extends Annotation> T getRegionAnnotation() {
            return (T)this.resolvePersistentEntity().getRegionAnnotation();
        }

        protected Class<?> getRegionKeyConstraint() {
            return Optional.ofNullable(this.resolvePersistentEntity().getIdProperty()).map(idProperty -> idProperty.getActualType()).orElse(Object.class);
        }

        protected String getRegionName() {
            return this.resolvePersistentEntity().getRegionName();
        }

        protected Class<?> getRegionValueConstraint() {
            return Optional.ofNullable(this.resolvePersistentEntity().getType()).orElse(Object.class);
        }

        protected Optional<RegionShortcut> getServerRegionShortcut() {
            return Optional.ofNullable(this.serverRegionShortcut);
        }

        protected RegionShortcut resolveServerRegionShortcut(RegionShortcut defaultServerRegionShortcut) {
            return this.getServerRegionShortcut().orElse(defaultServerRegionShortcut);
        }

        protected RegionBeanDefinitionMetadata is(boolean strict) {
            this.strict = strict;
            return this;
        }

        protected RegionBeanDefinitionMetadata using(AnnotationAttributes enableEntityDefinedRegionsAttributes) {
            return Optional.ofNullable(enableEntityDefinedRegionsAttributes).map(it -> this.using((ClientRegionShortcut)it.getEnum("clientRegionShortcut")).using(it.getString("poolName")).using((RegionShortcut)it.getEnum("serverRegionShortcut")).is(it.getBoolean("strict"))).orElse(this);
        }

        protected RegionBeanDefinitionMetadata using(ClientRegionShortcut clientRegionShortcut) {
            this.clientRegionShortcut = clientRegionShortcut;
            return this;
        }

        protected RegionBeanDefinitionMetadata using(RegionShortcut serverRegionShortcut) {
            this.serverRegionShortcut = serverRegionShortcut;
            return this;
        }

        protected RegionBeanDefinitionMetadata using(String poolName) {
            this.poolName = poolName;
            return this;
        }
    }
}

