/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Optional;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.client.GemfireDataSourcePostProcessor;
import org.springframework.data.gemfire.config.annotation.EnableClusterDefinedRegions;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.util.CacheUtils;
import org.springframework.util.Assert;

@Configuration
public class ClusterDefinedRegionsConfiguration
extends AbstractAnnotationConfigSupport
implements ImportAware {
    protected static final ClientRegionShortcut DEFAULT_CLIENT_REGION_SHORTCUT = ClientRegionShortcut.PROXY;
    private ClientRegionShortcut clientRegionShortcut = DEFAULT_CLIENT_REGION_SHORTCUT;

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableClusterDefinedRegions.class;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        AnnotationAttributes enableClusterDefinedRegionsAttributes = this.getAnnotationAttributes(importMetadata);
        this.setClientRegionShortcut((ClientRegionShortcut)enableClusterDefinedRegionsAttributes.getEnum("clientRegionShortcut"));
    }

    protected void setClientRegionShortcut(ClientRegionShortcut clientRegionShortcut) {
        this.clientRegionShortcut = clientRegionShortcut;
    }

    protected Optional<ClientRegionShortcut> getClientRegionShortcut() {
        return Optional.ofNullable(this.clientRegionShortcut);
    }

    protected ClientRegionShortcut resolveClientRegionShortcut() {
        return this.getClientRegionShortcut().orElse(DEFAULT_CLIENT_REGION_SHORTCUT);
    }

    @Bean
    public GemfireDataSourcePostProcessor gemfireDataSourcePostProcessor(GemFireCache gemfireCache) {
        Assert.isTrue((boolean)CacheUtils.isClient(gemfireCache), (String)"GemFireCache must be an instance of ClientCache");
        return new GemfireDataSourcePostProcessor((ClientCache)gemfireCache).using(this.resolveClientRegionShortcut());
    }
}

