/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.admin.functions;

import org.apache.geode.GemFireCheckedException;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.QueryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.gemfire.GemfireCacheUtils;
import org.springframework.data.gemfire.config.schema.definitions.IndexDefinition;
import org.springframework.data.gemfire.function.annotation.GemfireFunction;
import org.springframework.data.gemfire.util.CollectionUtils;

public class CreateIndexFunction {
    public static final String CREATE_INDEX_FUNCTION_ID = "CreateOqlIndexFunction";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @GemfireFunction(id="CreateOqlIndexFunction")
    public boolean createIndex(IndexDefinition indexDefinition) {
        Cache gemfireCache = this.resolveCache();
        if (this.isNonExistingIndex((GemFireCache)gemfireCache, indexDefinition)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Creating Index with name [{}] having expression [{}] on Region [{}] with type [{}]", new Object[]{indexDefinition.getName(), indexDefinition.getExpression(), indexDefinition.getFromClause(), indexDefinition.getIndexType()});
            }
            QueryService queryService = gemfireCache.getQueryService();
            try {
                switch (indexDefinition.getIndexType()) {
                    case KEY: 
                    case PRIMARY_KEY: {
                        queryService.createKeyIndex(indexDefinition.getName(), indexDefinition.getExpression(), indexDefinition.getFromClause());
                        return true;
                    }
                    case HASH: {
                        queryService.createHashIndex(indexDefinition.getName(), indexDefinition.getExpression(), indexDefinition.getFromClause());
                        return true;
                    }
                    case FUNCTIONAL: {
                        queryService.createIndex(indexDefinition.getName(), indexDefinition.getExpression(), indexDefinition.getFromClause());
                        return true;
                    }
                }
                return false;
            }
            catch (QueryException cause) {
                throw GemfireCacheUtils.convertGemfireAccessException((GemFireCheckedException)cause);
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Index with name [{}] already exists", (Object)indexDefinition.getName());
        }
        return false;
    }

    protected Cache resolveCache() {
        return CacheFactory.getAnyInstance();
    }

    protected boolean isNonExistingIndex(GemFireCache gemfireCache, IndexDefinition indexDefinition) {
        return !CollectionUtils.nullSafeCollection(gemfireCache.getQueryService().getIndexes()).stream().anyMatch(index -> index.getName().equals(indexDefinition.getName()));
    }
}

