/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.compression.Compressor;
import org.apache.geode.internal.cache.UserSpecifiedRegionAttributes;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.io.Resource;
import org.springframework.data.gemfire.DataPolicyConverter;
import org.springframework.data.gemfire.RegionLookupFactoryBean;
import org.springframework.data.gemfire.RegionShortcutToDataPolicyConverter;
import org.springframework.data.gemfire.RegionShortcutWrapper;
import org.springframework.data.gemfire.config.annotation.RegionConfigurer;
import org.springframework.data.gemfire.eviction.EvictingRegionFactoryBean;
import org.springframework.data.gemfire.expiration.ExpiringRegionFactoryBean;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class RegionFactoryBean<K, V>
extends RegionLookupFactoryBean<K, V>
implements EvictingRegionFactoryBean,
ExpiringRegionFactoryBean<K, V>,
DisposableBean,
SmartLifecycle {
    protected final Log log = LogFactory.getLog(this.getClass());
    private boolean close = true;
    private boolean destroy = false;
    private boolean running;
    private Boolean offHeap;
    private Boolean persistent;
    private Boolean statisticsEnabled;
    private AsyncEventQueue[] asyncEventQueues;
    private CacheListener<K, V>[] cacheListeners;
    private CacheLoader<K, V> cacheLoader;
    private CacheWriter<K, V> cacheWriter;
    private Class<K> keyConstraint;
    private Class<V> valueConstraint;
    private Compressor compressor;
    private CustomExpiry<K, V> customEntryIdleTimeout;
    private CustomExpiry<K, V> customEntryTimeToLive;
    private DataPolicy dataPolicy;
    private EvictionAttributes evictionAttributes;
    private ExpirationAttributes entryIdleTimeout;
    private ExpirationAttributes entryTimeToLive;
    private ExpirationAttributes regionIdleTimeout;
    private ExpirationAttributes regionTimeToLive;
    private GatewaySender[] gatewaySenders;
    private List<RegionConfigurer> regionConfigurers = Collections.emptyList();
    private RegionAttributes<K, V> attributes;
    private RegionConfigurer compositeRegionConfigurer = new RegionConfigurer(){

        @Override
        public void configure(String beanName, RegionFactoryBean<?, ?> bean) {
            CollectionUtils.nullSafeCollection(RegionFactoryBean.this.regionConfigurers).forEach(regionConfigurer -> regionConfigurer.configure(beanName, bean));
        }
    };
    private RegionShortcut shortcut;
    private Resource snapshot;
    private Scope scope;
    private String diskStoreName;

    @Override
    protected Region<K, V> createRegion(GemFireCache gemfireCache, String regionName) throws Exception {
        this.applyRegionConfigurers(regionName);
        this.verifyLockGrantorEligibility(this.getAttributes(), this.getScope());
        Cache cache = this.resolveCache(gemfireCache);
        RegionFactory<K, V> regionFactory = this.postProcess(this.configure(this.createRegionFactory(cache)));
        Region<K, V> region = this.newRegion(regionFactory, this.getParent(), regionName);
        return this.enableAsLockGrantor(region);
    }

    private void applyRegionConfigurers(String regionName) {
        this.applyRegionConfigurers(regionName, this.getCompositeRegionConfigurer());
    }

    protected void applyRegionConfigurers(String regionName, RegionConfigurer ... regionConfigurers) {
        this.applyRegionConfigurers(regionName, Arrays.asList(ArrayUtils.nullSafeArray(regionConfigurers, RegionConfigurer.class)));
    }

    protected void applyRegionConfigurers(String regionName, Iterable<RegionConfigurer> regionConfigurers) {
        StreamSupport.stream(CollectionUtils.nullSafeIterable(regionConfigurers).spliterator(), false).forEach(regionConfigurer -> regionConfigurer.configure(regionName, this));
    }

    private Region<K, V> enableAsLockGrantor(Region<K, V> region) {
        Optional.ofNullable(region).filter(it -> it.getAttributes().isLockGrantor()).ifPresent(Region::becomeLockGrantor);
        return region;
    }

    private Region<K, V> newRegion(RegionFactory<K, V> regionFactory, Region<?, ?> parentRegion, String regionName) {
        return Optional.ofNullable(parentRegion).map(parent -> {
            this.logInfo("Creating Subregion [%1$s] with parent Region [%2$s]", regionName, parent.getName());
            return regionFactory.createSubregion(parent, regionName);
        }).orElseGet(() -> {
            this.logInfo("Created Region [%1$s]", regionName);
            return regionFactory.create(regionName);
        });
    }

    private Cache resolveCache(GemFireCache gemfireCache) {
        return Optional.ofNullable(gemfireCache).filter(cache -> cache instanceof Cache).map(cache -> (Cache)cache).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("Peer Cache is required", new Object[0]));
    }

    private RegionAttributes<K, V> verifyLockGrantorEligibility(RegionAttributes<K, V> regionAttributes, Scope scope) {
        Optional.ofNullable(regionAttributes).ifPresent(attributes -> Assert.state((!attributes.isLockGrantor() || this.verifyScope(scope) ? 1 : 0) != 0, (String)"Lock Grantor only applies to GLOBAL Scoped Regions"));
        return regionAttributes;
    }

    private boolean verifyScope(Scope scope) {
        return scope == null || Scope.GLOBAL.equals(scope);
    }

    protected RegionFactory<K, V> createRegionFactory(Cache cache) {
        if (this.shortcut != null) {
            RegionFactory<K, V> regionFactory = this.mergeRegionAttributes(cache.createRegionFactory(this.shortcut), this.attributes);
            this.setDataPolicy(this.getDataPolicy(regionFactory, this.shortcut));
            return regionFactory;
        }
        if (this.attributes != null) {
            return cache.createRegionFactory(this.attributes);
        }
        return cache.createRegionFactory();
    }

    protected RegionFactory<K, V> configure(RegionFactory<K, V> regionFactory) {
        regionFactory.setStatisticsEnabled(this.resolveStatisticsEnabled());
        Arrays.stream(ArrayUtils.nullSafeArray(this.asyncEventQueues, AsyncEventQueue.class)).forEach(asyncEventQueue -> regionFactory.addAsyncEventQueueId(asyncEventQueue.getId()));
        Arrays.stream(ArrayUtils.nullSafeArray(this.cacheListeners, CacheListener.class)).forEach(arg_0 -> regionFactory.addCacheListener(arg_0));
        Optional.ofNullable(this.cacheLoader).ifPresent(arg_0 -> regionFactory.setCacheLoader(arg_0));
        Optional.ofNullable(this.cacheWriter).ifPresent(arg_0 -> regionFactory.setCacheWriter(arg_0));
        Optional.ofNullable(this.compressor).ifPresent(arg_0 -> regionFactory.setCompressor(arg_0));
        Optional.ofNullable(this.customEntryIdleTimeout).ifPresent(arg_0 -> regionFactory.setCustomEntryIdleTimeout(arg_0));
        Optional.ofNullable(this.customEntryTimeToLive).ifPresent(arg_0 -> regionFactory.setCustomEntryTimeToLive(arg_0));
        this.resolveDataPolicy(regionFactory, this.persistent, this.dataPolicy);
        Optional.ofNullable(this.diskStoreName).filter(name -> this.isDiskStoreConfigurationAllowed()).ifPresent(arg_0 -> regionFactory.setDiskStoreName(arg_0));
        Optional.ofNullable(this.entryIdleTimeout).ifPresent(arg_0 -> regionFactory.setEntryIdleTimeout(arg_0));
        Optional.ofNullable(this.entryTimeToLive).ifPresent(arg_0 -> regionFactory.setEntryTimeToLive(arg_0));
        Optional.ofNullable(this.evictionAttributes).ifPresent(arg_0 -> regionFactory.setEvictionAttributes(arg_0));
        Arrays.stream(ArrayUtils.nullSafeArray(this.gatewaySenders, GatewaySender.class)).forEach(gatewaySender -> regionFactory.addGatewaySenderId(gatewaySender.getId()));
        Optional.ofNullable(this.keyConstraint).ifPresent(arg_0 -> regionFactory.setKeyConstraint(arg_0));
        Optional.ofNullable(this.regionIdleTimeout).ifPresent(arg_0 -> regionFactory.setRegionIdleTimeout(arg_0));
        Optional.ofNullable(this.regionTimeToLive).ifPresent(arg_0 -> regionFactory.setRegionTimeToLive(arg_0));
        Optional.ofNullable(this.getScope()).ifPresent(arg_0 -> regionFactory.setScope(arg_0));
        Optional.ofNullable(this.valueConstraint).ifPresent(arg_0 -> regionFactory.setValueConstraint(arg_0));
        return regionFactory;
    }

    @Override
    protected RegionFactory<K, V> postProcess(RegionFactory<K, V> regionFactory) {
        Optional.ofNullable(this.offHeap).ifPresent(arg_0 -> regionFactory.setOffHeap(arg_0));
        return regionFactory;
    }

    protected RegionConfigurer getCompositeRegionConfigurer() {
        return this.compositeRegionConfigurer;
    }

    DataPolicy getDataPolicy(RegionFactory regionFactory, RegionShortcut regionShortcut) {
        return this.getFieldValue(regionFactory, "attrsFactory", AttributesFactory.class).flatMap(attributesFactory -> this.getFieldValue(attributesFactory, "regionAttributes", null)).map(regionAttributes -> ((RegionAttributes)regionAttributes).getDataPolicy()).orElseGet(() -> RegionShortcutToDataPolicyConverter.INSTANCE.convert(regionShortcut));
    }

    private <T> Optional<T> getFieldValue(Object source, String fieldName, Class<T> targetType) {
        return Optional.ofNullable(source).map(Object::getClass).map(type -> ReflectionUtils.findField((Class)type, (String)fieldName, (Class)targetType)).map(field -> {
            ReflectionUtils.makeAccessible((Field)field);
            return field;
        }).map(field -> ReflectionUtils.getField((Field)field, (Object)source));
    }

    protected <K, V> RegionFactory<K, V> mergeRegionAttributes(RegionFactory<K, V> regionFactory, RegionAttributes<K, V> regionAttributes) {
        if (regionAttributes != null) {
            this.validateRegionAttributes(regionAttributes);
            regionFactory.setCloningEnabled(regionAttributes.getCloningEnabled());
            regionFactory.setCompressor(regionAttributes.getCompressor());
            regionFactory.setConcurrencyChecksEnabled(regionAttributes.getConcurrencyChecksEnabled());
            regionFactory.setConcurrencyLevel(regionAttributes.getConcurrencyLevel());
            regionFactory.setCustomEntryIdleTimeout(regionAttributes.getCustomEntryIdleTimeout());
            regionFactory.setCustomEntryTimeToLive(regionAttributes.getCustomEntryTimeToLive());
            regionFactory.setDiskSynchronous(regionAttributes.isDiskSynchronous());
            regionFactory.setEnableAsyncConflation(regionAttributes.getEnableAsyncConflation());
            regionFactory.setEnableSubscriptionConflation(regionAttributes.getEnableSubscriptionConflation());
            regionFactory.setEntryIdleTimeout(regionAttributes.getEntryIdleTimeout());
            regionFactory.setEntryTimeToLive(regionAttributes.getEntryTimeToLive());
            if (this.isUserSpecifiedEvictionAttributes(regionAttributes)) {
                regionFactory.setEvictionAttributes(regionAttributes.getEvictionAttributes());
            }
            regionFactory.setIgnoreJTA(regionAttributes.getIgnoreJTA());
            regionFactory.setIndexMaintenanceSynchronous(regionAttributes.getIndexMaintenanceSynchronous());
            regionFactory.setInitialCapacity(regionAttributes.getInitialCapacity());
            regionFactory.setKeyConstraint(regionAttributes.getKeyConstraint());
            regionFactory.setLoadFactor(regionAttributes.getLoadFactor());
            regionFactory.setLockGrantor(regionAttributes.isLockGrantor());
            regionFactory.setMembershipAttributes(regionAttributes.getMembershipAttributes());
            regionFactory.setMulticastEnabled(regionAttributes.getMulticastEnabled());
            regionFactory.setOffHeap(regionAttributes.getOffHeap());
            this.mergePartitionAttributes(regionFactory, regionAttributes);
            regionFactory.setPoolName(regionAttributes.getPoolName());
            regionFactory.setRegionIdleTimeout(regionAttributes.getRegionIdleTimeout());
            regionFactory.setRegionTimeToLive(regionAttributes.getRegionTimeToLive());
            regionFactory.setStatisticsEnabled(regionAttributes.getStatisticsEnabled());
            regionFactory.setSubscriptionAttributes(regionAttributes.getSubscriptionAttributes());
            regionFactory.setValueConstraint(regionAttributes.getValueConstraint());
        }
        return regionFactory;
    }

    protected <K, V> void mergePartitionAttributes(RegionFactory<K, V> regionFactory, RegionAttributes<K, V> regionAttributes) {
        if (regionAttributes.getPartitionAttributes() != null) {
            PartitionAttributes partitionAttributes = regionAttributes.getPartitionAttributes();
            PartitionAttributesFactory partitionAttributesFactory = new PartitionAttributesFactory(partitionAttributes);
            RegionShortcutWrapper shortcutWrapper = RegionShortcutWrapper.valueOf(this.shortcut);
            if (shortcutWrapper.isRedundant() && partitionAttributes.getRedundantCopies() == 0) {
                partitionAttributesFactory.setRedundantCopies(1);
            }
            if (shortcutWrapper.isProxy()) {
                partitionAttributesFactory.setLocalMaxMemory(0);
            }
            regionFactory.setPartitionAttributes(partitionAttributesFactory.create());
        }
    }

    void validateRegionAttributes(RegionAttributes regionAttributes) {
        AttributesFactory.validateAttributes((RegionAttributes)regionAttributes);
    }

    boolean isUserSpecifiedEvictionAttributes(RegionAttributes regionAttributes) {
        return regionAttributes instanceof UserSpecifiedRegionAttributes && ((UserSpecifiedRegionAttributes)regionAttributes).hasEvictionAttributes();
    }

    private boolean isDiskStoreConfigurationAllowed() {
        boolean allow = StringUtils.hasText((String)this.diskStoreName);
        return allow &= this.getDataPolicy().withPersistence() || this.getAttributes() != null && this.getAttributes().getEvictionAttributes() != null && EvictionAction.OVERFLOW_TO_DISK.equals(this.attributes.getEvictionAttributes().getAction());
    }

    protected boolean isPersistent() {
        return Boolean.TRUE.equals(this.persistent);
    }

    protected boolean isPersistentUnspecified() {
        return this.persistent == null;
    }

    protected boolean isNotPersistent() {
        return Boolean.FALSE.equals(this.persistent);
    }

    protected void assertDataPolicyAndPersistentAttributesAreCompatible(DataPolicy resolvedDataPolicy) {
        if (resolvedDataPolicy.withPersistence()) {
            Assert.isTrue((this.isPersistentUnspecified() || this.isPersistent() ? 1 : 0) != 0, (String)String.format("Data Policy [%s] is invalid when persistent is false.", resolvedDataPolicy));
        } else {
            Assert.isTrue((this.isPersistentUnspecified() || this.isNotPersistent() ? 1 : 0) != 0, (String)String.format("Data Policy [%s] is invalid when persistent is true.", resolvedDataPolicy));
        }
    }

    protected void resolveDataPolicy(RegionFactory<K, V> regionFactory, Boolean persistent, DataPolicy dataPolicy) {
        if (dataPolicy != null) {
            this.assertDataPolicyAndPersistentAttributesAreCompatible(dataPolicy);
            regionFactory.setDataPolicy(dataPolicy);
            this.setDataPolicy(dataPolicy);
        } else {
            this.resolveDataPolicy(regionFactory, persistent, (String)null);
        }
    }

    protected void resolveDataPolicy(RegionFactory<K, V> regionFactory, Boolean persistent, String dataPolicy) {
        if (dataPolicy != null) {
            DataPolicy resolvedDataPolicy = new DataPolicyConverter().convert(dataPolicy);
            Assert.notNull((Object)resolvedDataPolicy, (String)String.format("Data Policy [%s] is invalid.", dataPolicy));
            this.assertDataPolicyAndPersistentAttributesAreCompatible(resolvedDataPolicy);
            regionFactory.setDataPolicy(resolvedDataPolicy);
            this.setDataPolicy(resolvedDataPolicy);
        } else {
            DataPolicy regionAttributesDataPolicy = this.getDataPolicy(this.getAttributes(), DataPolicy.DEFAULT);
            DataPolicy resolvedDataPolicy = this.isPersistent() && DataPolicy.DEFAULT.equals(regionAttributesDataPolicy) ? DataPolicy.PERSISTENT_REPLICATE : regionAttributesDataPolicy;
            this.assertDataPolicyAndPersistentAttributesAreCompatible(resolvedDataPolicy);
            regionFactory.setDataPolicy(resolvedDataPolicy);
            this.setDataPolicy(resolvedDataPolicy);
        }
    }

    private DataPolicy getDataPolicy(RegionAttributes regionAttributes, DataPolicy defaultDataPolicy) {
        return Optional.ofNullable(regionAttributes).map(RegionAttributes::getDataPolicy).orElse(defaultDataPolicy);
    }

    public void destroy() throws Exception {
        Optional.ofNullable(this.getObject()).ifPresent(region -> {
            if (this.close && !region.getRegionService().isClosed()) {
                try {
                    region.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.destroy) {
                region.destroyRegion();
            }
        });
    }

    public void setAsyncEventQueues(AsyncEventQueue[] asyncEventQueues) {
        this.asyncEventQueues = asyncEventQueues;
    }

    public void setAttributes(RegionAttributes<K, V> attributes) {
        this.attributes = attributes;
    }

    public RegionAttributes<K, V> getAttributes() {
        return Optional.ofNullable(this.getRegion()).map(Region::getAttributes).orElse(this.attributes);
    }

    public void setCacheListeners(CacheListener<K, V>[] cacheListeners) {
        this.cacheListeners = cacheListeners;
    }

    public void setCacheLoader(CacheLoader<K, V> cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    public void setCacheWriter(CacheWriter<K, V> cacheWriter) {
        this.cacheWriter = cacheWriter;
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public void setCompressor(Compressor compressor) {
        this.compressor = compressor;
    }

    @Override
    public void setCustomEntryIdleTimeout(CustomExpiry<K, V> customEntryIdleTimeout) {
        this.customEntryIdleTimeout = customEntryIdleTimeout;
    }

    @Override
    public void setCustomEntryTimeToLive(CustomExpiry<K, V> customEntryTimeToLive) {
        this.customEntryTimeToLive = customEntryTimeToLive;
    }

    public void setDestroy(boolean destroy) {
        this.destroy = destroy;
    }

    public void setDataPolicy(DataPolicy dataPolicy) {
        this.dataPolicy = dataPolicy;
    }

    @Deprecated
    public void setDataPolicy(String dataPolicyName) {
        this.setDataPolicy(new DataPolicyConverter().convert(dataPolicyName));
    }

    public DataPolicy getDataPolicy() {
        return Optional.ofNullable(this.dataPolicy).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("Data Policy has not been properly resolved yet", new Object[0]));
    }

    public void setDiskStoreName(String diskStoreName) {
        this.diskStoreName = diskStoreName;
    }

    @Override
    public void setEntryIdleTimeout(ExpirationAttributes entryIdleTimeout) {
        this.entryIdleTimeout = entryIdleTimeout;
    }

    @Override
    public void setEntryTimeToLive(ExpirationAttributes entryTimeToLive) {
        this.entryTimeToLive = entryTimeToLive;
    }

    @Override
    public void setEvictionAttributes(EvictionAttributes evictionAttributes) {
        this.evictionAttributes = evictionAttributes;
    }

    public void setGatewaySenders(GatewaySender[] gatewaySenders) {
        this.gatewaySenders = gatewaySenders;
    }

    public void setOffHeap(Boolean offHeap) {
        this.offHeap = offHeap;
    }

    public Boolean getOffHeap() {
        return this.offHeap;
    }

    public boolean isOffHeap() {
        return Boolean.TRUE.equals(this.getOffHeap());
    }

    public void setKeyConstraint(Class<K> keyConstraint) {
        this.keyConstraint = keyConstraint;
    }

    public void setPersistent(Boolean persistent) {
        this.persistent = persistent;
    }

    public void setRegionConfigurers(RegionConfigurer ... regionConfigurers) {
        this.setRegionConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(regionConfigurers, RegionConfigurer.class)));
    }

    public void setRegionConfigurers(List<RegionConfigurer> regionConfigurers) {
        this.regionConfigurers = Optional.ofNullable(regionConfigurers).orElseGet(Collections::emptyList);
    }

    @Override
    public void setRegionIdleTimeout(ExpirationAttributes regionIdleTimeout) {
        this.regionIdleTimeout = regionIdleTimeout;
    }

    @Override
    public void setRegionTimeToLive(ExpirationAttributes regionTimeToLive) {
        this.regionTimeToLive = regionTimeToLive;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setShortcut(RegionShortcut shortcut) {
        this.shortcut = shortcut;
    }

    public RegionShortcut getShortcut() {
        return this.shortcut;
    }

    public void setStatisticsEnabled(Boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    public Boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public boolean isStatisticsEnabled() {
        return Boolean.TRUE.equals(this.getStatisticsEnabled());
    }

    protected boolean resolveStatisticsEnabled() {
        return this.isStatisticsEnabled() || this.customEntryIdleTimeout != null || this.customEntryTimeToLive != null || this.entryIdleTimeout != null || this.entryTimeToLive != null || this.regionIdleTimeout != null || this.regionTimeToLive != null || Optional.ofNullable(this.getAttributes()).map(RegionAttributes::getStatisticsEnabled).orElse(false) != false;
    }

    public void setValueConstraint(Class<V> valueConstraint) {
        this.valueConstraint = valueConstraint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void start() {
        if (!ObjectUtils.isEmpty((Object[])this.gatewaySenders)) {
            GatewaySender[] gatewaySenderArray = this.gatewaySenders;
            // MONITORENTER : this.gatewaySenders
            for (GatewaySender gatewaySender : this.gatewaySenders) {
                if (gatewaySender.isManualStart() || gatewaySender.isRunning()) continue;
                gatewaySender.start();
            }
            // MONITOREXIT : gatewaySenderArray
        }
        this.running = true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void stop() {
        if (!ObjectUtils.isEmpty((Object[])this.gatewaySenders)) {
            GatewaySender[] gatewaySenderArray = this.gatewaySenders;
            // MONITORENTER : this.gatewaySenders
            for (GatewaySender gatewaySender : this.gatewaySenders) {
                gatewaySender.stop();
            }
            // MONITOREXIT : gatewaySenderArray
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public boolean isAutoStartup() {
        return true;
    }
}

