/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.gemfire.function.PojoFunctionWrapper;
import org.springframework.data.gemfire.function.annotation.GemfireFunction;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class GemfireFunctionUtils {
    private static Log log = LogFactory.getLog(GemfireFunctionUtils.class);

    public static boolean isGemfireFunction(Method method) {
        return method != null && method.isAnnotationPresent(GemfireFunction.class);
    }

    private static boolean isMatchingGemfireFunction(Method method, String functionId) {
        return GemfireFunctionUtils.getGemfireFunctionId(method).filter(methodFunctionId -> ObjectUtils.nullSafeEquals((Object)methodFunctionId, (Object)functionId)).isPresent();
    }

    private static AnnotationAttributes getAnnotationAttributes(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        return AnnotationAttributes.fromMap((Map)AnnotationUtils.getAnnotationAttributes((AnnotatedElement)element, (Annotation)element.getAnnotation(annotationType)));
    }

    private static Optional<String> getGemfireFunctionId(Method method) {
        return Optional.ofNullable(method).filter(GemfireFunctionUtils::isGemfireFunction).map(it -> Optional.of(it.getAnnotation(GemfireFunction.class)).map(annotation -> GemfireFunctionUtils.getAnnotationAttributes(it, annotation.getClass())).filter(annotationAttributes -> annotationAttributes.containsKey((Object)"id")).map(annotationAttributes -> annotationAttributes.getString("id")).filter(StringUtils::hasText).orElseGet(() -> it.getName()));
    }

    private static Object constructInstance(Class<?> type, Object ... constructorArguments) {
        return org.springframework.data.util.ReflectionUtils.findConstructor(type, (Object[])constructorArguments).map(constructor -> BeanUtils.instantiateClass((Constructor)constructor, (Object[])constructorArguments)).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("No suitable constructor was found for type [%s] having parameters [%s]", type.getName(), Arrays.stream(ArrayUtils.nullSafeArray(constructorArguments, Object.class)).map(ObjectUtils::nullSafeClassName).collect(Collectors.toList())));
    }

    private static String nullSafeName(Method method) {
        return Optional.ofNullable(method).map(it -> String.format("%s.%s", method.getDeclaringClass().getName(), method.getName())).orElse(null);
    }

    public static void registerFunctionForPojoMethod(Class<?> type, String functionId) {
        Assert.notNull(type, () -> String.format("Class type of POJO containing %s(s) is required", GemfireFunction.class.getName()));
        ReflectionUtils.doWithMethods(type, method -> GemfireFunctionUtils.registerFunctionForPojoMethod(GemfireFunctionUtils.constructInstance(type, new Object[0]), method, GemfireFunctionUtils.getAnnotationAttributes(method, GemfireFunction.class), true), method -> GemfireFunctionUtils.isMatchingGemfireFunction(method, functionId));
    }

    public static void registerFunctionForPojoMethod(Object target, String functionId) {
        Assert.notNull((Object)target, (String)"Target object is required");
        ReflectionUtils.doWithMethods(target.getClass(), method -> GemfireFunctionUtils.registerFunctionForPojoMethod(target, method, GemfireFunctionUtils.getAnnotationAttributes(method, GemfireFunction.class), true), method -> GemfireFunctionUtils.isMatchingGemfireFunction(method, functionId));
    }

    public static void registerFunctionForPojoMethod(Object target, Method method, boolean overwrite) {
        Assert.notNull((Object)target, (String)"Target object is required");
        Assert.isTrue((boolean)GemfireFunctionUtils.isGemfireFunction(method), () -> String.format("Method [%s] must be a %s", GemfireFunctionUtils.nullSafeName(method), GemfireFunction.class.getName()));
        GemfireFunctionUtils.registerFunctionForPojoMethod(target, method, GemfireFunctionUtils.getAnnotationAttributes(method, GemfireFunction.class), overwrite);
    }

    @Deprecated
    public static void registerFunctionForPojoMethod(Object target, Method method, Map<String, Object> gemfireFunctionAttributes, boolean overwrite) {
        GemfireFunctionUtils.registerFunctionForPojoMethod(target, method, AnnotationAttributes.fromMap(gemfireFunctionAttributes), overwrite);
    }

    public static void registerFunctionForPojoMethod(Object target, Method method, AnnotationAttributes gemfireFunctionAttributes, boolean overwrite) {
        String id = gemfireFunctionAttributes.containsKey((Object)"id") ? gemfireFunctionAttributes.getString("id") : "";
        PojoFunctionWrapper function = new PojoFunctionWrapper(target, method, id);
        if (gemfireFunctionAttributes.containsKey((Object)"batchSize")) {
            int batchSize = (Integer)gemfireFunctionAttributes.getNumber("batchSize");
            Assert.isTrue((batchSize >= 0 ? 1 : 0) != 0, (String)String.format("batchSize [%1$d] specified on [%2$s.%3$s] must be a non-negative value", batchSize, target.getClass().getName(), method.getName()));
            function.setBatchSize(batchSize);
        }
        if (gemfireFunctionAttributes.containsKey((Object)"HA")) {
            function.setHA(gemfireFunctionAttributes.getBoolean("HA"));
        }
        if (gemfireFunctionAttributes.containsKey((Object)"hasResult") && Boolean.TRUE.equals(gemfireFunctionAttributes.getBoolean("hasResult"))) {
            function.setHasResult(true);
        }
        if (gemfireFunctionAttributes.containsKey((Object)"optimizeForWrite")) {
            function.setOptimizeForWrite(gemfireFunctionAttributes.getBoolean("optimizeForWrite"));
        }
        if (FunctionService.isRegistered((String)function.getId()) && overwrite) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Unregistering Function [%s]", function.getId()));
            }
            FunctionService.unregisterFunction((String)function.getId());
        }
        if (!FunctionService.isRegistered((String)function.getId())) {
            FunctionService.registerFunction((Function)function);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Registered Function [%s]", function.getId()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Function [%s] is already registered", function.getId()));
        }
    }

    public static int getAnnotationParameterPosition(Method method, Class<?> targetAnnotationType, Class<?>[] requiredTypes) {
        int position = -1;
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations.length > 0) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            List<Class<?>> requiredTypesList = Arrays.asList(requiredTypes);
            for (int index = 0; index < parameterAnnotations.length; ++index) {
                Annotation[] annotations = parameterAnnotations[index];
                if (annotations.length <= 0) continue;
                for (Annotation annotation : annotations) {
                    if (!annotation.annotationType().equals(targetAnnotationType)) continue;
                    Assert.state((position < 0 ? 1 : 0) != 0, (String)String.format("Method %s signature cannot contain more than one parameter annotated with type %s", method.getName(), targetAnnotationType.getName()));
                    boolean isRequiredType = false;
                    for (Class<?> requiredType : requiredTypesList) {
                        if (!requiredType.isAssignableFrom(parameterTypes[index])) continue;
                        isRequiredType = true;
                        break;
                    }
                    Assert.isTrue((boolean)isRequiredType, (String)String.format("Parameter of type %s annotated with %s must be assignable from one of type %s in method %s", parameterTypes[index], targetAnnotationType.getName(), StringUtils.arrayToCommaDelimitedString((Object[])requiredTypes), method.getName()));
                    position = index;
                }
            }
        }
        return position;
    }
}

