/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.mapping;

import com.gemstone.gemfire.pdx.PdxReader;
import com.gemstone.gemfire.pdx.PdxSerializer;
import com.gemstone.gemfire.pdx.PdxWriter;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.gemfire.mapping.GemfireMappingContext;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.mapping.GemfirePropertyValueProvider;
import org.springframework.data.gemfire.mapping.PdxReaderPropertyAccessor;
import org.springframework.data.gemfire.util.AbstractFilter;
import org.springframework.data.gemfire.util.Filter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class MappingPdxSerializer
implements PdxSerializer,
ApplicationContextAware {
    private final ConversionService conversionService;
    private EntityInstantiators entityInstantiators;
    private Filter<Class<?>> excludeTypeFilters = ExcludeNullTypesFilter.EXCLUDE_NULL_TYPES.and(ExcludeComGemstoneGemFireTypesFilter.EXCLUDE_COM_GEMSTONE_GEMFIRE_TYPES).and(ExcludeJavaTypesFilter.EXCLUDE_JAVA_TYPES).and(ExcludeOrgSpringFrameworkTypesFilter.EXCLUDE_ORG_SPRING_FRAMEWORK_TYPES);
    private Filter<Class<?>> includeTypeFilters = ExcludeAllTypesFilter.EXCLUDE_ALL_TYPES;
    private final GemfireMappingContext mappingContext;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<?, PdxSerializer> customPdxSerializers;
    private SpELContext spelContext;

    public static MappingPdxSerializer newMappingPdxSerializer() {
        return MappingPdxSerializer.create(MappingPdxSerializer.newMappingContext(), MappingPdxSerializer.newConversionService());
    }

    public static MappingPdxSerializer create(ConversionService conversionService) {
        return MappingPdxSerializer.create(MappingPdxSerializer.newMappingContext(), conversionService);
    }

    public static MappingPdxSerializer create(GemfireMappingContext mappingContext) {
        return MappingPdxSerializer.create(mappingContext, MappingPdxSerializer.newConversionService());
    }

    public static MappingPdxSerializer create(GemfireMappingContext mappingContext, ConversionService conversionService) {
        return new MappingPdxSerializer(MappingPdxSerializer.resolveMappingContext(mappingContext), MappingPdxSerializer.resolveConversionService(conversionService));
    }

    private static ConversionService newConversionService() {
        return new DefaultConversionService();
    }

    private static ConversionService resolveConversionService(ConversionService conversionService) {
        return conversionService != null ? conversionService : MappingPdxSerializer.newConversionService();
    }

    private static GemfireMappingContext newMappingContext() {
        return new GemfireMappingContext();
    }

    private static GemfireMappingContext resolveMappingContext(GemfireMappingContext mappingContext) {
        return mappingContext != null ? mappingContext : MappingPdxSerializer.newMappingContext();
    }

    public MappingPdxSerializer() {
        this(MappingPdxSerializer.newMappingContext(), MappingPdxSerializer.newConversionService());
    }

    public MappingPdxSerializer(GemfireMappingContext mappingContext, ConversionService conversionService) {
        Assert.notNull((Object)((Object)mappingContext), (String)"MappingContext must not be null");
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null");
        this.mappingContext = mappingContext;
        this.conversionService = conversionService;
        this.entityInstantiators = new EntityInstantiators();
        this.customPdxSerializers = Collections.emptyMap();
        this.spelContext = new SpELContext((PropertyAccessor)PdxReaderPropertyAccessor.INSTANCE);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.spelContext = new SpELContext(this.spelContext, (BeanFactory)applicationContext);
    }

    protected ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setCustomPdxSerializers(Map<?, PdxSerializer> customPdxSerializers) {
        Assert.notNull(customPdxSerializers, (String)"Custom PdxSerializers must not be null");
        this.customPdxSerializers = customPdxSerializers;
    }

    @Deprecated
    public void setCustomSerializers(Map<Class<?>, PdxSerializer> customSerializers) {
        this.setCustomPdxSerializers(customSerializers);
    }

    protected Map<?, PdxSerializer> getCustomPdxSerializers() {
        return Collections.unmodifiableMap(this.customPdxSerializers);
    }

    @Deprecated
    protected Map<Class<?>, PdxSerializer> getCustomSerializers() {
        return this.getCustomPdxSerializers();
    }

    protected PdxSerializer getCustomPdxSerializer(PersistentProperty<?> property) {
        Map<?, PdxSerializer> customPdxSerializers = this.getCustomPdxSerializers();
        PdxSerializer customPdxSerializer = customPdxSerializers.get(property);
        customPdxSerializer = customPdxSerializer != null ? customPdxSerializer : customPdxSerializers.get(this.toFullyQualifiedPropertyName(property));
        customPdxSerializer = customPdxSerializer != null ? customPdxSerializer : customPdxSerializers.get(property.getType());
        return customPdxSerializer;
    }

    String toFullyQualifiedPropertyName(PersistentProperty<?> property) {
        return property.getOwner().getType().getName().concat(".").concat(property.getName());
    }

    @Deprecated
    protected PdxSerializer getCustomSerializer(Class<?> type) {
        return this.getCustomPdxSerializers().get(type);
    }

    public void setGemfireInstantiators(EntityInstantiators entityInstantiators) {
        Assert.notNull((Object)entityInstantiators, (String)"EntityInstantiators must not be null");
        this.entityInstantiators = entityInstantiators;
    }

    public void setGemfireInstantiators(Map<Class<?>, EntityInstantiator> gemfireInstantiators) {
        Assert.notNull(gemfireInstantiators, (String)"GemFire EntityInstantiators are required");
        this.entityInstantiators = new EntityInstantiators(gemfireInstantiators);
    }

    protected EntityInstantiators getGemfireInstantiators() {
        return this.entityInstantiators;
    }

    protected EntityInstantiator getInstantiatorFor(PersistentEntity entity) {
        return this.getGemfireInstantiators().getInstantiatorFor(entity);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected GemfireMappingContext getMappingContext() {
        return this.mappingContext;
    }

    protected GemfirePersistentEntity<?> getPersistentEntity(Object entity) {
        return this.getPersistentEntity(entity.getClass());
    }

    protected GemfirePersistentEntity<?> getPersistentEntity(Class<?> entityType) {
        return (GemfirePersistentEntity)this.getMappingContext().getPersistentEntity(entityType);
    }

    public void setExcludeTypeFilters(Filter<Class<?>> typeFilters) {
        this.excludeTypeFilters = typeFilters != null ? this.excludeTypeFilters.and(typeFilters) : this.excludeTypeFilters;
    }

    public void setIncludeTypeFilters(Filter<Class<?>> typeFilters) {
        this.includeTypeFilters = typeFilters != null ? this.includeTypeFilters.or(typeFilters) : this.includeTypeFilters;
    }

    protected Filter<Class<?>> getTypeFilters() {
        return this.excludeTypeFilters.or(ExcludeNullTypesFilter.EXCLUDE_NULL_TYPES.and(this.includeTypeFilters));
    }

    public Object fromData(Class<?> type, PdxReader reader) {
        return this.getTypeFilters().accept(type) ? this.doFromData(type, reader) : null;
    }

    Object doFromData(final Class<?> type, final PdxReader reader) {
        final GemfirePersistentEntity<?> entity = this.getPersistentEntity(type);
        final Object instance = this.getInstantiatorFor((PersistentEntity)entity).createInstance(entity, (ParameterValueProvider)new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)new GemfirePropertyValueProvider(reader), null));
        ConvertingPropertyAccessor propertyAccessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(instance), this.getConversionService());
        entity.doWithProperties((PropertyHandler)new PropertyHandler<GemfirePersistentProperty>((PersistentPropertyAccessor)propertyAccessor){
            final /* synthetic */ PersistentPropertyAccessor val$propertyAccessor;
            {
                this.val$propertyAccessor = persistentPropertyAccessor;
            }

            public void doWithPersistentProperty(GemfirePersistentProperty persistentProperty) {
                if (MappingPdxSerializer.this.isWritable(entity, persistentProperty)) {
                    PdxSerializer customPdxSerializer = MappingPdxSerializer.this.getCustomPdxSerializer((PersistentProperty<?>)persistentProperty);
                    Object value = null;
                    try {
                        if (MappingPdxSerializer.this.getLogger().isDebugEnabled()) {
                            MappingPdxSerializer.this.getLogger().debug(String.format("Setting property [%1$s] for entity [%2$s] of type [%3$s] from PDX%4$s", persistentProperty.getName(), instance, type, customPdxSerializer != null ? String.format(" using custom PdxSerializer [%1$s]", customPdxSerializer) : ""));
                        }
                        value = customPdxSerializer != null ? customPdxSerializer.fromData(persistentProperty.getType(), reader) : reader.readField(persistentProperty.getName());
                        this.val$propertyAccessor.setProperty((PersistentProperty)persistentProperty, value);
                    }
                    catch (Exception cause) {
                        throw new MappingException(String.format("While setting value [%1$s] of property [%2$s] for entity of type [%3$s] from PDX%4$s", value, persistentProperty.getName(), type, customPdxSerializer != null ? String.format(" using custom PdxSerializer [%1$s]", customPdxSerializer) : ""), (Throwable)cause);
                    }
                }
            }
        });
        return propertyAccessor.getBean();
    }

    boolean isWritable(GemfirePersistentEntity<?> entity, GemfirePersistentProperty persistentProperty) {
        return !entity.isConstructorArgument((PersistentProperty)persistentProperty) && persistentProperty.isWritable() && !persistentProperty.isTransient();
    }

    public boolean toData(Object value, PdxWriter writer) {
        return this.getTypeFilters().accept(this.resolveType(value)) && this.doToData(value, writer);
    }

    boolean doToData(Object value, PdxWriter writer) {
        GemfirePersistentEntity<?> entity = this.getPersistentEntity(value);
        if (entity != null) {
            ConvertingPropertyAccessor propertyAccessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(value), this.getConversionService());
            entity.doWithProperties((PropertyHandler)new PropertyHandler<GemfirePersistentProperty>((PersistentPropertyAccessor)propertyAccessor, entity, writer){
                final /* synthetic */ PersistentPropertyAccessor val$propertyAccessor;
                final /* synthetic */ GemfirePersistentEntity val$entity;
                final /* synthetic */ PdxWriter val$writer;
                {
                    this.val$propertyAccessor = persistentPropertyAccessor;
                    this.val$entity = gemfirePersistentEntity;
                    this.val$writer = pdxWriter;
                }

                public void doWithPersistentProperty(GemfirePersistentProperty persistentProperty) {
                    if (MappingPdxSerializer.this.isReadable(persistentProperty)) {
                        PdxSerializer customPdxSerializer = MappingPdxSerializer.this.getCustomPdxSerializer((PersistentProperty<?>)persistentProperty);
                        Object propertyValue = null;
                        try {
                            propertyValue = this.val$propertyAccessor.getProperty((PersistentProperty)persistentProperty);
                            if (MappingPdxSerializer.this.getLogger().isDebugEnabled()) {
                                MappingPdxSerializer.this.getLogger().debug(String.format("Serializing entity [%1$s] property [%2$s] value [%3$s] of type [%4$s] to PDX%5$s", this.val$entity.getType().getName(), persistentProperty.getName(), propertyValue, ObjectUtils.nullSafeClassName((Object)propertyValue), customPdxSerializer != null ? String.format(" using custom PdxSerializer [%s]", customPdxSerializer) : ""));
                            }
                            if (customPdxSerializer != null) {
                                customPdxSerializer.toData(propertyValue, this.val$writer);
                            } else {
                                this.val$writer.writeField(persistentProperty.getName(), propertyValue, persistentProperty.getType());
                            }
                        }
                        catch (Exception cause) {
                            throw new MappingException(String.format("While serializing entity [%1$s] property [%2$s] value [%3$s] of type [%4$s] to PDX%5$s", this.val$entity.getType().getName(), persistentProperty.getName(), propertyValue, ObjectUtils.nullSafeClassName((Object)propertyValue), customPdxSerializer != null ? String.format(" using custom PdxSerializer [%1$s].", customPdxSerializer.getClass().getName()) : ""), (Throwable)cause);
                        }
                    }
                }
            });
            GemfirePersistentProperty idProperty = (GemfirePersistentProperty)entity.getIdProperty();
            if (idProperty != null) {
                writer.markIdentityField(idProperty.getName());
            }
            return true;
        }
        return false;
    }

    boolean isReadable(GemfirePersistentProperty persistentProperty) {
        return !persistentProperty.isTransient();
    }

    Class<?> resolveType(Object obj) {
        return obj != null ? obj.getClass() : null;
    }

    public static class ExcludeOrgSpringFrameworkTypesFilter
    extends AbstractFilter<Class<?>> {
        public static final Filter<Class<?>> EXCLUDE_ORG_SPRING_FRAMEWORK_TYPES = new ExcludeOrgSpringFrameworkTypesFilter();
        protected static final String ORG_SPRING_FRAMEWORK_PACKAGE_NAME = "org.springframework";

        @Override
        public boolean accept(Class<?> type) {
            return type != null && !type.getPackage().getName().startsWith(ORG_SPRING_FRAMEWORK_PACKAGE_NAME);
        }
    }

    public static class ExcludeNullTypesFilter
    extends AbstractFilter<Class<?>> {
        public static final Filter<Class<?>> EXCLUDE_NULL_TYPES = new ExcludeNullTypesFilter();

        @Override
        public boolean accept(Class<?> type) {
            return type != null;
        }
    }

    public static class ExcludeJavaTypesFilter
    extends AbstractFilter<Class<?>> {
        public static final Filter<Class<?>> EXCLUDE_JAVA_TYPES = new ExcludeJavaTypesFilter();
        protected static final String JAVA_PACKAGE_NAME = "java";

        @Override
        public boolean accept(Class<?> type) {
            return type != null && !type.getPackage().getName().startsWith(JAVA_PACKAGE_NAME);
        }
    }

    public static class ExcludeComGemstoneGemFireTypesFilter
    extends AbstractFilter<Class<?>> {
        public static final Filter<Class<?>> EXCLUDE_COM_GEMSTONE_GEMFIRE_TYPES = new ExcludeComGemstoneGemFireTypesFilter();
        protected static final String COM_GEMSTONE_GEMFIRE_PACKAGE_NAME = "com.gemstone.gemfire";

        @Override
        public boolean accept(Class<?> type) {
            return type != null && !type.getPackage().getName().startsWith(COM_GEMSTONE_GEMFIRE_PACKAGE_NAME);
        }
    }

    public static class ExcludeAllTypesFilter
    extends AbstractFilter<Class<?>> {
        public static final Filter<Class<?>> EXCLUDE_ALL_TYPES = new ExcludeAllTypesFilter();

        @Override
        public boolean accept(Class<?> obj) {
            return false;
        }
    }
}

