/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AspectJTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.gemfire.FixedPartitionAttributesFactoryBean;
import org.springframework.data.gemfire.LocalRegionFactoryBean;
import org.springframework.data.gemfire.PartitionAttributesFactoryBean;
import org.springframework.data.gemfire.PartitionedRegionFactoryBean;
import org.springframework.data.gemfire.RegionAttributesFactoryBean;
import org.springframework.data.gemfire.RegionLookupFactoryBean;
import org.springframework.data.gemfire.ReplicatedRegionFactoryBean;
import org.springframework.data.gemfire.ScopeType;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.config.annotation.EnableEntityDefinedRegions;
import org.springframework.data.gemfire.config.annotation.support.GemFireCacheTypeAwareRegionFactoryBean;
import org.springframework.data.gemfire.config.annotation.support.GemFireComponentClassTypeScanner;
import org.springframework.data.gemfire.mapping.ClientRegion;
import org.springframework.data.gemfire.mapping.GemfireMappingContext;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.LocalRegion;
import org.springframework.data.gemfire.mapping.PartitionRegion;
import org.springframework.data.gemfire.mapping.Region;
import org.springframework.data.gemfire.mapping.ReplicateRegion;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class EntityDefinedRegionsConfiguration
implements BeanClassLoaderAware,
BeanFactoryAware,
ImportBeanDefinitionRegistrar {
    protected static final Class<? extends RegionLookupFactoryBean> DEFAULT_REGION_FACTORY_BEAN_CLASS = GemFireCacheTypeAwareRegionFactoryBean.class;
    protected static final Map<Class<? extends Annotation>, Class<? extends RegionLookupFactoryBean>> regionAnnotationToRegionFactoryBeanClass = new HashMap<Class<? extends Annotation>, Class<? extends RegionLookupFactoryBean>>();
    private BeanFactory beanFactory;
    private ClassLoader beanClassLoader;
    private GemfireMappingContext mappingContext;

    protected Class<? extends Annotation> getAnnotationType() {
        return EnableEntityDefinedRegions.class;
    }

    protected String getAnnotationTypeName() {
        return this.getAnnotationType().getName();
    }

    protected String getAnnotationTypeSimpleName() {
        return this.getAnnotationType().getSimpleName();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    protected ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected boolean isAnnotationPresent(AnnotationMetadata importingClassMetadata) {
        return this.isAnnotationPresent(importingClassMetadata, this.getAnnotationTypeName());
    }

    protected boolean isAnnotationPresent(AnnotationMetadata importingClassMetadata, String annotationName) {
        return importingClassMetadata.hasAnnotation(annotationName);
    }

    protected AnnotationAttributes getAnnotationAttributes(AnnotationMetadata importingClassMetadata) {
        return this.getAnnotationAttributes(importingClassMetadata, this.getAnnotationTypeName());
    }

    protected AnnotationAttributes getAnnotationAttributes(AnnotationMetadata importingClassMetadata, String annotationName) {
        return AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(annotationName));
    }

    protected GemfirePersistentEntity<?> getPersistentEntity(Class<?> persistentEntityType) {
        return (GemfirePersistentEntity)this.resolveMappingContext().getPersistentEntity(persistentEntityType);
    }

    protected GemfireMappingContext resolveMappingContext() {
        if (this.mappingContext == null) {
            try {
                this.mappingContext = (GemfireMappingContext)((Object)this.getBeanFactory().getBean(GemfireMappingContext.class));
            }
            catch (Throwable ignore) {
                this.mappingContext = new GemfireMappingContext();
            }
        }
        return this.mappingContext;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (this.isAnnotationPresent(importingClassMetadata)) {
            AnnotationAttributes enableEntityDefinedRegionsAttributes = this.getAnnotationAttributes(importingClassMetadata);
            boolean strict = enableEntityDefinedRegionsAttributes.getBoolean("strict");
            for (Class<?> persistentEntityClass : this.newGemFireComponentClassTypeScanner(importingClassMetadata, enableEntityDefinedRegionsAttributes).scan()) {
                GemfirePersistentEntity<?> persistentEntity = this.getPersistentEntity(persistentEntityClass);
                this.registerRegionBeanDefinition(persistentEntity, strict, registry);
                this.postProcess(importingClassMetadata, registry, persistentEntity);
            }
        }
    }

    protected GemFireComponentClassTypeScanner newGemFireComponentClassTypeScanner(AnnotationMetadata importingClassMetadata, AnnotationAttributes enableEntityDefinedRegionsAttributes) {
        Set<String> resolvedBasePackages = this.resolveBasePackages(importingClassMetadata, enableEntityDefinedRegionsAttributes);
        return GemFireComponentClassTypeScanner.from(resolvedBasePackages).with(this.resolveBeanClassLoader()).withExcludes(this.resolveExcludes(enableEntityDefinedRegionsAttributes)).withIncludes(this.resolveIncludes(enableEntityDefinedRegionsAttributes)).withIncludes(this.regionAnnotatedPersistentEntityTypeFilters());
    }

    protected Set<String> resolveBasePackages(AnnotationMetadata importingClassMetaData, AnnotationAttributes enableEntityDefinedRegionAttributes) {
        HashSet<String> resolvedBasePackages = new HashSet<String>();
        Collections.addAll(resolvedBasePackages, ArrayUtils.nullSafeArray(ArrayUtils.defaultIfEmpty(enableEntityDefinedRegionAttributes.getStringArray("basePackages"), enableEntityDefinedRegionAttributes.getStringArray("value")), String.class));
        for (Class type : ArrayUtils.nullSafeArray(enableEntityDefinedRegionAttributes.getClassArray("basePackageClasses"), Class.class)) {
            resolvedBasePackages.add(type.getPackage().getName());
        }
        if (resolvedBasePackages.isEmpty()) {
            resolvedBasePackages.add(ClassUtils.getPackageName((String)importingClassMetaData.getClassName()));
        }
        return resolvedBasePackages;
    }

    protected ClassLoader resolveBeanClassLoader() {
        return this.beanClassLoader != null ? this.beanClassLoader : Thread.currentThread().getContextClassLoader();
    }

    protected Iterable<TypeFilter> resolveExcludes(AnnotationAttributes enableEntityDefinedRegionsAttributes) {
        return this.parseFilters(enableEntityDefinedRegionsAttributes.getAnnotationArray("excludeFilters"));
    }

    protected Iterable<TypeFilter> resolveIncludes(AnnotationAttributes enableEntityDefinedRegionsAttributes) {
        return this.parseFilters(enableEntityDefinedRegionsAttributes.getAnnotationArray("includeFilters"));
    }

    private Iterable<TypeFilter> parseFilters(AnnotationAttributes[] componentScanFilterAttributes) {
        HashSet<TypeFilter> typeFilters = new HashSet<TypeFilter>();
        for (AnnotationAttributes filterAttributes : ArrayUtils.nullSafeArray(componentScanFilterAttributes, AnnotationAttributes.class)) {
            CollectionUtils.addAll(typeFilters, this.typeFiltersFor(filterAttributes));
        }
        return typeFilters;
    }

    private Iterable<TypeFilter> typeFiltersFor(AnnotationAttributes filterAttributes) {
        HashSet<TypeFilter> typeFilters = new HashSet<TypeFilter>();
        FilterType filterType = (FilterType)filterAttributes.getEnum("type");
        for (Class filterClass : ArrayUtils.nullSafeArray(filterAttributes.getClassArray("value"), Class.class)) {
            switch (filterType) {
                case ANNOTATION: {
                    Assert.isAssignable(Annotation.class, (Class)filterClass, (String)String.format("@ComponentScan.Filter class [%s] must be an Annotation", filterClass));
                    typeFilters.add((TypeFilter)new AnnotationTypeFilter(filterClass));
                    break;
                }
                case ASSIGNABLE_TYPE: {
                    typeFilters.add((TypeFilter)new AssignableTypeFilter(filterClass));
                    break;
                }
                case CUSTOM: {
                    Assert.isAssignable(TypeFilter.class, (Class)filterClass, (String)String.format("@ComponentScan.Filter class [%s] must be a TypeFilter", filterClass));
                    typeFilters.add((TypeFilter)BeanUtils.instantiateClass((Class)filterClass, TypeFilter.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Illegal filter type [%s] when 'value' or 'classes' are specified", filterType));
                }
            }
            block10: for (String pattern : this.nullSafeGetPatterns(filterAttributes)) {
                switch (filterType) {
                    case ASPECTJ: {
                        typeFilters.add((TypeFilter)new AspectJTypeFilter(pattern, this.resolveBeanClassLoader()));
                        continue block10;
                    }
                    case REGEX: {
                        typeFilters.add((TypeFilter)new RegexPatternTypeFilter(Pattern.compile(pattern)));
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Illegal filter type [%s] when 'patterns' are specified", filterType));
                    }
                }
            }
        }
        return typeFilters;
    }

    private String[] nullSafeGetPatterns(AnnotationAttributes filterAttributes) {
        try {
            return ArrayUtils.nullSafeArray(filterAttributes.getStringArray("pattern"), String.class);
        }
        catch (IllegalArgumentException ignore) {
            return new String[0];
        }
    }

    protected Iterable<TypeFilter> regionAnnotatedPersistentEntityTypeFilters() {
        HashSet<TypeFilter> regionAnnotatedPersistentEntityTypeFilters = new HashSet<TypeFilter>();
        for (Class<? extends Annotation> annotationType : Region.REGION_ANNOTATION_TYPES) {
            regionAnnotatedPersistentEntityTypeFilters.add((TypeFilter)new AnnotationTypeFilter(annotationType));
        }
        return regionAnnotatedPersistentEntityTypeFilters;
    }

    protected void registerRegionBeanDefinition(GemfirePersistentEntity persistentEntity, boolean strict, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder regionFactoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(this.resolveRegionFactoryBeanClass(persistentEntity)).addPropertyReference("cache", "gemfireCache").addPropertyValue("close", (Object)false);
        this.setRegionAttributes(persistentEntity, regionFactoryBeanBuilder, strict);
        registry.registerBeanDefinition(persistentEntity.getRegionName(), (BeanDefinition)regionFactoryBeanBuilder.getBeanDefinition());
    }

    protected Class<? extends RegionLookupFactoryBean> resolveRegionFactoryBeanClass(GemfirePersistentEntity persistentEntity) {
        return (Class)com.gemstone.gemfire.internal.lang.ObjectUtils.defaultIfNull((Object[])new Class[]{regionAnnotationToRegionFactoryBeanClass.get(persistentEntity.getRegionAnnotationType()), DEFAULT_REGION_FACTORY_BEAN_CLASS});
    }

    protected BeanDefinitionBuilder setRegionAttributes(GemfirePersistentEntity persistentEntity, BeanDefinitionBuilder regionFactoryBeanBuilder, boolean strict) {
        Object regionAnnotation = persistentEntity.getRegionAnnotation();
        if (regionAnnotation != null) {
            AnnotationAttributes regionAnnotationAttributes = AnnotationAttributes.fromMap((Map)AnnotationUtils.getAnnotationAttributes(regionAnnotation));
            if (strict) {
                regionFactoryBeanBuilder.addPropertyValue("keyConstraint", this.resolveIdType(persistentEntity));
                regionFactoryBeanBuilder.addPropertyValue("valueConstraint", this.resolveDomainType(persistentEntity));
            }
            if (regionAnnotationAttributes.containsKey((Object)"diskStoreName")) {
                String diskStoreName = regionAnnotationAttributes.getString("diskStoreName");
                this.setPropertyValueIfNotDefault(regionFactoryBeanBuilder, "diskStoreName", diskStoreName, "");
                if (StringUtils.hasText((String)diskStoreName)) {
                    regionFactoryBeanBuilder.addDependsOn(diskStoreName);
                }
            }
            if (regionAnnotationAttributes.containsKey((Object)"persistent")) {
                this.setPropertyValueIfNotDefault(regionFactoryBeanBuilder, "persistent", regionAnnotationAttributes.getBoolean("persistent"), false);
            }
            BeanDefinitionBuilder regionAttributesFactoryBeanBuilder = this.resolveRegionAttributesFactoryBeanBuilder((Annotation)regionAnnotation, regionFactoryBeanBuilder);
            if (regionAnnotationAttributes.containsKey((Object)"diskSynchronous")) {
                this.setPropertyValueIfNotDefault(regionAttributesFactoryBeanBuilder, "diskSynchronous", regionAnnotationAttributes.getBoolean("diskSynchronous"), true);
            }
            if (regionAnnotationAttributes.containsKey((Object)"ignoreJta")) {
                this.setPropertyValueIfNotDefault(regionAttributesFactoryBeanBuilder, "ignoreJTA", regionAnnotationAttributes.getBoolean("ignoreJta"), false);
            }
            this.setClientRegionAttributes(regionAnnotationAttributes, regionFactoryBeanBuilder);
            this.setPartitionRegionAttributes(regionAnnotationAttributes, regionFactoryBeanBuilder, regionAttributesFactoryBeanBuilder);
            this.setReplicateRegionAttributes(regionAnnotationAttributes, regionFactoryBeanBuilder);
        }
        return regionFactoryBeanBuilder;
    }

    protected Class<?> resolveDomainType(GemfirePersistentEntity persistentEntity) {
        return (Class)com.gemstone.gemfire.internal.lang.ObjectUtils.defaultIfNull((Object[])new Class[]{persistentEntity.getType(), Object.class});
    }

    protected Class<?> resolveIdType(GemfirePersistentEntity persistentEntity) {
        return persistentEntity.hasIdProperty() ? (Class)com.gemstone.gemfire.internal.lang.ObjectUtils.defaultIfNull((Object[])new Class[]{persistentEntity.getIdProperty().getActualType(), Object.class}) : Object.class;
    }

    protected BeanDefinitionBuilder resolveRegionAttributesFactoryBeanBuilder(Annotation regionAnnotation, BeanDefinitionBuilder regionFactoryBeanBuilder) {
        BeanDefinitionBuilder regionAttributesFactoryBeanBuilder = regionFactoryBeanBuilder;
        if (!ClientRegion.class.isAssignableFrom(regionAnnotation.annotationType())) {
            regionAttributesFactoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(RegionAttributesFactoryBean.class);
            regionFactoryBeanBuilder.addPropertyValue("attributes", (Object)regionAttributesFactoryBeanBuilder.getBeanDefinition());
        }
        return regionAttributesFactoryBeanBuilder;
    }

    protected BeanDefinitionBuilder setClientRegionAttributes(AnnotationAttributes regionAnnotationAttributes, BeanDefinitionBuilder regionFactoryBeanBuilder) {
        if (regionAnnotationAttributes.containsKey((Object)"poolName")) {
            this.setPropertyValueIfNotDefault(regionFactoryBeanBuilder, "poolName", regionAnnotationAttributes.getString("poolName"), null);
        }
        if (regionAnnotationAttributes.containsKey((Object)"shortcut")) {
            this.setPropertyValueIfNotDefault(regionFactoryBeanBuilder, "shortcut", regionAnnotationAttributes.getEnum("shortcut"), ClientRegionShortcut.PROXY);
        }
        return regionFactoryBeanBuilder;
    }

    protected BeanDefinitionBuilder setPartitionRegionAttributes(AnnotationAttributes regionAnnotationAttributes, BeanDefinitionBuilder regionFactoryBeanBuilder, BeanDefinitionBuilder regionAttributesFactoryBeanBuilder) {
        if (regionAnnotationAttributes.containsKey((Object)"redundantCopies")) {
            BeanDefinitionBuilder partitionAttributesFactoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(PartitionAttributesFactoryBean.class);
            String collocatedWith = regionAnnotationAttributes.getString("collocatedWith");
            this.setPropertyValueIfNotDefault(partitionAttributesFactoryBeanBuilder, "colocatedWith", collocatedWith, "");
            if (StringUtils.hasText((String)collocatedWith)) {
                regionFactoryBeanBuilder.addDependsOn(collocatedWith);
            }
            this.setPropertyReferenceIfSet(partitionAttributesFactoryBeanBuilder, "partitionResolver", regionAnnotationAttributes.getString("partitionResolverName"));
            this.setPropertyValueIfNotDefault(partitionAttributesFactoryBeanBuilder, "redundantCopies", regionAnnotationAttributes.getNumber("redundantCopies"), 0);
            this.setFixedPartitionRegionAttributes(regionAnnotationAttributes, partitionAttributesFactoryBeanBuilder);
            regionAttributesFactoryBeanBuilder.addPropertyValue("partitionAttributes", (Object)partitionAttributesFactoryBeanBuilder.getBeanDefinition());
        }
        return regionAttributesFactoryBeanBuilder;
    }

    protected BeanDefinitionBuilder setFixedPartitionRegionAttributes(AnnotationAttributes regionAnnotationAttributes, BeanDefinitionBuilder partitionAttributesFactoryBeanBuilder) {
        Object[] fixedPartitions = ArrayUtils.nullSafeArray(regionAnnotationAttributes.getAnnotationArray("fixedPartitions", PartitionRegion.FixedPartition.class), PartitionRegion.FixedPartition.class);
        if (!ObjectUtils.isEmpty((Object[])fixedPartitions)) {
            ManagedList fixedPartitionAttributesFactoryBeans = new ManagedList(fixedPartitions.length);
            for (Object fixedPartition : fixedPartitions) {
                BeanDefinitionBuilder fixedPartitionAttributesFactoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(FixedPartitionAttributesFactoryBean.class);
                fixedPartitionAttributesFactoryBeanBuilder.addPropertyValue("partitionName", (Object)fixedPartition.name());
                this.setPropertyValueIfNotDefault(fixedPartitionAttributesFactoryBeanBuilder, "primary", fixedPartition.primary(), false);
                this.setPropertyValueIfNotDefault(fixedPartitionAttributesFactoryBeanBuilder, "numBuckets", fixedPartition.numBuckets(), 1);
                fixedPartitionAttributesFactoryBeans.add((Object)fixedPartitionAttributesFactoryBeanBuilder.getBeanDefinition());
            }
            partitionAttributesFactoryBeanBuilder.addPropertyValue("fixedPartitionAttributes", (Object)fixedPartitionAttributesFactoryBeans);
        }
        return partitionAttributesFactoryBeanBuilder;
    }

    protected BeanDefinitionBuilder setReplicateRegionAttributes(AnnotationAttributes regionAnnotationAttributes, BeanDefinitionBuilder regionFactoryBeanBuilder) {
        if (regionAnnotationAttributes.containsKey((Object)"scope")) {
            this.setPropertyValueIfNotDefault(regionFactoryBeanBuilder, "scope", ((ScopeType)regionAnnotationAttributes.getEnum("scope")).getScope(), ScopeType.DISTRIBUTED_NO_ACK);
        }
        return regionFactoryBeanBuilder;
    }

    private <T> BeanDefinitionBuilder setPropertyReferenceIfSet(BeanDefinitionBuilder beanDefinitionBuilder, String propertyName, String beanName) {
        return StringUtils.hasText((String)beanName) ? beanDefinitionBuilder.addPropertyReference(propertyName, beanName) : beanDefinitionBuilder;
    }

    private <T> BeanDefinitionBuilder setPropertyValueIfNotDefault(BeanDefinitionBuilder beanDefinitionBuilder, String propertyName, T value, T defaultValue) {
        return value != null && !value.equals(defaultValue) ? beanDefinitionBuilder.addPropertyValue(propertyName, value) : beanDefinitionBuilder;
    }

    protected GemfirePersistentEntity<?> postProcess(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry, GemfirePersistentEntity<?> persistentEntity) {
        return persistentEntity;
    }

    static {
        regionAnnotationToRegionFactoryBeanClass.put(ClientRegion.class, ClientRegionFactoryBean.class);
        regionAnnotationToRegionFactoryBeanClass.put(LocalRegion.class, LocalRegionFactoryBean.class);
        regionAnnotationToRegionFactoryBeanClass.put(PartitionRegion.class, PartitionedRegionFactoryBean.class);
        regionAnnotationToRegionFactoryBeanClass.put(ReplicateRegion.class, ReplicatedRegionFactoryBean.class);
        regionAnnotationToRegionFactoryBeanClass.put(Region.class, DEFAULT_REGION_FACTORY_BEAN_CLASS);
    }
}

