/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.snapshot;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.snapshot.CacheSnapshotService;
import com.gemstone.gemfire.cache.snapshot.RegionSnapshotService;
import com.gemstone.gemfire.cache.snapshot.SnapshotFilter;
import com.gemstone.gemfire.cache.snapshot.SnapshotOptions;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationListener;
import org.springframework.data.gemfire.snapshot.ExportSnapshotException;
import org.springframework.data.gemfire.snapshot.ImportSnapshotException;
import org.springframework.data.gemfire.snapshot.event.ExportSnapshotApplicationEvent;
import org.springframework.data.gemfire.snapshot.event.SnapshotApplicationEvent;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SnapshotServiceFactoryBean<K, V>
implements FactoryBean<SnapshotServiceAdapter<K, V>>,
InitializingBean,
DisposableBean,
ApplicationListener<SnapshotApplicationEvent<K, V>> {
    protected static final SnapshotMetadata[] EMPTY_ARRAY = new SnapshotMetadata[0];
    private Boolean suppressImportOnInit;
    private Cache cache;
    private Region<K, V> region;
    private SnapshotMetadata<K, V>[] exports;
    private SnapshotMetadata<K, V>[] imports;
    private SnapshotServiceAdapter<K, V> snapshotServiceAdapter;

    static <K, V> SnapshotMetadata<K, V>[] nullSafeArray(SnapshotMetadata<K, V>[] configurations) {
        return configurations != null ? configurations : EMPTY_ARRAY;
    }

    static boolean nullSafeIsDirectory(File file) {
        return file != null && file.isDirectory();
    }

    static boolean nullSafeIsFile(File file) {
        return file != null && file.isFile();
    }

    public void setCache(Cache cache) {
        Assert.notNull((Object)cache, (String)"The GemFire Cache must not be null");
        this.cache = cache;
    }

    protected Cache getCache() {
        Assert.state((this.cache != null ? 1 : 0) != 0, (String)"The GemFire Cache was not properly initialized");
        return this.cache;
    }

    public void setExports(SnapshotMetadata<K, V>[] exports) {
        this.exports = exports;
    }

    protected SnapshotMetadata<K, V>[] getExports() {
        return SnapshotServiceFactoryBean.nullSafeArray(this.exports);
    }

    public void setImports(SnapshotMetadata<K, V>[] imports) {
        this.imports = imports;
    }

    protected SnapshotMetadata<K, V>[] getImports() {
        return SnapshotServiceFactoryBean.nullSafeArray(this.imports);
    }

    public void setRegion(Region<K, V> region) {
        this.region = region;
    }

    protected Region<K, V> getRegion() {
        return this.region;
    }

    public void setSuppressImportOnInit(Boolean suppressImportOnInit) {
        this.suppressImportOnInit = suppressImportOnInit;
    }

    protected boolean getSuppressImportOnInit() {
        return Boolean.TRUE.equals(this.suppressImportOnInit);
    }

    public SnapshotServiceAdapter<K, V> getObject() throws Exception {
        return this.snapshotServiceAdapter;
    }

    public Class<?> getObjectType() {
        return this.snapshotServiceAdapter != null ? this.snapshotServiceAdapter.getClass() : SnapshotServiceAdapter.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        this.snapshotServiceAdapter = this.create();
        if (!this.getSuppressImportOnInit()) {
            this.snapshotServiceAdapter.doImport(this.getImports());
        }
    }

    protected SnapshotServiceAdapter create() {
        Region<K, V> region = this.getRegion();
        return region != null ? this.wrap(region.getSnapshotService()) : this.wrap(this.getCache().getSnapshotService());
    }

    protected SnapshotServiceAdapter<Object, Object> wrap(CacheSnapshotService cacheSnapshotService) {
        return new CacheSnapshotServiceAdapter(cacheSnapshotService);
    }

    protected SnapshotServiceAdapter<K, V> wrap(RegionSnapshotService<K, V> regionSnapshotService) {
        return new RegionSnapshotServiceAdapter<K, V>(regionSnapshotService);
    }

    public void destroy() throws Exception {
        this.getObject().doExport(this.getExports());
    }

    public void onApplicationEvent(SnapshotApplicationEvent<K, V> event) {
        try {
            if (this.isMatch(event)) {
                if (event instanceof ExportSnapshotApplicationEvent) {
                    this.getObject().doExport(this.resolveSnapshotMetadata(event));
                } else {
                    this.getObject().doImport(this.resolveSnapshotMetadata(event));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean isMatch(SnapshotApplicationEvent event) {
        return event.isCacheSnapshotEvent() || event.matches(this.getRegion());
    }

    protected SnapshotMetadata<K, V>[] resolveSnapshotMetadata(SnapshotApplicationEvent<K, V> event) {
        Object[] eventSnapshotMetadata = event.getSnapshotMetadata();
        return !ObjectUtils.isEmpty((Object[])eventSnapshotMetadata) ? eventSnapshotMetadata : (event instanceof ExportSnapshotApplicationEvent ? this.getExports() : this.getImports());
    }

    protected static final class ArchiveFileFilter
    implements FileFilter {
        protected static final ArchiveFileFilter INSTANCE = new ArchiveFileFilter();
        protected static final List<String> ACCEPTED_FILE_EXTENSIONS = Arrays.asList("jar", "zip");
        protected static final String FILE_EXTENSION_DOT_SEPARATOR = ".";

        protected ArchiveFileFilter() {
        }

        protected boolean isJarFile(File file) {
            return "jar".equalsIgnoreCase(this.getFileExtension(file));
        }

        protected String getFileExtension(File file) {
            String fileExtension = "";
            if (SnapshotServiceFactoryBean.nullSafeIsFile(file)) {
                String pathname = file.getAbsolutePath();
                int fileExtensionIndex = pathname.lastIndexOf(FILE_EXTENSION_DOT_SEPARATOR);
                fileExtension = fileExtensionIndex > -1 ? pathname.substring(fileExtensionIndex + 1) : "";
            }
            return fileExtension.toLowerCase();
        }

        @Override
        public boolean accept(File pathname) {
            return ACCEPTED_FILE_EXTENSIONS.contains(this.getFileExtension(pathname));
        }
    }

    public static class SnapshotMetadata<K, V> {
        private final File location;
        private final SnapshotFilter<K, V> filter;
        private final SnapshotOptions.SnapshotFormat format;

        public SnapshotMetadata(File location, SnapshotOptions.SnapshotFormat format) {
            this(location, null, format);
        }

        public SnapshotMetadata(File location, SnapshotFilter<K, V> filter, SnapshotOptions.SnapshotFormat format) {
            Assert.notNull((Object)location, (String)"Location must not be null");
            this.location = location;
            this.filter = filter;
            this.format = format;
        }

        public boolean isDirectory() {
            return SnapshotServiceFactoryBean.nullSafeIsDirectory(this.getLocation());
        }

        public boolean isFile() {
            return SnapshotServiceFactoryBean.nullSafeIsFile(this.getLocation());
        }

        public File getLocation() {
            return this.location;
        }

        public boolean isFilterPresent() {
            return this.getFilter() != null;
        }

        public SnapshotFilter<K, V> getFilter() {
            return this.filter;
        }

        public SnapshotOptions.SnapshotFormat getFormat() {
            return this.format != null ? this.format : SnapshotOptions.SnapshotFormat.GEMFIRE;
        }

        public String toString() {
            return String.format("{ @type = %1$s, location = %2$s, filter = %2$s, format = %4$s }", this.getClass().getName(), this.getLocation().getAbsolutePath(), this.getFilter(), this.getFormat());
        }
    }

    protected static class RegionSnapshotServiceAdapter<K, V>
    extends SnapshotServiceAdapterSupport<K, V> {
        private final RegionSnapshotService<K, V> snapshotService;

        public RegionSnapshotServiceAdapter(RegionSnapshotService<K, V> snapshotService) {
            Assert.notNull(snapshotService, (String)"The backing RegionSnapshotService must not be null");
            this.snapshotService = snapshotService;
        }

        protected RegionSnapshotService<K, V> getSnapshotService() {
            return this.snapshotService;
        }

        @Override
        public SnapshotOptions<K, V> createOptions() {
            return this.getSnapshotService().createOptions();
        }

        @Override
        protected File[] handleLocation(SnapshotMetadata<K, V> configuration) {
            return new File[]{configuration.getLocation()};
        }

        @Override
        public void load(File snapshot, SnapshotOptions.SnapshotFormat format) {
            try {
                this.getSnapshotService().load(snapshot, format);
            }
            catch (Throwable t) {
                throw new ImportSnapshotException(String.format("Failed to load snapshot from file (%1$s) in format (%2$s)", snapshot, format), t);
            }
        }

        @Override
        public void load(SnapshotOptions.SnapshotFormat format, SnapshotOptions<K, V> options, File ... snapshots) {
            try {
                for (File snapshot : snapshots) {
                    this.getSnapshotService().load(snapshot, format, options);
                }
            }
            catch (Throwable t) {
                throw new ImportSnapshotException(String.format("Failed to load snapshots (%1$s) in format (%2$s) using options (%3$s)", Arrays.toString(snapshots), format, options), t);
            }
        }

        @Override
        public void save(File snapshot, SnapshotOptions.SnapshotFormat format) {
            try {
                this.getSnapshotService().save(snapshot, format);
            }
            catch (Throwable t) {
                throw new ExportSnapshotException(String.format("Failed to save snapshot to file (%1$s) in format (%2$s)", snapshot, format), t);
            }
        }

        @Override
        public void save(File snapshot, SnapshotOptions.SnapshotFormat format, SnapshotOptions<K, V> options) {
            try {
                this.getSnapshotService().save(snapshot, format, options);
            }
            catch (Throwable t) {
                throw new ExportSnapshotException(String.format("Failed to save snapshot to file (%1$s) in format (%2$s) using options (%3$s)", snapshot, format, options), t);
            }
        }
    }

    protected static class CacheSnapshotServiceAdapter
    extends SnapshotServiceAdapterSupport<Object, Object> {
        private final CacheSnapshotService snapshotService;

        public CacheSnapshotServiceAdapter(CacheSnapshotService snapshotService) {
            Assert.notNull((Object)snapshotService, (String)"The backing CacheSnapshotService must not be null");
            this.snapshotService = snapshotService;
        }

        protected CacheSnapshotService getSnapshotService() {
            return this.snapshotService;
        }

        @Override
        public SnapshotOptions<Object, Object> createOptions() {
            return this.getSnapshotService().createOptions();
        }

        @Override
        protected File[] handleLocation(SnapshotMetadata<Object, Object> configuration) {
            return configuration.isFile() ? this.handleFileLocation(configuration.getLocation()) : this.handleDirectoryLocation(configuration.getLocation());
        }

        @Override
        public void load(File directory, SnapshotOptions.SnapshotFormat format) {
            try {
                this.getSnapshotService().load(directory, format);
            }
            catch (Throwable t) {
                throw new ImportSnapshotException(String.format("Failed to load snapshots from directory (%1$s) in format (%2$s)", directory, format), t);
            }
        }

        @Override
        public void load(SnapshotOptions.SnapshotFormat format, SnapshotOptions<Object, Object> options, File ... snapshots) {
            try {
                this.getSnapshotService().load(snapshots, format, options);
            }
            catch (Throwable t) {
                throw new ImportSnapshotException(String.format("Failed to load snapshots (%1$s) in format (%2$s) using options (%3$s)", Arrays.toString(snapshots), format, options), t);
            }
        }

        @Override
        public void save(File directory, SnapshotOptions.SnapshotFormat format) {
            try {
                this.getSnapshotService().save(directory, format);
            }
            catch (Throwable t) {
                throw new ExportSnapshotException(String.format("Failed to save snapshots to directory (%1$s) in format (%2$s)", directory, format), t);
            }
        }

        @Override
        public void save(File directory, SnapshotOptions.SnapshotFormat format, SnapshotOptions<Object, Object> options) {
            try {
                this.getSnapshotService().save(directory, format, options);
            }
            catch (Throwable t) {
                throw new ExportSnapshotException(String.format("Failed to save snapshots to directory (%1$s) in format (%2$s) using options (%3$s)", directory, format, options), t);
            }
        }
    }

    protected static abstract class SnapshotServiceAdapterSupport<K, V>
    implements SnapshotServiceAdapter<K, V> {
        protected static final File TEMPORARY_DIRECTORY = new File(System.getProperty("java.io.tmpdir"));
        protected final Log log = this.createLog();

        protected SnapshotServiceAdapterSupport() {
        }

        Log createLog() {
            return LogFactory.getLog(this.getClass());
        }

        @Override
        public SnapshotOptions<K, V> createOptions() {
            throw new UnsupportedOperationException("not implemented");
        }

        protected SnapshotOptions<K, V> createOptions(SnapshotFilter<K, V> filter) {
            return this.createOptions().setFilter(filter);
        }

        @Override
        public void doExport(SnapshotMetadata<K, V> ... configurations) {
            for (SnapshotMetadata<K, V> configuration : SnapshotServiceFactoryBean.nullSafeArray(configurations)) {
                this.save(configuration.getLocation(), configuration.getFormat(), this.createOptions(configuration.getFilter()));
            }
        }

        @Override
        public void doImport(SnapshotMetadata<K, V> ... configurations) {
            for (SnapshotMetadata<K, V> configuration : SnapshotServiceFactoryBean.nullSafeArray(configurations)) {
                this.load(configuration.getFormat(), this.createOptions(configuration.getFilter()), this.handleLocation(configuration));
            }
        }

        protected abstract File[] handleLocation(SnapshotMetadata<K, V> var1);

        protected File[] handleDirectoryLocation(File directory) {
            return directory.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return SnapshotServiceFactoryBean.nullSafeIsFile(pathname);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected File[] handleFileLocation(File file) {
            if (ArchiveFileFilter.INSTANCE.accept(file)) {
                try {
                    File extractedArchiveDirectory = new File(TEMPORARY_DIRECTORY, file.getName().replaceAll("\\.", "-"));
                    Assert.state((extractedArchiveDirectory.isDirectory() || extractedArchiveDirectory.mkdirs() ? 1 : 0) != 0, (String)String.format("Failed create directory (%1$s) in which to extract archive (%2$s)", extractedArchiveDirectory, file));
                    ZipFile zipFile = ArchiveFileFilter.INSTANCE.isJarFile(file) ? new JarFile(file, false, 1) : new ZipFile(file, 1);
                    for (ZipEntry zipEntry : CollectionUtils.iterable(zipFile.entries())) {
                        if (zipEntry.isDirectory()) continue;
                        DataInputStream entryInputStream = new DataInputStream(zipFile.getInputStream(zipEntry));
                        DataOutputStream entryOutputStream = new DataOutputStream(new FileOutputStream(new File(extractedArchiveDirectory, this.toSimpleFilename(zipEntry.getName()))));
                        try {
                            FileCopyUtils.copy((InputStream)entryInputStream, (OutputStream)entryOutputStream);
                        }
                        finally {
                            this.exceptionSuppressingClose(entryInputStream);
                            this.exceptionSuppressingClose(entryOutputStream);
                        }
                    }
                    return this.handleDirectoryLocation(extractedArchiveDirectory);
                }
                catch (Throwable t) {
                    throw new ImportSnapshotException(String.format("Failed to extract archive (%1$s) to import", file), t);
                }
            }
            return new File[]{file};
        }

        protected boolean exceptionSuppressingClose(Closeable closeable) {
            try {
                closeable.close();
                return true;
            }
            catch (IOException ignore) {
                this.logDebug(ignore, "Failed to close (%1$s)", closeable);
                return false;
            }
        }

        protected void logDebug(Throwable t, String message, Object ... arguments) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format(message, arguments), t);
            }
        }

        @Override
        public void load(File directory, SnapshotOptions.SnapshotFormat format) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void load(SnapshotOptions.SnapshotFormat format, SnapshotOptions<K, V> options, File ... snapshots) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void save(File location, SnapshotOptions.SnapshotFormat format) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void save(File location, SnapshotOptions.SnapshotFormat format, SnapshotOptions<K, V> options) {
            throw new UnsupportedOperationException("not implemented");
        }

        protected String toSimpleFilename(String pathname) {
            int pathSeparatorIndex = String.valueOf(pathname).lastIndexOf(File.separator);
            pathname = pathSeparatorIndex > -1 ? pathname.substring(pathSeparatorIndex + 1) : pathname;
            return StringUtils.trimWhitespace((String)pathname);
        }
    }

    public static interface SnapshotServiceAdapter<K, V> {
        public SnapshotOptions<K, V> createOptions();

        public void doExport(SnapshotMetadata<K, V> ... var1);

        public void doImport(SnapshotMetadata<K, V> ... var1);

        public void load(File var1, SnapshotOptions.SnapshotFormat var2);

        public void load(SnapshotOptions.SnapshotFormat var1, SnapshotOptions<K, V> var2, File ... var3);

        public void save(File var1, SnapshotOptions.SnapshotFormat var2);

        public void save(File var1, SnapshotOptions.SnapshotFormat var2, SnapshotOptions<K, V> var3);
    }
}

