/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import org.springframework.data.gemfire.repository.query.QueryPostProcessor;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.util.Assert;

public abstract class AbstractQueryPostProcessor<T extends Repository, QUERY>
implements QueryPostProcessor<T, QUERY> {
    protected static final Object[] EMPTY_ARRAY = new Object[0];

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public QUERY postProcess(QueryMethod queryMethod, QUERY query) {
        return this.postProcess(queryMethod, query, EMPTY_ARRAY);
    }

    @Override
    public QueryPostProcessor<?, QUERY> processBefore(QueryPostProcessor<?, QUERY> queryPostProcessor) {
        return ComposableQueryPostProcessor.compose(this, queryPostProcessor);
    }

    @Override
    public QueryPostProcessor<?, QUERY> processAfter(QueryPostProcessor<?, QUERY> queryPostProcessor) {
        return ComposableQueryPostProcessor.compose(queryPostProcessor, this);
    }

    protected static class ComposableQueryPostProcessor<T extends Repository, QUERY>
    extends AbstractQueryPostProcessor<T, QUERY> {
        private final QueryPostProcessor<?, QUERY> first;
        private final QueryPostProcessor<?, QUERY> second;

        protected static <QUERY> QueryPostProcessor<?, QUERY> compose(QueryPostProcessor<?, QUERY> first, QueryPostProcessor<?, QUERY> second) {
            return first == null ? second : (second == null ? first : new ComposableQueryPostProcessor(first, second));
        }

        protected ComposableQueryPostProcessor(QueryPostProcessor<?, QUERY> left, QueryPostProcessor<?, QUERY> second) {
            Assert.notNull(left, (String)"The first QueryPostProcessor operand must not be null");
            Assert.notNull(second, (String)"The second QueryPostProcessor operand must not be null");
            this.first = left;
            this.second = second;
        }

        protected QueryPostProcessor<?, QUERY> getFirst() {
            return this.first;
        }

        protected QueryPostProcessor<?, QUERY> getSecond() {
            return this.second;
        }

        @Override
        public QUERY postProcess(QueryMethod queryMethod, QUERY query, Object ... arguments) {
            return this.getSecond().postProcess(queryMethod, this.getFirst().postProcess(queryMethod, query, arguments), arguments);
        }
    }
}

