/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Map;
import java.util.Properties;
import org.springframework.data.gemfire.config.annotation.EnableStatistics;
import org.springframework.data.gemfire.config.annotation.support.EmbeddedServiceConfigurationSupport;
import org.springframework.data.gemfire.util.PropertiesBuilder;

public class StatisticsConfiguration
extends EmbeddedServiceConfigurationSupport {
    public static final boolean DEFAULT_ENABLE_TIME_STATISTICS = false;
    public static final int DEFAULT_ARCHIVE_DISK_SPACE_LIMIT = 0;
    public static final int DEFAULT_ARCHIVE_FILE_SIZE_LIMIT = 0;
    public static final int DEFAULT_STATISTIC_SAMPLE_RATE = 1000;

    @Override
    protected Class getAnnotationType() {
        return EnableStatistics.class;
    }

    @Override
    protected Properties toGemFireProperties(Map<String, Object> annotationAttributes) {
        PropertiesBuilder gemfireProperties = new PropertiesBuilder();
        gemfireProperties.setProperty("statistic-sampling-enabled", true);
        gemfireProperties.setPropertyIfNotDefault("archive-disk-space-limit", annotationAttributes.get("archiveDiskSpaceLimit"), 0);
        gemfireProperties.setPropertyIfNotDefault("archive-file-size-limit", annotationAttributes.get("archiveFileSizeLimit"), 0);
        gemfireProperties.setProperty("enable-time-statistics", Boolean.TRUE.equals(annotationAttributes.get("enableTimeStatistics")));
        gemfireProperties.setProperty("statistic-archive-file", annotationAttributes.get("archiveFile"));
        gemfireProperties.setPropertyIfNotDefault("statistic-sample-rate", annotationAttributes.get("sampleRate"), 1000);
        return gemfireProperties.build();
    }
}

