/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientRegionFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.client.Pool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.Resource;
import org.springframework.data.gemfire.DataPolicyConverter;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.RegionLookupFactoryBean;
import org.springframework.data.gemfire.client.Interest;
import org.springframework.data.gemfire.client.RegexInterest;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ClientRegionFactoryBean<K, V>
extends RegionLookupFactoryBean<K, V>
implements BeanFactoryAware,
DisposableBean {
    private static final Log log = LogFactory.getLog(ClientRegionFactoryBean.class);
    private boolean close = false;
    private boolean destroy = false;
    private BeanFactory beanFactory;
    private Boolean persistent;
    private CacheListener<K, V>[] cacheListeners;
    private CacheLoader<K, V> cacheLoader;
    private CacheWriter<K, V> cacheWriter;
    private Class<K> keyConstraint;
    private Class<V> valueConstraint;
    private ClientRegionShortcut shortcut = null;
    private DataPolicy dataPolicy;
    private EvictionAttributes evictionAttributes;
    private Interest<K>[] interests;
    private RegionAttributes<K, V> attributes;
    private Resource snapshot;
    private String diskStoreName;
    private String poolName;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.postProcess(this.getRegion());
    }

    @Override
    protected Region<K, V> lookupRegion(GemFireCache cache, String regionName) throws Exception {
        Assert.isTrue((boolean)GemfireUtils.isClient(cache), (String)"A ClientCache is required to create a client Region");
        ClientRegionFactory clientRegionFactory = ((ClientCache)cache).createClientRegionFactory(this.resolveClientRegionShortcut());
        this.setAttributes(clientRegionFactory);
        this.addCacheListeners(clientRegionFactory);
        this.setDiskStoreName(clientRegionFactory);
        this.setEvictionAttributes(clientRegionFactory);
        this.setPoolName(clientRegionFactory);
        if (this.keyConstraint != null) {
            clientRegionFactory.setKeyConstraint(this.keyConstraint);
        }
        if (this.valueConstraint != null) {
            clientRegionFactory.setValueConstraint(this.valueConstraint);
        }
        return this.logCreateRegionEvent(this.create(clientRegionFactory, regionName));
    }

    private Region<K, V> create(ClientRegionFactory<K, V> clientRegionFactory, String regionName) {
        return this.getParent() != null ? clientRegionFactory.createSubregion(this.getParent(), regionName) : clientRegionFactory.create(regionName);
    }

    private Region<K, V> logCreateRegionEvent(Region<K, V> region) {
        if (log.isInfoEnabled()) {
            if (this.getParent() != null) {
                log.info((Object)String.format("Created new client cache Sub-Region [%1$s] under parent Region [%2$s].", region.getName(), this.getParent().getName()));
            } else {
                log.info((Object)String.format("Created new client cache Region [%s].", region.getName()));
            }
        }
        return region;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ClientRegionShortcut resolveClientRegionShortcut() {
        ClientRegionShortcut resolvedShortcut = this.shortcut;
        if (resolvedShortcut == null) {
            if (this.dataPolicy != null) {
                this.assertDataPolicyAndPersistentAttributeAreCompatible(this.dataPolicy);
                if (DataPolicy.EMPTY.equals(this.dataPolicy)) {
                    resolvedShortcut = ClientRegionShortcut.PROXY;
                } else if (DataPolicy.NORMAL.equals(this.dataPolicy)) {
                    resolvedShortcut = ClientRegionShortcut.CACHING_PROXY;
                } else {
                    if (!DataPolicy.PERSISTENT_REPLICATE.equals(this.dataPolicy)) throw new IllegalArgumentException(String.format("Data Policy '%s' is invalid for Client Regions", this.dataPolicy));
                    resolvedShortcut = ClientRegionShortcut.LOCAL_PERSISTENT;
                }
            } else {
                resolvedShortcut = this.isPersistent() ? ClientRegionShortcut.LOCAL_PERSISTENT : ClientRegionShortcut.LOCAL;
            }
        }
        this.assertClientRegionShortcutAndPersistentAttributeAreCompatible(resolvedShortcut);
        return resolvedShortcut;
    }

    private void assertClientRegionShortcutAndPersistentAttributeAreCompatible(ClientRegionShortcut resolvedShortcut) {
        boolean persistentNotSpecified;
        boolean bl = persistentNotSpecified = this.persistent == null;
        if (ClientRegionShortcut.LOCAL_PERSISTENT.equals((Object)resolvedShortcut) || ClientRegionShortcut.LOCAL_PERSISTENT_OVERFLOW.equals((Object)resolvedShortcut)) {
            Assert.isTrue((persistentNotSpecified || this.isPersistent() ? 1 : 0) != 0, (String)String.format("Client Region Shortcut '%s' is invalid when persistent is false", resolvedShortcut));
        } else {
            Assert.isTrue((persistentNotSpecified || this.isNotPersistent() ? 1 : 0) != 0, (String)String.format("Client Region Shortcut '%s' is invalid when persistent is true", resolvedShortcut));
        }
    }

    private void assertDataPolicyAndPersistentAttributeAreCompatible(DataPolicy resolvedDataPolicy) {
        if (resolvedDataPolicy.withPersistence()) {
            Assert.isTrue((this.isPersistentUnspecified() || this.isPersistent() ? 1 : 0) != 0, (String)String.format("Data Policy '%s' is invalid when persistent is false", resolvedDataPolicy));
        } else {
            Assert.isTrue((this.isPersistentUnspecified() || this.isNotPersistent() ? 1 : 0) != 0, (String)String.format("Data Policy '%s' is invalid when persistent is true", resolvedDataPolicy));
        }
    }

    private ClientRegionFactory<K, V> setAttributes(ClientRegionFactory<K, V> clientRegionFactory) {
        RegionAttributes<K, V> localAttributes = this.attributes;
        if (localAttributes != null) {
            clientRegionFactory.setCloningEnabled(localAttributes.getCloningEnabled());
            clientRegionFactory.setCompressor(localAttributes.getCompressor());
            clientRegionFactory.setConcurrencyChecksEnabled(localAttributes.getConcurrencyChecksEnabled());
            clientRegionFactory.setConcurrencyLevel(localAttributes.getConcurrencyLevel());
            clientRegionFactory.setCustomEntryIdleTimeout(localAttributes.getCustomEntryIdleTimeout());
            clientRegionFactory.setCustomEntryTimeToLive(localAttributes.getCustomEntryTimeToLive());
            clientRegionFactory.setDiskStoreName(localAttributes.getDiskStoreName());
            clientRegionFactory.setDiskSynchronous(localAttributes.isDiskSynchronous());
            clientRegionFactory.setEntryIdleTimeout(localAttributes.getEntryIdleTimeout());
            clientRegionFactory.setEntryTimeToLive(localAttributes.getEntryTimeToLive());
            clientRegionFactory.setEvictionAttributes(localAttributes.getEvictionAttributes());
            clientRegionFactory.setInitialCapacity(localAttributes.getInitialCapacity());
            clientRegionFactory.setKeyConstraint(localAttributes.getKeyConstraint());
            clientRegionFactory.setLoadFactor(localAttributes.getLoadFactor());
            clientRegionFactory.setPoolName(localAttributes.getPoolName());
            clientRegionFactory.setRegionIdleTimeout(localAttributes.getRegionIdleTimeout());
            clientRegionFactory.setRegionTimeToLive(localAttributes.getRegionTimeToLive());
            clientRegionFactory.setStatisticsEnabled(localAttributes.getStatisticsEnabled());
            clientRegionFactory.setValueConstraint(localAttributes.getValueConstraint());
        }
        return clientRegionFactory;
    }

    private ClientRegionFactory<K, V> addCacheListeners(ClientRegionFactory<K, V> clientRegionFactory) {
        for (CacheListener<K, V> cacheListener : this.attributesCacheListeners()) {
            clientRegionFactory.addCacheListener(cacheListener);
        }
        for (CacheListener<K, V> cacheListener : ArrayUtils.nullSafeArray(this.cacheListeners, CacheListener.class)) {
            clientRegionFactory.addCacheListener(cacheListener);
        }
        return clientRegionFactory;
    }

    private <K, V> CacheListener<K, V>[] attributesCacheListeners() {
        return this.attributes != null ? ArrayUtils.nullSafeArray(this.attributes.getCacheListeners(), CacheListener.class) : new CacheListener[]{};
    }

    private ClientRegionFactory<K, V> setDiskStoreName(ClientRegionFactory<K, V> clientRegionFactory) {
        if (StringUtils.hasText((String)this.diskStoreName)) {
            clientRegionFactory.setDiskStoreName(this.diskStoreName);
        }
        return clientRegionFactory;
    }

    private ClientRegionFactory<K, V> setEvictionAttributes(ClientRegionFactory<K, V> clientRegionFactory) {
        if (this.evictionAttributes != null) {
            clientRegionFactory.setEvictionAttributes(this.evictionAttributes);
        }
        return clientRegionFactory;
    }

    private ClientRegionFactory<K, V> setPoolName(ClientRegionFactory<K, V> clientRegionFactory) {
        String poolName = this.resolvePoolName();
        if (StringUtils.hasText((String)poolName)) {
            clientRegionFactory.setPoolName(this.eagerlyInitializePool(poolName));
        }
        return clientRegionFactory;
    }

    private String resolvePoolName() {
        String poolName = this.poolName;
        if (!StringUtils.hasText((String)poolName)) {
            String defaultPoolName = "gemfirePool";
            poolName = this.beanFactory.containsBean(defaultPoolName) ? defaultPoolName : poolName;
        }
        return poolName;
    }

    private String eagerlyInitializePool(String poolName) {
        try {
            if (this.beanFactory.isTypeMatch(poolName, Pool.class)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Found bean definition for Pool [%1$s]; Eagerly initializing...", poolName));
                }
                this.beanFactory.getBean(poolName, Pool.class);
            }
        }
        catch (BeansException ignore) {
            log.warn((Object)ignore.getMessage());
        }
        return poolName;
    }

    protected void postProcess(Region<K, V> region) throws Exception {
        this.loadSnapshot(region);
        this.registerInterests(region);
        this.setCacheLoader(region);
        this.setCacheWriter(region);
    }

    private Region<K, V> loadSnapshot(Region<K, V> region) throws Exception {
        if (this.snapshot != null) {
            region.loadSnapshot(this.snapshot.getInputStream());
        }
        return region;
    }

    private Region<K, V> registerInterests(Region<K, V> region) {
        if (!ObjectUtils.isEmpty((Object[])this.interests)) {
            for (Interest<K> interest : this.interests) {
                if (interest instanceof RegexInterest) {
                    region.registerInterestRegex((String)interest.getKey(), interest.getPolicy(), interest.isDurable(), interest.isReceiveValues());
                    continue;
                }
                region.registerInterest(interest.getKey(), interest.getPolicy(), interest.isDurable(), interest.isReceiveValues());
            }
        }
        return region;
    }

    private Region<K, V> setCacheLoader(Region<K, V> region) {
        if (this.cacheLoader != null) {
            region.getAttributesMutator().setCacheLoader(this.cacheLoader);
        }
        return region;
    }

    private Region<K, V> setCacheWriter(Region<K, V> region) {
        if (this.cacheWriter != null) {
            region.getAttributesMutator().setCacheWriter(this.cacheWriter);
        }
        return region;
    }

    public void destroy() throws Exception {
        Region region = this.getObject();
        if (region != null) {
            if (this.close && !region.getRegionService().isClosed()) {
                try {
                    region.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.destroy) {
                region.destroyRegion();
            }
        }
    }

    public void setAttributes(RegionAttributes<K, V> attributes) {
        this.attributes = attributes;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    final boolean isClose() {
        return this.close;
    }

    public void setClose(boolean close) {
        this.close = close;
        this.destroy = this.destroy && !close;
    }

    public void setCacheListeners(CacheListener<K, V>[] cacheListeners) {
        this.cacheListeners = cacheListeners;
    }

    public void setCacheLoader(CacheLoader<K, V> cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    public void setCacheWriter(CacheWriter<K, V> cacheWriter) {
        this.cacheWriter = cacheWriter;
    }

    public void setDataPolicy(DataPolicy dataPolicy) {
        this.dataPolicy = dataPolicy;
    }

    @Deprecated
    public void setDataPolicyName(String dataPolicyName) {
        DataPolicy resolvedDataPolicy = new DataPolicyConverter().convert(dataPolicyName);
        Assert.notNull((Object)resolvedDataPolicy, (String)String.format("Data Policy '%1$s' is invalid.", dataPolicyName));
        this.setDataPolicy(resolvedDataPolicy);
    }

    final boolean isDestroy() {
        return this.destroy;
    }

    public void setDestroy(boolean destroy) {
        this.destroy = destroy;
        this.close = this.close && !destroy;
    }

    public void setDiskStoreName(String diskStoreName) {
        this.diskStoreName = diskStoreName;
    }

    public void setEvictionAttributes(EvictionAttributes evictionAttributes) {
        this.evictionAttributes = evictionAttributes;
    }

    public void setInterests(Interest<K>[] interests) {
        this.interests = interests;
    }

    Interest<K>[] getInterests() {
        return this.interests;
    }

    public void setKeyConstraint(Class<K> keyConstraint) {
        this.keyConstraint = keyConstraint;
    }

    protected boolean isPersistentUnspecified() {
        return this.persistent == null;
    }

    protected boolean isPersistent() {
        return Boolean.TRUE.equals(this.persistent);
    }

    protected boolean isNotPersistent() {
        return Boolean.FALSE.equals(this.persistent);
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setPool(Pool pool) {
        Assert.notNull((Object)pool, (String)"Pool cannot be null");
        this.setPoolName(pool.getName());
    }

    public void setPoolName(String poolName) {
        Assert.hasText((String)poolName, (String)"Pool name is required");
        this.poolName = poolName;
    }

    public void setShortcut(ClientRegionShortcut shortcut) {
        this.shortcut = shortcut;
    }

    public void setSnapshot(Resource snapshot) {
        this.snapshot = snapshot;
    }

    public void setValueConstraint(Class<V> valueConstraint) {
        this.valueConstraint = valueConstraint;
    }
}

