/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.envers.repository.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.hibernate.envers.AuditReader;
import org.hibernate.envers.AuditReaderFactory;
import org.hibernate.envers.DefaultRevisionEntity;
import org.hibernate.envers.RevisionNumber;
import org.hibernate.envers.RevisionTimestamp;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.envers.repository.support.DefaultRevisionMetadata;
import org.springframework.data.history.AnnotationRevisionMetadata;
import org.springframework.data.history.Revision;
import org.springframework.data.history.RevisionMetadata;
import org.springframework.data.history.RevisionSort;
import org.springframework.data.history.Revisions;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.history.RevisionRepository;
import org.springframework.data.repository.history.support.RevisionEntityInformation;
import org.springframework.data.util.Pair;
import org.springframework.data.util.StreamUtils;
import org.springframework.util.Assert;

public class EnversRevisionRepositoryImpl<T, ID, N extends Number>
extends SimpleJpaRepository<T, ID>
implements RevisionRepository<T, ID, N> {
    private final EntityInformation<T, ?> entityInformation;
    private final RevisionEntityInformation revisionEntityInformation;
    private final EntityManager entityManager;

    public EnversRevisionRepositoryImpl(JpaEntityInformation<T, ?> entityInformation, RevisionEntityInformation revisionEntityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        Assert.notNull((Object)revisionEntityInformation, (String)"RevisionEntityInformation must not be null!");
        this.entityInformation = entityInformation;
        this.revisionEntityInformation = revisionEntityInformation;
        this.entityManager = entityManager;
    }

    public Optional<Revision<N, T>> findLastChangeRevision(ID id) {
        Class type = this.entityInformation.getJavaType();
        AuditReader reader = AuditReaderFactory.get((EntityManager)this.entityManager);
        List revisions = reader.getRevisions(type, id);
        if (revisions.isEmpty()) {
            return Optional.empty();
        }
        Number latestRevision = (Number)revisions.get(revisions.size() - 1);
        Class revisionEntityClass = this.revisionEntityInformation.getRevisionEntityClass();
        Object revisionEntity = reader.findRevision(revisionEntityClass, latestRevision);
        RevisionMetadata<?> metadata = this.getRevisionMetadata(revisionEntity);
        return Optional.of(Revision.of(metadata, (Object)reader.find(type, id, latestRevision)));
    }

    public Optional<Revision<N, T>> findRevision(ID id, N revisionNumber) {
        Assert.notNull(id, (String)"Identifier must not be null!");
        Assert.notNull(revisionNumber, (String)"Revision number must not be null!");
        return this.getEntityForRevision(revisionNumber, id, AuditReaderFactory.get((EntityManager)this.entityManager));
    }

    public Revisions<N, T> findRevisions(ID id) {
        Class type = this.entityInformation.getJavaType();
        AuditReader reader = AuditReaderFactory.get((EntityManager)this.entityManager);
        List revisionNumbers = reader.getRevisions(type, id);
        return revisionNumbers.isEmpty() ? Revisions.none() : this.getEntitiesForRevisions(revisionNumbers, id, reader);
    }

    public Page<Revision<N, T>> findRevisions(ID id, Pageable pageable) {
        Class type = this.entityInformation.getJavaType();
        AuditReader reader = AuditReaderFactory.get((EntityManager)this.entityManager);
        List revisionNumbers = reader.getRevisions(type, id);
        boolean isDescending = RevisionSort.getRevisionDirection((Sort)pageable.getSort()).isDescending();
        if (isDescending) {
            Collections.reverse(revisionNumbers);
        }
        if (pageable.getOffset() > (long)revisionNumbers.size()) {
            return new PageImpl(Collections.emptyList(), pageable, 0L);
        }
        long upperBound = pageable.getOffset() + (long)pageable.getPageSize();
        upperBound = upperBound > (long)revisionNumbers.size() ? (long)revisionNumbers.size() : upperBound;
        List subList = revisionNumbers.subList(EnversRevisionRepositoryImpl.toInt(pageable.getOffset()), EnversRevisionRepositoryImpl.toInt(upperBound));
        Revisions revisions = this.getEntitiesForRevisions(subList, id, reader);
        revisions = isDescending ? revisions.reverse() : revisions;
        return new PageImpl(revisions.getContent(), pageable, (long)revisionNumbers.size());
    }

    private Revisions<N, T> getEntitiesForRevisions(List<N> revisionNumbers, ID id, AuditReader reader) {
        Class type = this.entityInformation.getJavaType();
        HashMap<Number, Object> revisions = new HashMap<Number, Object>(revisionNumbers.size());
        Class revisionEntityClass = this.revisionEntityInformation.getRevisionEntityClass();
        Map revisionEntities = reader.findRevisions(revisionEntityClass, new HashSet<N>(revisionNumbers));
        for (Number number : revisionNumbers) {
            revisions.put(number, reader.find(type, id, number));
        }
        return Revisions.of(this.toRevisions(revisions, revisionEntities));
    }

    private Optional<Revision<N, T>> getEntityForRevision(N revisionNumber, ID id, AuditReader reader) {
        Class type = this.revisionEntityInformation.getRevisionEntityClass();
        Object revision = reader.findRevision(type, revisionNumber);
        Optional<Object> entity = Optional.ofNullable(reader.find(this.entityInformation.getJavaType(), id, revisionNumber));
        return entity.map(it -> Revision.of(this.getRevisionMetadata(revision), (Object)it));
    }

    private List<Revision<N, T>> toRevisions(Map<N, T> source, Map<Number, Object> revisionEntities) {
        return (List)source.entrySet().stream().map(entry -> Pair.of(revisionEntities.get(entry.getKey()), entry.getValue())).map(pair -> Revision.of(this.getRevisionMetadata(pair.getFirst()), (Object)pair.getSecond())).sorted().collect(StreamUtils.toUnmodifiableList());
    }

    private RevisionMetadata<?> getRevisionMetadata(Object object) {
        return object instanceof DefaultRevisionEntity ? new DefaultRevisionMetadata((DefaultRevisionEntity)object) : new AnnotationRevisionMetadata(object, RevisionNumber.class, RevisionTimestamp.class);
    }

    private static int toInt(long value) {
        if (value > Integer.MAX_VALUE) {
            throw new IllegalStateException(String.format("%s can't be mapped to an integer, too large!", value));
        }
        return Long.valueOf(value).intValue();
    }
}

