/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.support;

import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public interface StringObjectMap<M extends StringObjectMap<M>>
extends Map<String, Object> {
    default public M append(String key, Object value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        this.put(key, value);
        return (M)this;
    }

    default public <T> @Nullable T get(Object key, Class<T> type) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(type, (String)"Type must not be null");
        return type.cast(this.get(key));
    }

    default public @Nullable Boolean getBoolean(String key) {
        return this.get(key, Boolean.class);
    }

    default public boolean getBooleanOrDefault(String key, boolean defaultValue) {
        return this.getBooleanOrDefault(key, () -> defaultValue);
    }

    default public boolean getBooleanOrDefault(String key, BooleanSupplier defaultValue) {
        Boolean value = this.getBoolean(key);
        return value == null ? defaultValue.getAsBoolean() : value.booleanValue();
    }

    default public @Nullable Integer getInt(String key) {
        return this.get(key, Integer.class);
    }

    default public int getIntOrDefault(String key, int defaultValue) {
        return this.getIntOrDefault(key, () -> defaultValue);
    }

    default public int getIntOrDefault(String key, IntSupplier defaultValue) {
        Integer value = this.getInt(key);
        return value == null ? defaultValue.getAsInt() : value.intValue();
    }

    default public @Nullable Long getLong(String key) {
        return this.get(key, Long.class);
    }

    default public long getLongOrDefault(String key, long defaultValue) {
        return this.getLongOrDefault(key, () -> defaultValue);
    }

    default public long getLongOrDefault(String key, LongSupplier defaultValue) {
        Long value = this.getLong(key);
        return value == null ? defaultValue.getAsLong() : value.longValue();
    }

    default public @Nullable String getString(String key) {
        return this.get(key, String.class);
    }

    default public String getStringOrDefault(String key, String defaultValue) {
        return this.getStringOrDefault(key, () -> defaultValue);
    }

    default public String getStringOrDefault(String key, Supplier<String> defaultValue) {
        String value = this.getString(key);
        return value == null ? defaultValue.get() : value;
    }

    public String toJson();

    public M fromJson(String var1);
}

