/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query.highlight;

import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.util.Assert;

public abstract class HighlightCommonParameters {
    private final String boundaryChars;
    private final int boundaryMaxScan;
    private final String boundaryScanner;
    private final String boundaryScannerLocale;
    private final boolean forceSource;
    private final String fragmenter;
    private final int fragmentSize;
    private final int noMatchSize;
    private final int numberOfFragments;
    private final @Nullable Query highlightQuery;
    private final String order;
    private final int phraseLimit;
    private final String[] preTags;
    private final String[] postTags;
    private final boolean requireFieldMatch;
    private final String type;

    protected HighlightCommonParameters(HighlightCommonParametersBuilder<?> builder) {
        Assert.notNull(builder, (String)"builder must not be null");
        this.boundaryChars = builder.boundaryChars;
        this.boundaryMaxScan = builder.boundaryMaxScan;
        this.boundaryScanner = builder.boundaryScanner;
        this.boundaryScannerLocale = builder.boundaryScannerLocale;
        this.forceSource = builder.forceSource;
        this.fragmenter = builder.fragmenter;
        this.fragmentSize = builder.fragmentSize;
        this.noMatchSize = builder.noMatchSize;
        this.numberOfFragments = builder.numberOfFragments;
        this.highlightQuery = builder.highlightQuery;
        this.order = builder.order;
        this.phraseLimit = builder.phraseLimit;
        this.preTags = builder.preTags;
        this.postTags = builder.postTags;
        this.requireFieldMatch = builder.requireFieldMatch;
        this.type = builder.type;
    }

    public String getBoundaryChars() {
        return this.boundaryChars;
    }

    public int getBoundaryMaxScan() {
        return this.boundaryMaxScan;
    }

    public String getBoundaryScanner() {
        return this.boundaryScanner;
    }

    public String getBoundaryScannerLocale() {
        return this.boundaryScannerLocale;
    }

    @Deprecated(since="5.5")
    public boolean getForceSource() {
        return this.forceSource;
    }

    public String getFragmenter() {
        return this.fragmenter;
    }

    public int getFragmentSize() {
        return this.fragmentSize;
    }

    public int getNoMatchSize() {
        return this.noMatchSize;
    }

    public int getNumberOfFragments() {
        return this.numberOfFragments;
    }

    public @Nullable Query getHighlightQuery() {
        return this.highlightQuery;
    }

    public String getOrder() {
        return this.order;
    }

    public int getPhraseLimit() {
        return this.phraseLimit;
    }

    public String[] getPreTags() {
        return this.preTags;
    }

    public String[] getPostTags() {
        return this.postTags;
    }

    public boolean getRequireFieldMatch() {
        return this.requireFieldMatch;
    }

    public String getType() {
        return this.type;
    }

    public static abstract class HighlightCommonParametersBuilder<SELF extends HighlightCommonParametersBuilder<SELF>> {
        private String boundaryChars = "";
        private int boundaryMaxScan = -1;
        private String boundaryScanner = "";
        private String boundaryScannerLocale = "";
        private boolean forceSource = false;
        private String fragmenter = "";
        private int fragmentSize = -1;
        private int noMatchSize = -1;
        private int numberOfFragments = -1;
        private @Nullable Query highlightQuery = null;
        private String order = "";
        private int phraseLimit = -1;
        private String[] preTags = new String[0];
        private String[] postTags = new String[0];
        private boolean requireFieldMatch = true;
        private String type = "";

        protected HighlightCommonParametersBuilder() {
        }

        public SELF withBoundaryChars(String boundaryChars) {
            this.boundaryChars = boundaryChars;
            return (SELF)this;
        }

        public SELF withBoundaryMaxScan(int boundaryMaxScan) {
            this.boundaryMaxScan = boundaryMaxScan;
            return (SELF)this;
        }

        public SELF withBoundaryScanner(String boundaryScanner) {
            this.boundaryScanner = boundaryScanner;
            return (SELF)this;
        }

        public SELF withBoundaryScannerLocale(String boundaryScannerLocale) {
            this.boundaryScannerLocale = boundaryScannerLocale;
            return (SELF)this;
        }

        @Deprecated(since="5.5")
        public SELF withForceSource(boolean forceSource) {
            this.forceSource = forceSource;
            return (SELF)this;
        }

        public SELF withFragmenter(String fragmenter) {
            this.fragmenter = fragmenter;
            return (SELF)this;
        }

        public SELF withFragmentSize(int fragmentSize) {
            this.fragmentSize = fragmentSize;
            return (SELF)this;
        }

        public SELF withNoMatchSize(int noMatchSize) {
            this.noMatchSize = noMatchSize;
            return (SELF)this;
        }

        public SELF withNumberOfFragments(int numberOfFragments) {
            this.numberOfFragments = numberOfFragments;
            return (SELF)this;
        }

        public SELF withHighlightQuery(@Nullable Query highlightQuery) {
            this.highlightQuery = highlightQuery;
            return (SELF)this;
        }

        public SELF withOrder(String order) {
            this.order = order;
            return (SELF)this;
        }

        public SELF withPhraseLimit(int phraseLimit) {
            this.phraseLimit = phraseLimit;
            return (SELF)this;
        }

        public SELF withPreTags(String ... preTags) {
            this.preTags = preTags;
            return (SELF)this;
        }

        public SELF withPostTags(String ... postTags) {
            this.postTags = postTags;
            return (SELF)this;
        }

        public SELF withRequireFieldMatch(boolean requireFieldMatch) {
            this.requireFieldMatch = requireFieldMatch;
            return (SELF)this;
        }

        public SELF withType(String type) {
            this.type = type;
            return (SELF)this;
        }

        public abstract HighlightCommonParameters build();
    }
}

