/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.support;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.MultiValueMapAdapter;

public class HttpHeaders
implements MultiValueMap<String, String> {
    public static final String AUTHORIZATION = "Authorization";
    private final MultiValueMap<String, @Nullable String> delegate = new MultiValueMapAdapter((Map)new LinkedCaseInsensitiveMap(Locale.ENGLISH));

    public @Nullable String getFirst(String key) {
        return (String)this.delegate.getFirst((Object)key);
    }

    public void add(String key, @Nullable String value) {
        this.delegate.add((Object)key, (Object)value);
    }

    public void addAll(String key, List<? extends @Nullable String> values) {
        this.delegate.addAll((Object)key, values);
    }

    public void addAll(MultiValueMap<String, @Nullable String> values) {
        this.delegate.addAll(values);
    }

    public void set(String key, @Nullable String value) {
        this.delegate.set((Object)key, (Object)value);
    }

    public void setAll(Map<String, @Nullable String> values) {
        this.delegate.setAll(values);
    }

    public Map<String, @Nullable String> toSingleValueMap() {
        return this.delegate.toSingleValueMap();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public @Nullable List<@Nullable String> get(Object key) {
        return (List)this.delegate.get(key);
    }

    public @Nullable List<@Nullable String> put(String key, List<@Nullable String> value) {
        return (List)this.delegate.put((Object)key, value);
    }

    public List<@Nullable String> remove(Object key) {
        return (List)this.delegate.remove(key);
    }

    public void putAll(Map<? extends String, ? extends List<String>> m) {
        Assert.notNull(m, (String)"m must not be null");
        this.delegate.putAll(m);
    }

    public void clear() {
        this.delegate.clear();
    }

    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    public Collection<List<String>> values() {
        return this.delegate.values();
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.delegate.entrySet();
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public void setBasicAuth(String username, String password) {
        Assert.notNull((Object)username, (String)"username must not be null");
        Assert.notNull((Object)password, (String)"password must not be null");
        this.set(AUTHORIZATION, "Basic " + HttpHeaders.encodeBasicAuth(username, password));
    }

    public static String encodeBasicAuth(String username, String password) {
        return HttpHeaders.encodeBasicAuth(username, password, null);
    }

    public static String encodeBasicAuth(String username, String password, @Nullable Charset charset) {
        CharsetEncoder encoder;
        Assert.notNull((Object)username, (String)"Username must not be null");
        Assert.doesNotContain((String)username, (String)":", (String)"Username must not contain a colon");
        Assert.notNull((Object)password, (String)"Password must not be null");
        if (charset == null) {
            charset = StandardCharsets.ISO_8859_1;
        }
        if ((encoder = charset.newEncoder()).canEncode(username) && encoder.canEncode(password)) {
            String credentialsString = username + ":" + password;
            byte[] encodedBytes = Base64.getEncoder().encode(credentialsString.getBytes(charset));
            return new String(encodedBytes, charset);
        }
        throw new IllegalArgumentException("Username or password contains characters that cannot be encoded to " + charset.displayName());
    }
}

