/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.ElasticsearchErrorCause;

public class ByQueryResponse {
    private final long took;
    private final boolean timedOut;
    private final long total;
    private final long updated;
    private final long deleted;
    private final int batches;
    private final long versionConflicts;
    private final long noops;
    private final long bulkRetries;
    private final long searchRetries;
    private final @Nullable String reasonCancelled;
    private final List<Failure> failures;
    private final List<SearchFailure> searchFailures;

    private ByQueryResponse(long took, boolean timedOut, long total, long updated, long deleted, int batches, long versionConflicts, long noops, long bulkRetries, long searchRetries, @Nullable String reasonCancelled, List<Failure> failures, List<SearchFailure> searchFailures) {
        this.took = took;
        this.timedOut = timedOut;
        this.total = total;
        this.updated = updated;
        this.deleted = deleted;
        this.batches = batches;
        this.versionConflicts = versionConflicts;
        this.noops = noops;
        this.bulkRetries = bulkRetries;
        this.searchRetries = searchRetries;
        this.reasonCancelled = reasonCancelled;
        this.failures = failures;
        this.searchFailures = searchFailures;
    }

    public long getTook() {
        return this.took;
    }

    public boolean getTimedOut() {
        return this.timedOut;
    }

    public long getTotal() {
        return this.total;
    }

    public long getUpdated() {
        return this.updated;
    }

    public long getDeleted() {
        return this.deleted;
    }

    public int getBatches() {
        return this.batches;
    }

    public long getVersionConflicts() {
        return this.versionConflicts;
    }

    public long getNoops() {
        return this.noops;
    }

    public long getBulkRetries() {
        return this.bulkRetries;
    }

    public long getSearchRetries() {
        return this.searchRetries;
    }

    public @Nullable String getReasonCancelled() {
        return this.reasonCancelled;
    }

    public List<Failure> getFailures() {
        return this.failures;
    }

    public List<SearchFailure> getSearchFailures() {
        return this.searchFailures;
    }

    public static ByQueryResponseBuilder builder() {
        return new ByQueryResponseBuilder();
    }

    public static final class ByQueryResponseBuilder {
        private long took;
        private boolean timedOut;
        private long total;
        private long updated;
        private long deleted;
        private int batches;
        private long versionConflicts;
        private long noops;
        private long bulkRetries;
        private long searchRetries;
        private @Nullable String reasonCancelled;
        private List<Failure> failures = Collections.emptyList();
        private List<SearchFailure> searchFailures = Collections.emptyList();

        private ByQueryResponseBuilder() {
        }

        public ByQueryResponseBuilder withTook(long took) {
            this.took = took;
            return this;
        }

        public ByQueryResponseBuilder withTimedOut(boolean timedOut) {
            this.timedOut = timedOut;
            return this;
        }

        public ByQueryResponseBuilder withTotal(long total) {
            this.total = total;
            return this;
        }

        public ByQueryResponseBuilder withUpdated(long updated) {
            this.updated = updated;
            return this;
        }

        public ByQueryResponseBuilder withDeleted(long deleted) {
            this.deleted = deleted;
            return this;
        }

        public ByQueryResponseBuilder withBatches(int batches) {
            this.batches = batches;
            return this;
        }

        public ByQueryResponseBuilder withVersionConflicts(long versionConflicts) {
            this.versionConflicts = versionConflicts;
            return this;
        }

        public ByQueryResponseBuilder withNoops(long noops) {
            this.noops = noops;
            return this;
        }

        public ByQueryResponseBuilder withBulkRetries(long bulkRetries) {
            this.bulkRetries = bulkRetries;
            return this;
        }

        public ByQueryResponseBuilder withSearchRetries(long searchRetries) {
            this.searchRetries = searchRetries;
            return this;
        }

        public ByQueryResponseBuilder withReasonCancelled(String reasonCancelled) {
            this.reasonCancelled = reasonCancelled;
            return this;
        }

        public ByQueryResponseBuilder withFailures(List<Failure> failures) {
            this.failures = failures;
            return this;
        }

        public ByQueryResponseBuilder withSearchFailure(List<SearchFailure> searchFailures) {
            this.searchFailures = searchFailures;
            return this;
        }

        public ByQueryResponse build() {
            return new ByQueryResponse(this.took, this.timedOut, this.total, this.updated, this.deleted, this.batches, this.versionConflicts, this.noops, this.bulkRetries, this.searchRetries, this.reasonCancelled, this.failures, this.searchFailures);
        }
    }

    public static class SearchFailure {
        private final Throwable reason;
        private final @Nullable Integer status;
        private final @Nullable String index;
        private final @Nullable Integer shardId;
        private final @Nullable String nodeId;

        private SearchFailure(Throwable reason, @Nullable Integer status, @Nullable String index, @Nullable Integer shardId, @Nullable String nodeId) {
            this.reason = reason;
            this.status = status;
            this.index = index;
            this.shardId = shardId;
            this.nodeId = nodeId;
        }

        public Throwable getReason() {
            return this.reason;
        }

        public @Nullable Integer getStatus() {
            return this.status;
        }

        public @Nullable String getIndex() {
            return this.index;
        }

        public @Nullable Integer getShardId() {
            return this.shardId;
        }

        public @Nullable String getNodeId() {
            return this.nodeId;
        }

        public static SearchFailureBuilder builder() {
            return new SearchFailureBuilder();
        }

        public static final class SearchFailureBuilder {
            private Throwable reason;
            private @Nullable Integer status;
            private @Nullable String index;
            private @Nullable Integer shardId;
            private @Nullable String nodeId;

            private SearchFailureBuilder() {
            }

            public SearchFailureBuilder withReason(Throwable reason) {
                this.reason = reason;
                return this;
            }

            public SearchFailureBuilder withStatus(Integer status) {
                this.status = status;
                return this;
            }

            public SearchFailureBuilder withIndex(String index) {
                this.index = index;
                return this;
            }

            public SearchFailureBuilder withShardId(Integer shardId) {
                this.shardId = shardId;
                return this;
            }

            public SearchFailureBuilder withNodeId(String nodeId) {
                this.nodeId = nodeId;
                return this;
            }

            public SearchFailure build() {
                return new SearchFailure(this.reason, this.status, this.index, this.shardId, this.nodeId);
            }
        }
    }

    public static class Failure {
        private final @Nullable String index;
        private final @Nullable String id;
        private final @Nullable Exception cause;
        private final @Nullable Integer status;
        private final @Nullable Long seqNo;
        private final @Nullable Long term;
        private final @Nullable Boolean aborted;
        private final @Nullable ElasticsearchErrorCause elasticsearchErrorCause;

        private Failure(@Nullable String index, @Nullable String id, @Nullable Exception cause, @Nullable Integer status, @Nullable Long seqNo, @Nullable Long term, @Nullable Boolean aborted, @Nullable ElasticsearchErrorCause elasticsearchErrorCause) {
            this.index = index;
            this.id = id;
            this.cause = cause;
            this.status = status;
            this.seqNo = seqNo;
            this.term = term;
            this.aborted = aborted;
            this.elasticsearchErrorCause = elasticsearchErrorCause;
        }

        public @Nullable String getIndex() {
            return this.index;
        }

        public @Nullable String getId() {
            return this.id;
        }

        public @Nullable Exception getCause() {
            return this.cause;
        }

        public @Nullable Integer getStatus() {
            return this.status;
        }

        public @Nullable Long getSeqNo() {
            return this.seqNo;
        }

        public @Nullable Long getTerm() {
            return this.term;
        }

        public @Nullable Boolean getAborted() {
            return this.aborted;
        }

        public @Nullable ElasticsearchErrorCause getElasticsearchErrorCause() {
            return this.elasticsearchErrorCause;
        }

        public static FailureBuilder builder() {
            return new FailureBuilder();
        }

        public static final class FailureBuilder {
            private @Nullable String index;
            private @Nullable String id;
            private @Nullable Exception cause;
            private @Nullable Integer status;
            private @Nullable Long seqNo;
            private @Nullable Long term;
            private @Nullable Boolean aborted;
            private @Nullable ElasticsearchErrorCause elasticsearchErrorCause;

            private FailureBuilder() {
            }

            public FailureBuilder withIndex(String index) {
                this.index = index;
                return this;
            }

            public FailureBuilder withId(String id) {
                this.id = id;
                return this;
            }

            public FailureBuilder withCause(Exception cause) {
                this.cause = cause;
                return this;
            }

            public FailureBuilder withStatus(Integer status) {
                this.status = status;
                return this;
            }

            public FailureBuilder withSeqNo(Long seqNo) {
                this.seqNo = seqNo;
                return this;
            }

            public FailureBuilder withTerm(Long term) {
                this.term = term;
                return this;
            }

            public FailureBuilder withAborted(Boolean aborted) {
                this.aborted = aborted;
                return this;
            }

            public FailureBuilder withErrorCause(ElasticsearchErrorCause elasticsearchErrorCause) {
                this.elasticsearchErrorCause = elasticsearchErrorCause;
                return this;
            }

            public Failure build() {
                return new Failure(this.index, this.id, this.cause, this.status, this.seqNo, this.term, this.aborted, this.elasticsearchErrorCause);
            }
        }
    }
}

