/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.query.BaseQuery;
import org.springframework.data.elasticsearch.core.query.DocValueField;
import org.springframework.data.elasticsearch.core.query.HighlightQuery;
import org.springframework.data.elasticsearch.core.query.IndexBoost;
import org.springframework.data.elasticsearch.core.query.IndicesOptions;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.RescorerQuery;
import org.springframework.data.elasticsearch.core.query.RuntimeField;
import org.springframework.data.elasticsearch.core.query.ScriptedField;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.util.Assert;

public abstract class BaseQueryBuilder<Q extends BaseQuery, SELF extends BaseQueryBuilder<Q, SELF>> {
    private @Nullable Sort sort;
    private @Nullable Pageable pageable;
    private final List<String> fields = new ArrayList<String>();
    private @Nullable List<String> storedFields;
    private @Nullable SourceFilter sourceFilter;
    private float minScore;
    private final Collection<String> ids = new ArrayList<String>();
    private @Nullable String route;
    private  @Nullable Query.SearchType searchType = Query.SearchType.QUERY_THEN_FETCH;
    private @Nullable IndicesOptions indicesOptions;
    private boolean trackScores;
    private @Nullable String preference;
    private @Nullable Integer maxResults;
    private @Nullable HighlightQuery highlightQuery;
    private @Nullable Boolean trackTotalHits;
    private @Nullable Integer trackTotalHitsUpTo;
    private @Nullable Duration scrollTime;
    private @Nullable Duration timeout;
    boolean explain = false;
    private @Nullable List<Object> searchAfter;
    private @Nullable List<IndexBoost> indicesBoost;
    protected final List<RescorerQuery> rescorerQueries = new ArrayList<RescorerQuery>();
    private @Nullable Boolean requestCache;
    private final List<Query.IdWithRouting> idsWithRouting = new ArrayList<Query.IdWithRouting>();
    private final List<RuntimeField> runtimeFields = new ArrayList<RuntimeField>();
    private  @Nullable Query.PointInTime pointInTime;
    private @Nullable Boolean allowNoIndices;
    private EnumSet<IndicesOptions.WildcardStates> expandWildcards = EnumSet.noneOf(IndicesOptions.WildcardStates.class);
    @Nullable Integer reactiveBatchSize;
    private final List<DocValueField> docValueFields = new ArrayList<DocValueField>();
    private final List<ScriptedField> scriptedFields = new ArrayList<ScriptedField>();

    public @Nullable Sort getSort() {
        return this.sort;
    }

    public @Nullable Pageable getPageable() {
        return this.pageable;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public @Nullable List<String> getStoredFields() {
        return this.storedFields;
    }

    public @Nullable Integer getMaxResults() {
        return this.maxResults;
    }

    public @Nullable Collection<String> getIds() {
        return this.ids;
    }

    public boolean getTrackScores() {
        return this.trackScores;
    }

    public @Nullable IndicesOptions getIndicesOptions() {
        return this.indicesOptions;
    }

    public float getMinScore() {
        return this.minScore;
    }

    public @Nullable String getPreference() {
        return this.preference;
    }

    public @Nullable SourceFilter getSourceFilter() {
        return this.sourceFilter;
    }

    public @Nullable HighlightQuery getHighlightQuery() {
        return this.highlightQuery;
    }

    public @Nullable String getRoute() {
        return this.route;
    }

    public @Nullable List<IndexBoost> getIndicesBoost() {
        return this.indicesBoost;
    }

    public  @Nullable Query.SearchType getSearchType() {
        return this.searchType;
    }

    public @Nullable Boolean getTrackTotalHits() {
        return this.trackTotalHits;
    }

    public @Nullable Integer getTrackTotalHitsUpTo() {
        return this.trackTotalHitsUpTo;
    }

    public @Nullable Duration getScrollTime() {
        return this.scrollTime;
    }

    public @Nullable Duration getTimeout() {
        return this.timeout;
    }

    public boolean getExplain() {
        return this.explain;
    }

    public @Nullable List<Object> getSearchAfter() {
        return this.searchAfter;
    }

    public @Nullable Boolean getRequestCache() {
        return this.requestCache;
    }

    public List<Query.IdWithRouting> getIdsWithRouting() {
        return this.idsWithRouting;
    }

    public List<RuntimeField> getRuntimeFields() {
        return this.runtimeFields;
    }

    public List<RescorerQuery> getRescorerQueries() {
        return this.rescorerQueries;
    }

    public  @Nullable Query.PointInTime getPointInTime() {
        return this.pointInTime;
    }

    public Integer getReactiveBatchSize() {
        return this.reactiveBatchSize;
    }

    public @Nullable Boolean getAllowNoIndices() {
        return this.allowNoIndices;
    }

    public EnumSet<IndicesOptions.WildcardStates> getExpandWildcards() {
        return this.expandWildcards;
    }

    public List<DocValueField> getDocValueFields() {
        return this.docValueFields;
    }

    public List<ScriptedField> getScriptedFields() {
        return this.scriptedFields;
    }

    public SELF withPageable(Pageable pageable) {
        this.pageable = pageable;
        return this.self();
    }

    public SELF withSort(Sort sort) {
        this.sort = this.sort == null ? sort : this.sort.and(sort);
        return this.self();
    }

    public SELF withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this.self();
    }

    public SELF withIds(String ... ids) {
        this.ids.clear();
        this.ids.addAll(Arrays.asList(ids));
        return this.self();
    }

    public SELF withIds(Collection<String> ids) {
        Assert.notNull(ids, (String)"ids must not be null");
        this.ids.clear();
        this.ids.addAll(ids);
        return this.self();
    }

    public SELF withTrackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this.self();
    }

    public SELF withIndicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this.self();
    }

    public SELF withMinScore(float minScore) {
        this.minScore = minScore;
        return this.self();
    }

    public SELF withPreference(String preference) {
        this.preference = preference;
        return this.self();
    }

    public SELF withSourceFilter(SourceFilter sourceFilter) {
        this.sourceFilter = sourceFilter;
        return this.self();
    }

    public SELF withFields(String ... fields) {
        this.fields.clear();
        Collections.addAll(this.fields, fields);
        return this.self();
    }

    public SELF withFields(Collection<String> fields) {
        Assert.notNull(fields, (String)"fields must not be null");
        this.fields.clear();
        this.fields.addAll(fields);
        return this.self();
    }

    public SELF withHighlightQuery(HighlightQuery highlightQuery) {
        this.highlightQuery = highlightQuery;
        return this.self();
    }

    public SELF withRoute(String route) {
        this.route = route;
        return this.self();
    }

    public SELF withIndicesBoost(@Nullable List<IndexBoost> indicesBoost) {
        this.indicesBoost = indicesBoost;
        return this.self();
    }

    public SELF withStoredFields(@Nullable List<String> storedFields) {
        this.storedFields = storedFields;
        return this.self();
    }

    public SELF withIndicesBoost(IndexBoost ... indicesBoost) {
        this.indicesBoost = Arrays.asList(indicesBoost);
        return this.self();
    }

    public SELF withSearchType( @Nullable Query.SearchType searchType) {
        this.searchType = searchType;
        return this.self();
    }

    public SELF withTrackTotalHits(@Nullable Boolean trackTotalHits) {
        this.trackTotalHits = trackTotalHits;
        return this.self();
    }

    public SELF withTrackTotalHitsUpTo(@Nullable Integer trackTotalHitsUpTo) {
        this.trackTotalHitsUpTo = trackTotalHitsUpTo;
        return this.self();
    }

    public SELF withTimeout(@Nullable Duration timeout) {
        this.timeout = timeout;
        return this.self();
    }

    public SELF withScrollTime(@Nullable Duration scrollTime) {
        this.scrollTime = scrollTime;
        return this.self();
    }

    public SELF withExplain(boolean explain) {
        this.explain = explain;
        return this.self();
    }

    public SELF withSearchAfter(@Nullable List<Object> searchAfter) {
        this.searchAfter = searchAfter;
        return this.self();
    }

    public SELF withRequestCache(@Nullable Boolean requestCache) {
        this.requestCache = requestCache;
        return this.self();
    }

    public SELF withIdsWithRouting(List<Query.IdWithRouting> idsWithRouting) {
        Assert.notNull(idsWithRouting, (String)"idsWithRouting must not be null");
        this.idsWithRouting.clear();
        this.idsWithRouting.addAll(idsWithRouting);
        return this.self();
    }

    public SELF withRuntimeFields(List<RuntimeField> runtimeFields) {
        Assert.notNull(runtimeFields, (String)"runtimeFields must not be null");
        this.runtimeFields.clear();
        this.runtimeFields.addAll(runtimeFields);
        return this.self();
    }

    public SELF withRescorerQueries(List<RescorerQuery> rescorerQueries) {
        Assert.notNull(rescorerQueries, (String)"rescorerQueries must not be null");
        this.rescorerQueries.clear();
        this.rescorerQueries.addAll(rescorerQueries);
        return this.self();
    }

    public SELF withRescorerQuery(RescorerQuery rescorerQuery) {
        Assert.notNull((Object)rescorerQuery, (String)"rescorerQuery must not be null");
        this.rescorerQueries.add(rescorerQuery);
        return this.self();
    }

    public SELF withPointInTime( @Nullable Query.PointInTime pointInTime) {
        this.pointInTime = pointInTime;
        return this.self();
    }

    public SELF withReactiveBatchSize(@Nullable Integer reactiveBatchSize) {
        this.reactiveBatchSize = reactiveBatchSize;
        return this.self();
    }

    public SELF withAllowNoIndices(@Nullable Boolean allowNoIndices) {
        this.allowNoIndices = allowNoIndices;
        return this.self();
    }

    public SELF withExpandWildcards(EnumSet<IndicesOptions.WildcardStates> expandWildcards) {
        Assert.notNull(expandWildcards, (String)"expandWildcards must not be null");
        this.expandWildcards = expandWildcards;
        return this.self();
    }

    public SELF withDocValueFields(List<DocValueField> docValueFields) {
        Assert.notNull(docValueFields, (String)"docValueFields must not be null");
        this.docValueFields.clear();
        this.docValueFields.addAll(docValueFields);
        return this.self();
    }

    public SELF withScriptedField(ScriptedField scriptedField) {
        Assert.notNull((Object)scriptedField, (String)"scriptedField must not be null");
        this.scriptedFields.add(scriptedField);
        return this.self();
    }

    public abstract Q build();

    private SELF self() {
        return (SELF)this;
    }
}

