/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.query.FetchSourceFilterBuilder;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.util.Assert;

public class FetchSourceFilter
implements SourceFilter {
    private final @Nullable Boolean fetchSource;
    private final @Nullable String[] includes;
    private final @Nullable String[] excludes;

    public static SourceFilter of(@Nullable Boolean fetchSource, @Nullable String[] includes, @Nullable String[] excludes) {
        return new FetchSourceFilter(fetchSource, includes, excludes);
    }

    public static SourceFilter of(Function<FetchSourceFilterBuilder, FetchSourceFilterBuilder> builderFunction) {
        Assert.notNull(builderFunction, (String)"builderFunction must not be null");
        return builderFunction.apply(new FetchSourceFilterBuilder()).build();
    }

    public FetchSourceFilter(@Nullable Boolean fetchSource, @Nullable String[] includes, @Nullable String[] excludes) {
        this.fetchSource = fetchSource;
        this.includes = includes;
        this.excludes = excludes;
    }

    @Override
    public Boolean fetchSource() {
        return this.fetchSource;
    }

    @Override
    public String[] getIncludes() {
        return this.includes;
    }

    @Override
    public String[] getExcludes() {
        return this.excludes;
    }
}

